/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.internal.launch.ClasspathEntry;
import org.eclipse.m2e.core.internal.launch.MavenExternalRuntime;
import org.eclipse.m2e.core.internal.launch.MavenWorkspaceRuntime;
import org.eclipse.m2e.core.internal.launch.ProjectClasspathEntry;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.components.MavenProjectLabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MavenInstallationWizardPage
extends WizardPage {
    private final List<ClasspathEntry> extensions;
    private Text location;
    private Button btnAddProject;
    private Button btnRemove;
    private Button btnUp;
    private Button btnDown;
    private TreeViewer treeViewerLibrariries;
    private Text name;
    private final AbstractMavenRuntime original;
    private Button btnExternal;
    private Button btnWorkspace;
    private Button btnDirectory;
    private final Set<String> usedNames;

    public MavenInstallationWizardPage(AbstractMavenRuntime original, Set<String> usedNames) {
        super(Messages.ExternalInstallPage_pageName);
        this.original = original;
        this.usedNames = usedNames;
        this.setDescription(Messages.ExternalInstallPage_description);
        this.extensions = original != null && original.getExtensions() != null ? original.getExtensions() : new ArrayList<ClasspathEntry>();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblInstallationType = new Label(container, 0);
        lblInstallationType.setText(Messages.MavenInstallationWizardPage_lblInstallationType_text);
        Composite composite = new Composite(container, 0);
        RowLayout rl_composite = new RowLayout(256);
        rl_composite.fill = true;
        composite.setLayout((Layout)rl_composite);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.btnExternal = new Button(composite, 16);
        this.btnExternal.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.changeRuntimeTypeAction()));
        this.btnExternal.setText(Messages.MavenInstallationWizardPage_btnExternal_text_1);
        this.btnWorkspace = new Button(composite, 16);
        this.btnWorkspace.setText(Messages.MavenInstallationWizardPage_btnWorkspace_text);
        Label lblInstallationLocation = new Label(container, 0);
        lblInstallationLocation.setText(Messages.ExternalInstallPage_lblInstallationLocation_text);
        this.location = new Text(container, 2048);
        this.location.addModifyListener(e -> this.updateStatus());
        this.location.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDirectory = new Button(container, 0);
        this.btnDirectory.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.selectLocationAction()));
        this.btnDirectory.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDirectory.setText(Messages.ExternalInstallPage_btnDirectory_text);
        Label lblInstallationName = new Label(container, 0);
        lblInstallationName.setText(Messages.ExternalInstallPage_lblInstallationName_text);
        this.name = new Text(container, 2048);
        this.name.addModifyListener(e -> this.updateStatus());
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblInstallationLibraries = new Label(container, 0);
        lblInstallationLibraries.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        lblInstallationLibraries.setText(Messages.ExternalInstallPage_lblInstallationLibraries_text);
        this.treeViewerLibrariries = new TreeViewer(container, 2048);
        this.treeViewerLibrariries.addSelectionChangedListener(event -> this.updateButtonsState());
        this.treeViewerLibrariries.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewerLibrariries.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.treeViewerLibrariries.setInput(this.extensions);
        Tree treeLibraries = this.treeViewerLibrariries.getTree();
        treeLibraries.setLayoutData((Object)new GridData(4, 4, true, true, 2, 5));
        this.btnAddProject = new Button(container, 0);
        this.btnAddProject.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.addProjectExtensionAction()));
        this.btnAddProject.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAddProject.setText(Messages.ExternalInstallPage_btnAddProject_text);
        this.btnRemove = new Button(container, 0);
        this.btnRemove.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.removeExtensionAction()));
        this.btnRemove.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnRemove.setText(Messages.ExternalInstallPage_btnRemove_text);
        this.btnUp = new Button(container, 0);
        this.btnUp.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.moveExtensionAction(-1)));
        this.btnUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUp.setText(Messages.ExternalInstallPage_btnUp_text);
        this.btnDown = new Button(container, 0);
        this.btnDown.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.moveExtensionAction(1)));
        this.btnDown.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDown.setText(Messages.ExternalInstallPage_btnDown_text);
        Button btnRestoreDefault = new Button(container, 0);
        btnRestoreDefault.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.resetExtensionsAction()));
        btnRestoreDefault.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        btnRestoreDefault.setText(Messages.ExternalInstallPage_btnRestoreDefault_text);
        if (this.original instanceof MavenExternalRuntime) {
            this.btnExternal.setSelection(true);
            this.location.setText(this.original.getLocation());
            if (!this.original.isLegacy()) {
                this.name.setText(this.original.getName());
            }
        }
        if (this.original instanceof MavenWorkspaceRuntime) {
            this.btnWorkspace.setSelection(true);
            this.name.setText(this.original.getName());
        } else {
            this.btnWorkspace.setEnabled(new MavenWorkspaceRuntime("test").isAvailable());
        }
        if (this.original == null) {
            this.btnExternal.setSelection(true);
        }
        this.updateButtonsState();
        this.updateStatus();
    }

    protected void changeRuntimeTypeAction() {
        this.location.setEnabled(this.btnExternal.getSelection());
        this.btnDirectory.setEnabled(this.btnExternal.getSelection());
        this.updateStatus();
    }

    protected void moveExtensionAction(int offset) {
        int from = this.extensions.indexOf(this.getSelectedElement());
        int to = Math.min(this.extensions.size() - 1, Math.max(0, from + offset));
        Collections.swap(this.extensions, from, to);
        this.treeViewerLibrariries.refresh();
    }

    protected void resetExtensionsAction() {
        this.extensions.clear();
        this.treeViewerLibrariries.refresh();
    }

    protected void removeExtensionAction() {
        Object selection = this.getSelectedElement();
        this.extensions.remove(selection);
        this.treeViewerLibrariries.refresh();
    }

    protected void updateButtonsState() {
        Object selection = this.getSelectedElement();
        boolean editEnabled = selection != null;
        this.btnUp.setEnabled(editEnabled);
        this.btnDown.setEnabled(editEnabled);
        this.btnRemove.setEnabled(editEnabled);
    }

    private Object getSelectedElement() {
        return ((IStructuredSelection)this.treeViewerLibrariries.getSelection()).getFirstElement();
    }

    protected void addProjectExtensionAction() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (IMavenProjectFacade facade : MavenPlugin.getMavenProjectRegistry().getProjects()) {
            IProject project = facade.getProject();
            if (this.contains(this.extensions, project)) continue;
            projects.add(project);
        }
        projects.sort(Comparator.comparing(IResource::getName));
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new MavenProjectLabelProvider());
        dialog.setElements(projects.toArray());
        dialog.setMessage(Messages.MavenInstallationWizardPage_selectProjectMessage);
        dialog.setTitle(Messages.MavenInstallationWizardPage_selectProjectTitle);
        dialog.setHelpAvailable(false);
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            Object insertionPoint = this.getSelectedElement();
            if (insertionPoint == null || insertionPoint instanceof ClasspathEntry) {
                int idx = Math.max(0, this.extensions.indexOf(insertionPoint));
                Object[] objectArray = dialog.getResult();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    this.extensions.add(idx, (ClasspathEntry)new ProjectClasspathEntry(((IProject)object).getName()));
                    ++n2;
                }
            } else {
                throw new IllegalStateException();
            }
            this.treeViewerLibrariries.refresh();
        }
    }

    protected boolean contains(List<ClasspathEntry> entries, IProject project) {
        for (ClasspathEntry entry : entries) {
            ProjectClasspathEntry projectEntry;
            if (!(entry instanceof ProjectClasspathEntry) || !(projectEntry = (ProjectClasspathEntry)entry).getProject().equals(project.getName())) continue;
            return true;
        }
        return false;
    }

    protected void selectLocationAction() {
        DirectoryDialog dlg = new DirectoryDialog(this.getShell());
        dlg.setText(Messages.MavenInstallationsPreferencePage_dialog_install_title);
        dlg.setMessage(Messages.MavenInstallationsPreferencePage_dialog_install_message);
        String dir = dlg.open();
        if (dir == null) {
            return;
        }
        this.location.setText(dir);
        if (this.name.getText().trim().isEmpty()) {
            this.name.setText(new File(dir).getName());
        }
    }

    private boolean isValidMavenInstall(String dir) {
        if (dir == null || dir.length() == 0) {
            return false;
        }
        File selectedDir = new File(dir);
        if (!selectedDir.isDirectory()) {
            return false;
        }
        return new MavenExternalRuntime(dir).isAvailable();
    }

    protected void updateStatus() {
        this.setPageComplete(false);
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.btnExternal.getSelection()) {
            if (this.location.getText().trim().isEmpty()) {
                this.setMessage(Messages.MavenInstallationWizardPage_messageSelectHomeDirectory);
                return;
            }
            if (!this.isValidMavenInstall(this.location.getText())) {
                this.setErrorMessage(Messages.MavenInstallationWizardPage_messageHomeDirectoryIsNotMavenInstll);
                return;
            }
        }
        if (this.name.getText().trim().isEmpty()) {
            this.setMessage(Messages.MavenInstallationWizardPage_messageSelectInstallatonName);
            return;
        }
        if (this.usedNames.contains(this.name.getText().trim())) {
            this.setErrorMessage(Messages.MavenInstallationWizardPage_messageDuplicateInstallationName);
            return;
        }
        this.setPageComplete(true);
    }

    public AbstractMavenRuntime getResult() {
        Object runtime = this.btnExternal.getSelection() ? new MavenExternalRuntime(this.name.getText(), this.location.getText()) : new MavenWorkspaceRuntime(this.name.getText());
        runtime.setExtensions(this.extensions);
        return runtime;
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class TreeLabelProvider
    implements ILabelProvider {
        TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ProjectClasspathEntry) {
                ProjectClasspathEntry entry = (ProjectClasspathEntry)element;
                return entry.getProject();
            }
            return element.toString();
        }
    }
}

