/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.RepositoryNode;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractRepositoriesNode
implements IMavenRepositoryNode {
    protected final IRepositoryRegistry repositoryRegistry = MavenPlugin.getRepositoryRegistry();

    @Override
    public Object[] getChildren() {
        ArrayList<RepositoryNode> mirrorNodes = new ArrayList<RepositoryNode>();
        ArrayList<RepositoryNode> globalRepoNodes = new ArrayList<RepositoryNode>();
        for (IRepository repo : this.getRepositories()) {
            RepositoryNode node = new RepositoryNode(repo);
            if (repo.getMirrorOf() != null) {
                mirrorNodes.add(node);
                continue;
            }
            globalRepoNodes.add(node);
        }
        ArrayList<RepositoryNode> nodes = new ArrayList<RepositoryNode>();
        nodes.addAll(mirrorNodes);
        nodes.addAll(globalRepoNodes);
        return nodes.toArray(new Object[nodes.size()]);
    }

    protected abstract List<IRepository> getRepositories();

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean hasChildren() {
        Object[] kids = this.getChildren();
        return kids != null && kids.length > 0;
    }

    @Override
    public Image getImage() {
        return MavenImages.IMG_INDEXES;
    }

    @Override
    public boolean isUpdating() {
        return false;
    }
}

