/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;

final class SortedSetDocValuesRangeQuery
extends Query {
    private final String field;
    private final BytesRef lowerValue;
    private final BytesRef upperValue;
    private final boolean lowerInclusive;
    private final boolean upperInclusive;

    SortedSetDocValuesRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        this.lowerInclusive = lowerInclusive && lowerValue != null;
        this.upperInclusive = upperInclusive && upperValue != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SortedSetDocValuesRangeQuery that = (SortedSetDocValuesRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Objects.equals(this.lowerValue, that.lowerValue) && Objects.equals(this.upperValue, that.upperValue) && this.lowerInclusive == that.lowerInclusive && this.upperInclusive == that.upperInclusive;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.lowerValue, this.upperValue, this.lowerInclusive, this.upperInclusive);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append(this.lowerInclusive ? "[" : "{").append(this.lowerValue == null ? "*" : this.lowerValue).append(" TO ").append(this.upperValue == null ? "*" : this.upperValue).append(this.upperInclusive ? "]" : "}").toString();
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.lowerValue == null && this.upperValue == null) {
            return new FieldExistsQuery(this.field);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            @Override
            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final 1 weight = this;
                if (context.reader().getFieldInfos().fieldInfo(SortedSetDocValuesRangeQuery.this.field) == null) {
                    return null;
                }
                final SortedSetDocValues values = DocValues.getSortedSet(context.reader(), SortedSetDocValuesRangeQuery.this.field);
                return new ScorerSupplier(){

                    @Override
                    public Scorer get(long leadCost) throws IOException {
                        long ord;
                        long maxOrd;
                        long ord2;
                        final long minOrd = SortedSetDocValuesRangeQuery.this.lowerValue == null ? 0L : ((ord2 = values.lookupTerm(SortedSetDocValuesRangeQuery.this.lowerValue)) < 0L ? -1L - ord2 : (SortedSetDocValuesRangeQuery.this.lowerInclusive ? ord2 : ord2 + 1L));
                        if (minOrd > (maxOrd = SortedSetDocValuesRangeQuery.this.upperValue == null ? values.getValueCount() - 1L : ((ord = values.lookupTerm(SortedSetDocValuesRangeQuery.this.upperValue)) < 0L ? -2L - ord : (SortedSetDocValuesRangeQuery.this.upperInclusive ? ord : ord - 1L)))) {
                            return new ConstantScoreScorer(weight, this.score(), scoreMode, DocIdSetIterator.empty());
                        }
                        final SortedDocValues singleton = DocValues.unwrapSingleton(values);
                        TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(singleton){

                            @Override
                            public boolean matches() throws IOException {
                                long ord = singleton.ordValue();
                                return ord >= minOrd && ord <= maxOrd;
                            }

                            @Override
                            public float matchCost() {
                                return 2.0f;
                            }
                        } : new TwoPhaseIterator(values){

                            @Override
                            public boolean matches() throws IOException {
                                for (int i = 0; i < values.docValueCount(); ++i) {
                                    long ord = values.nextOrd();
                                    if (ord < minOrd) continue;
                                    return ord <= maxOrd;
                                }
                                return false;
                            }

                            @Override
                            public float matchCost() {
                                return 2.0f;
                            }
                        };
                        return new ConstantScoreScorer(weight, this.score(), scoreMode, iterator);
                    }

                    @Override
                    public long cost() {
                        return values.cost();
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable(ctx, SortedSetDocValuesRangeQuery.this.field);
            }
        };
    }
}

