/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gpg.bc.internal;

import java.net.URISyntaxException;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.gpg.bc.internal.BCText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

class BouncyCastleGpgKeyPassphrasePrompt
implements AutoCloseable {
    private CredentialItem.Password passphrase;
    private CredentialsProvider credentialsProvider;

    public BouncyCastleGpgKeyPassphrasePrompt(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void clear() {
        if (this.passphrase != null) {
            this.passphrase.clear();
            this.passphrase = null;
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    private URIish createURI(Path keyLocation) throws URISyntaxException {
        return new URIish(keyLocation.toUri().toString());
    }

    public char[] getPassphrase(byte[] keyFingerprint, Path keyLocation) throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        if (this.passphrase == null) {
            this.passphrase = new CredentialItem.Password(BCText.get().credentialPassphrase);
        }
        if (this.credentialsProvider == null) {
            throw new PGPException(BCText.get().gpgNoCredentialsProvider);
        }
        if (this.passphrase.getValue() == null && !this.credentialsProvider.get(this.createURI(keyLocation), new CredentialItem[]{new CredentialItem.InformationalMessage(MessageFormat.format(BCText.get().gpgKeyInfo, Hex.toHexString((byte[])keyFingerprint))), this.passphrase})) {
            throw new CanceledException(BCText.get().gpgSigningCancelled);
        }
        return this.passphrase.getValue();
    }

    public boolean hasPassphrase() {
        return this.passphrase != null && this.passphrase.getValue() != null;
    }
}

