/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.composites;

import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.project.MavenProject;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.composites.DependenciesComposite;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.MavenPomEditor;
import org.eclipse.m2e.editor.pom.ValueProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DependencyLabelProvider
extends LabelProvider
implements IColorProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private MavenPomEditor pomEditor;
    private boolean showGroupId = false;
    private final boolean showManagedOverlay;
    private ValueProvider<List<Dependency>> valueProvider;

    public DependencyLabelProvider() {
        this(false);
    }

    public DependencyLabelProvider(boolean showManagedOverlay) {
        this.showManagedOverlay = showManagedOverlay;
    }

    public void setPomEditor(MavenPomEditor pomEditor, ValueProvider<List<Dependency>> valueProvider) {
        assert (pomEditor != null);
        this.pomEditor = pomEditor;
        this.valueProvider = valueProvider;
    }

    public void setShowGroupId(boolean showGroupId) {
        this.showGroupId = showGroupId;
    }

    public Color getForeground(Object element) {
        if (this.showManagedOverlay && element instanceof Dependency) {
            return Display.getDefault().getSystemColor(16);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    private String[] findManaged(DependenciesComposite.Dependency dep) {
        if (this.pomEditor != null) {
            MavenProject mp = this.pomEditor.getMavenProject();
            String version = null;
            String scope = null;
            if (mp != null) {
                String id = mp.getGroupId() + ":" + mp.getArtifactId() + ":" + mp.getVersion();
                DependencyManagement dm = mp.getDependencyManagement();
                if (dm != null) {
                    for (Dependency d : dm.getDependencies()) {
                        if (!d.getGroupId().equals(dep.groupId) || !d.getArtifactId().equals(dep.artifactId)) continue;
                        InputLocation location = d.getLocation((Object)"artifactId");
                        if (location != null && id.equals(location.getSource().getModelId())) {
                            version = d.getVersion();
                            scope = d.getScope();
                            break;
                        }
                        return new String[]{d.getVersion(), d.getScope()};
                    }
                }
            }
            List<Dependency> dm = this.valueProvider.getValue();
            for (Dependency modelDep : dm) {
                String modelGroupId = modelDep.getGroupId();
                String modelArtifactId = modelDep.getArtifactId();
                String modelVersion = modelDep.getVersion();
                String modelScope = modelDep.getScope();
                if (modelGroupId == null || !modelGroupId.equals(dep.groupId) || modelArtifactId == null || !modelArtifactId.equals(dep.artifactId)) continue;
                if (version != null && (modelVersion == null || modelVersion.contains("${"))) {
                    return new String[]{version, modelScope == null ? scope : modelScope};
                }
                return new String[]{modelVersion, modelScope == null ? scope : modelScope};
            }
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof DependenciesComposite.Dependency) {
            DependenciesComposite.Dependency dep = (DependenciesComposite.Dependency)element;
            StyledString ss = new StyledString(this.getText(element));
            String[] managed = this.findManaged(dep);
            if (managed != null && managed[0] != null) {
                Object man = managed[0];
                if (managed[1] != null && !"compile".equals(managed[1])) {
                    man = (String)man + "," + managed[1];
                }
                ss.append(NLS.bind((String)Messages.DependencyLabelProvider_0, (Object)man), StyledString.DECORATIONS_STYLER);
            }
            return ss;
        }
        return new StyledString(this.getText(element));
    }

    public String getText(Object element) {
        if (element instanceof DependenciesComposite.Dependency) {
            DependenciesComposite.Dependency dependency = (DependenciesComposite.Dependency)element;
            return this.getText(dependency.groupId, dependency.artifactId, dependency.version, dependency.classifier, dependency.type, dependency.scope);
        }
        if (element instanceof Dependency) {
            Dependency dependency = (Dependency)element;
            return this.getText(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), dependency.getType(), dependency.getScope());
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof DependenciesComposite.Dependency) {
            DependenciesComposite.Dependency dependency = (DependenciesComposite.Dependency)element;
            boolean isManaged = this.showManagedOverlay && this.findManaged(dependency) != null;
            return this.getImage(dependency.groupId, dependency.artifactId, dependency.version, isManaged);
        }
        if (element instanceof Dependency) {
            Dependency dependency = (Dependency)element;
            if (!this.showManagedOverlay) {
                return this.getImage(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), false);
            }
            return MavenEditorImages.IMG_INHERITED;
        }
        return null;
    }

    private Image getImage(String groupId, String artifactId, String version, boolean isManaged) {
        IMavenProjectRegistry projectManager;
        IMavenProjectFacade projectFacade;
        MavenProject mavenProject;
        if ((version == null || version.indexOf("${") > -1) && this.pomEditor != null && (mavenProject = this.pomEditor.getMavenProject()) != null) {
            Artifact artifact = (Artifact)mavenProject.getArtifactMap().get(groupId + ":" + artifactId);
            if (artifact != null) {
                version = artifact.getVersion();
            }
            if (version == null || version.indexOf("${") > -1) {
                Collection artifacts = mavenProject.getManagedVersionMap().values();
                for (Artifact a : artifacts) {
                    if (!a.getGroupId().equals(groupId) || !a.getArtifactId().equals(artifactId)) continue;
                    version = a.getVersion();
                    break;
                }
            }
        }
        if (groupId != null && artifactId != null && version != null && (projectFacade = (projectManager = MavenPlugin.getMavenProjectRegistry()).getMavenProject(groupId, artifactId, version)) != null) {
            return isManaged ? MavenImages.getOverlayImage((String)"project_obj.png", (String)"lock_ovr.png", (int)2) : MavenEditorImages.IMG_PROJECT;
        }
        return isManaged ? MavenImages.getOverlayImage((String)"jar_obj.png", (String)"lock_ovr.png", (int)2) : MavenEditorImages.IMG_JAR;
    }

    private String getText(String groupId, String artifactId, String version, String classifier, String type, String scope) {
        StringBuilder sb = new StringBuilder();
        if (this.showGroupId) {
            sb.append(this.isEmpty(groupId) ? "?" : groupId).append(" : ");
        }
        sb.append(this.isEmpty(artifactId) ? "?" : artifactId);
        if (!this.isEmpty(version)) {
            sb.append(" : ").append(version);
        }
        if (!this.isEmpty(classifier)) {
            sb.append(" : ").append(classifier);
        }
        if (!this.isEmpty(type)) {
            sb.append(" : ").append(type);
        }
        if (!this.isEmpty(scope)) {
            sb.append(" [").append(scope).append(']');
        }
        return sb.toString();
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

