/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.heapwalking;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JDIAllInstancesValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.ui.DebugWorkingCopyManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaWordFinder;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.heapwalking.BaseInstanceActionDelegate;
import org.eclipse.jdt.internal.debug.ui.heapwalking.Messages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AllInstancesActionDelegate
extends BaseInstanceActionDelegate
implements IEditorActionDelegate {
    public void run(IAction action) {
        ISelectionProvider provider;
        if (this.getPart() != null && (provider = this.getPart().getSite().getSelectionProvider()) != null) {
            ISelection selection = provider.getSelection();
            if (this.getPart() instanceof IEditorPart && selection instanceof ITextSelection) {
                IJavaElement element;
                IDocument document;
                IRegion selectedWord;
                ITextEditor editor = this.getTextEditor(this.getPart());
                IDocumentProvider documentProvider = editor.getDocumentProvider();
                if (documentProvider != null && (selectedWord = JavaWordFinder.findWord(document = documentProvider.getDocument((Object)editor.getEditorInput()), ((ITextSelection)selection).getOffset())) != null && (element = this.getJavaElement(editor.getEditorInput())) instanceof ICodeAssist) {
                    try {
                        IJavaElement[] selectedTypes = ((ICodeAssist)element).codeSelect(selectedWord.getOffset(), selectedWord.getLength());
                        if (selectedTypes.length > 0) {
                            this.runForSelection(action, selectedTypes[0]);
                            return;
                        }
                    }
                    catch (JavaModelException e) {
                        JDIDebugUIPlugin.log(e.getStatus());
                        this.report(Messages.AllInstancesActionDelegate_0, this.getPart());
                    }
                }
            } else if (selection instanceof IStructuredSelection) {
                this.runForSelection(action, ((IStructuredSelection)selection).getFirstElement());
                return;
            }
        }
        this.report(Messages.AllInstancesActionDelegate_3, this.getPart());
    }

    protected void runForSelection(IAction action, Object selectedElement) {
        if (selectedElement != null) {
            IJavaType type = null;
            try {
                IJavaDebugTarget target;
                IAdaptable adapt;
                if (selectedElement instanceof IMethod && ((IMethod)selectedElement).isConstructor()) {
                    selectedElement = ((IMethod)selectedElement).getDeclaringType();
                }
                if (selectedElement instanceof IType && (adapt = DebugUITools.getDebugContext()) != null && (target = (IJavaDebugTarget)adapt.getAdapter(IJavaDebugTarget.class)) != null) {
                    IType itype = (IType)selectedElement;
                    IJavaType[] types = target.getJavaTypes(itype.getFullyQualifiedName());
                    if (types != null && types.length > 0) {
                        type = types[0];
                    } else {
                        this.displayNoInstances(action, target, itype.getFullyQualifiedName());
                        return;
                    }
                }
                if (selectedElement instanceof IJavaVariable) {
                    IJavaVariable var = (IJavaVariable)selectedElement;
                    IValue val = var.getValue();
                    if (val instanceof IJavaValue) {
                        type = ((IJavaValue)val).getJavaType();
                    }
                    if (type == null) {
                        type = var.getJavaType();
                    }
                }
            }
            catch (JavaModelException e) {
                JDIDebugUIPlugin.log(e.getStatus());
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.log(e.getStatus());
            }
            if (type instanceof JDIReferenceType) {
                this.displayInstaces(action, (JDIReferenceType)type);
                return;
            }
        }
        this.report(Messages.AllInstancesActionDelegate_3, this.getPart());
    }

    protected void displayNoInstances(IAction action, IJavaDebugTarget target, String typeName) {
        this.displayPopup(action, (JDIDebugTarget)target, null, typeName);
    }

    protected void displayInstaces(IAction action, JDIReferenceType rtype) {
        try {
            this.displayPopup(action, (JDIDebugTarget)rtype.getDebugTarget(), rtype, rtype.getName());
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.log(e);
            this.report(Messages.AllInstancesActionDelegate_0, this.getPart());
        }
    }

    private void displayPopup(IAction action, JDIDebugTarget target, JDIReferenceType rtype, String name) {
        JDIAllInstancesValue aiv = new JDIAllInstancesValue(target, rtype);
        InspectPopupDialog ipd = new InspectPopupDialog(this.getShell(), this.getAnchor(), "org.eclipse.jdt.debug.ui.commands.Inspect", (IExpression)new JavaInspectExpression(NLS.bind((String)Messages.AllInstancesActionDelegate_2, (Object[])new String[]{name}), (IJavaValue)aiv));
        ipd.open();
        ipd.getTreeViewer().addDoubleClickListener(event -> this.handleDoubleClick(action, event));
    }

    protected void report(final String message, final IWorkbenchPart part) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
            }
        });
    }

    protected Point getAnchor() {
        PageBookView view;
        IPage page;
        Tree tree;
        TreeItem[] selection;
        Control control;
        IDebugView debugView = (IDebugView)this.getPart().getAdapter(IDebugView.class);
        if (debugView != null && (control = debugView.getViewer().getControl()) instanceof Tree && (selection = (tree = (Tree)control).getSelection()).length > 0) {
            Rectangle bounds = selection[0].getBounds();
            return tree.toDisplay(new Point(bounds.x, bounds.y + bounds.height));
        }
        Control widget = (Control)this.getPart().getAdapter(Control.class);
        if (widget == null && this.getPart() instanceof PageBookView && (page = (view = (PageBookView)this.getPart()).getCurrentPage()) != null) {
            widget = page.getControl();
        }
        if (widget instanceof StyledText) {
            StyledText textWidget = (StyledText)widget;
            Point docRange = textWidget.getSelectionRange();
            int midOffset = docRange.x + docRange.y / 2;
            Point point = textWidget.getLocationAtOffset(midOffset);
            point = textWidget.toDisplay(point);
            GC gc = new GC((Drawable)textWidget);
            gc.setFont(textWidget.getFont());
            int height = gc.getFontMetrics().getHeight();
            gc.dispose();
            point.y += height;
            return point;
        }
        if (widget instanceof Tree && (selection = (tree = (Tree)widget).getSelection()).length > 0) {
            Rectangle bounds = selection[0].getBounds();
            return tree.toDisplay(new Point(bounds.x, bounds.y + bounds.height));
        }
        return null;
    }

    private IJavaElement getJavaElement(IEditorInput input) {
        IJavaElement je = JavaUI.getEditorInputJavaElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return DebugWorkingCopyManager.getWorkingCopy(input, false);
    }

    private ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setActivePart(action, (IWorkbenchPart)targetEditor);
    }

    protected Shell getShell() {
        if (this.fWindow != null) {
            return this.fWindow.getShell();
        }
        if (this.getWorkbenchWindow() != null) {
            return this.getWorkbenchWindow().getShell();
        }
        return null;
    }
}

