/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.ws.internal.consumption.codegen.Visitor;
import org.eclipse.jst.ws.internal.consumption.codegen.VisitorAction;
import org.eclipse.jst.ws.internal.consumption.command.common.JavaMofReflectionCommand;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeFactory;

public class JavaMofFieldVisitor
implements Visitor {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private String clientProject;

    public void setProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public String getProject() {
        return this.clientProject;
    }

    @Override
    public IStatus run(Object javaclass, VisitorAction vAction) {
        IStatus status = Status.OK_STATUS;
        JavaClass javaClass = (JavaClass)javaclass;
        boolean holderClass = false;
        EList implemented = javaClass.getImplementsInterfaces();
        int i = 0;
        while (i < implemented.size()) {
            JavaClass anInterface = (JavaClass)implemented.get(i);
            if (anInterface.getQualifiedName().equals("javax.xml.rpc.holders.Holder")) {
                holderClass = true;
            }
            ++i;
        }
        if (holderClass) {
            EList e = javaClass.getFields();
            ListIterator list = e.listIterator();
            while (list.hasNext()) {
                Field field = (Field)list.next();
                if (field.getJavaVisibility().getValue() != 0 || field.isFinal() || field.isStatic() || !this.fieldCheck(field)) continue;
                status = vAction.visit(field);
            }
        }
        return status;
    }

    private boolean fieldCheck(Field field) {
        JavaMofReflectionCommand javaMofRef = new JavaMofReflectionCommand();
        javaMofRef.setProxyBean(((JavaHelpers)field.getEType()).getQualifiedName());
        javaMofRef.setClientProject(this.getProject());
        javaMofRef.execute(null, null);
        if (javaMofRef.getJavaClass() instanceof JavaClass) {
            if (TypeFactory.recognizedBean(javaMofRef.getJavaClass().getJavaName())) {
                return true;
            }
            return this.defaultCheck((JavaClass)javaMofRef.getJavaClass());
        }
        return true;
    }

    private boolean defaultCheck(JavaClass javaClass) {
        Iterator m = javaClass.getMethods().iterator();
        boolean defaultConst = true;
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (!javaClass.getName().equals(method.getName())) continue;
            JavaParameter[] javaParameter = method.listParametersWithoutReturn();
            if (javaParameter.length > 0) {
                defaultConst = false;
                continue;
            }
            if (javaParameter.length != 0) continue;
            if (method.getJavaVisibility().getValue() == 0) {
                return true;
            }
            if (method.getJavaVisibility().getValue() != 1) continue;
            defaultConst = false;
        }
        return defaultConst;
    }
}

