/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.ui.internal.TMUIMessages;

public final class GrammarInfoWidget
extends Composite {
    private final Text nameText;
    private final Text scopeNameText;
    private final Text fileTypesText;

    public GrammarInfoWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        super.setLayout((Layout)layout);
        super.setLayoutData((Object)new GridData(1808));
        Composite container = new Composite((Composite)this, 0);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        containerLayout.marginLeft = 0;
        containerLayout.marginRight = 0;
        container.setLayout((Layout)containerLayout);
        container.setLayoutData((Object)new GridData(1808));
        Label grammarNameLabel = new Label(container, 0);
        grammarNameLabel.setText(TMUIMessages.GrammarInfoWidget_name_text);
        this.nameText = new Text(container, 2056);
        this.nameText.setLayoutData((Object)new GridData(768));
        Label grammarScopeNameLabel = new Label(container, 0);
        grammarScopeNameLabel.setText(TMUIMessages.GrammarInfoWidget_scopeName_text);
        this.scopeNameText = new Text(container, 2056);
        this.scopeNameText.setLayoutData((Object)new GridData(768));
        Label grammarFileTypesLabel = new Label(container, 0);
        grammarFileTypesLabel.setText(TMUIMessages.GrammarInfoWidget_fileTypes_text);
        this.fileTypesText = new Text(container, 2056);
        this.fileTypesText.setLayoutData((Object)GridDataFactory.fillDefaults().hint(100, -1).create());
    }

    public void refresh(@Nullable IGrammar grammar) {
        if (grammar == null) {
            this.nameText.setText("");
            this.scopeNameText.setText("");
            this.fileTypesText.setText("");
        } else {
            String name = grammar.getName();
            this.nameText.setText(name != null ? name : "");
            String scope = grammar.getScopeName();
            this.scopeNameText.setText(scope);
            Collection fileTypes = grammar.getFileTypes();
            String types = fileTypes.stream().map(Object::toString).collect(Collectors.joining(","));
            this.fileTypesText.setText(types);
        }
    }

    public Text getGrammarNameText() {
        return this.nameText;
    }

    public Text getScopeNameText() {
        return this.scopeNameText;
    }

    public Text getFileTypesText() {
        return this.fileTypesText;
    }
}

