/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.Alerts;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class JSFUICommonPlugin
extends AbstractUIPlugin {
    private static final String PROPERTIES = "default.properties";
    private static final String P_CONSOLE_LOGGING = "console.logging.on";
    private static final String P_CONSOLE_LOG_LEVEL = "console.logging.max.level";
    private static final String P_ECLIPSE_LOGGING = "eclipse.logging.on";
    private static final String P_ECLIPSE_LOG_LEVEL = "eclipse.logging.max.level";
    private static final String P_FILE_LOGGING = "file.logging.on";
    private static final String P_FILE_LOG_LEVEL = "file.logging.max.level";
    private static final String P_FILE_PATH = "file.logging.path";
    private static final String P_FILE_CLEAR = "file.logging.startup.clear";
    private static final String P_FILE_ROLLOVER_FREQUENCY = "file.logging.rollover.frequency";
    private static final int DEBUG_LEVEL = 0;
    private static final int INFO_LEVEL = 1;
    private static final int WARN_LEVEL = 2;
    private static final int ERROR_LEVEL = 3;
    private static final int FATAL_LEVEL = 4;
    private static boolean TWO_DOT_ONE;
    private static boolean THREE_DOT;
    private static String _version;
    private static JSFUICommonPlugin _plugin;
    private Logger _log;
    private ResourceBundle _resourceBundle;
    private Properties _properties;
    private URL _pluginBase;
    private static Alerts _alerts;

    public JSFUICommonPlugin() {
        _plugin = this;
        this.versionCheck();
    }

    private void versionCheck() {
        String version = (String)ResourcesPlugin.getPlugin().getBundle().getHeaders().get("Bundle-Version");
        Version identifier = new Version(version);
        TWO_DOT_ONE = identifier.getMajor() == 2 && identifier.getMinor() == 1;
        THREE_DOT = identifier.getMajor() == 3;
        _version = identifier.toString();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (!JSFUICommonPlugin.isThreeDot()) {
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Requires eclipse version 3.x", null));
        }
        try {
            this._resourceBundle = ResourceBundle.getBundle("org.eclipse.jst.jsf.common.ui.CommonResources");
            _alerts = new Alerts(this, this._resourceBundle);
            this._properties = new Properties();
            InputStream input = null;
            this._pluginBase = this.getBundle().getEntry("/");
            try {
                input = new URL(this._pluginBase, PROPERTIES).openStream();
                this._properties.load(input);
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
            this._log = new Logger(this.getBundle(), this._resourceBundle);
        }
        catch (Exception ee) {
            if (this._log != null) {
                this._log.error("log.msg", "Problems starting plug-in Web Application Development Common.", ee);
            }
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Problems starting plug-in Web Application Development Common", (Throwable)ee));
        }
    }

    public static JSFUICommonPlugin getDefault() {
        return _plugin;
    }

    public static Alerts getAlerts() {
        return _alerts;
    }

    public static Logger getLogger(Class theClass) {
        return JSFUICommonPlugin.getDefault().getRootLogger();
    }

    public Logger getRootLogger() {
        return this._log;
    }

    public static String getPluginId() {
        return JSFUICommonPlugin.getDefault().getBundle().getSymbolicName();
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JSFUICommonPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getPluginDecriptorBundle() {
        return Platform.getResourceBundle((Bundle)JSFUICommonPlugin.getDefault().getBundle());
    }

    public Properties getProperties() {
        return this._properties;
    }

    public Image getImage(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        Image image = images.get(name);
        if (image == null) {
            try {
                ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(this._pluginBase, "icons/" + name));
                images.put(name, id);
                image = images.get(name);
            }
            catch (MalformedURLException ee) {
                this._log.error("log.msg", "log.CommonPlugin.image.error", name, ee);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        ImageDescriptor id = images.getDescriptor(name);
        if (id == null) {
            try {
                id = ImageDescriptor.createFromURL((URL)new URL(this._pluginBase, "icons/" + name));
                images.put(name, id);
            }
            catch (MalformedURLException ee) {
                this._log.error("log.msg", "log.CommonPlugin.image.error", name, ee);
            }
        }
        return id;
    }

    public static boolean isTwoDotOne() {
        return TWO_DOT_ONE;
    }

    public static boolean isThreeDot() {
        return THREE_DOT;
    }

    public static String getVersion() {
        return _version;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(P_CONSOLE_LOGGING, this._properties.getProperty(P_CONSOLE_LOGGING, Boolean.TRUE.toString()));
        store.setDefault(P_CONSOLE_LOG_LEVEL, this.strToIntLogLevel(this._properties.getProperty(P_CONSOLE_LOG_LEVEL, "ERROR")));
        store.setDefault(P_ECLIPSE_LOGGING, this._properties.getProperty(P_ECLIPSE_LOGGING, Boolean.TRUE.toString()));
        store.setDefault(P_ECLIPSE_LOG_LEVEL, this.strToIntLogLevel(this._properties.getProperty(P_ECLIPSE_LOG_LEVEL, "ERROR")));
        store.setDefault(P_FILE_LOGGING, this._properties.getProperty(P_FILE_LOGGING, Boolean.FALSE.toString()));
        store.setDefault(P_FILE_LOG_LEVEL, this.strToIntLogLevel(this._properties.getProperty(P_FILE_LOG_LEVEL, "ERROR")));
        store.setDefault(P_FILE_PATH, this._properties.getProperty(P_FILE_PATH, ""));
        store.setDefault(P_FILE_CLEAR, this._properties.getProperty(P_FILE_CLEAR, Boolean.TRUE.toString()));
        store.setDefault(P_FILE_ROLLOVER_FREQUENCY, this._properties.getProperty(P_FILE_ROLLOVER_FREQUENCY, "DAILY"));
    }

    private int strToIntLogLevel(String str) {
        if (str == null) {
            return 3;
        }
        if (str.equalsIgnoreCase("DEBUG")) {
            return 0;
        }
        if (str.equalsIgnoreCase("INFO")) {
            return 1;
        }
        if (str.equalsIgnoreCase("WARN")) {
            return 2;
        }
        if (str.equalsIgnoreCase("FATAL")) {
            return 4;
        }
        return 3;
    }
}

