/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.DDLGeneratorWrapper;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.IDDLGeneratorWrapper;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.IDDLProvider;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectImmutableModel;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;

public abstract class AbstractSchemaObjectEditModel
implements ISchemaObjectEditModel {
    protected SQLObject _mainObject;
    protected Map _additionalObjects;
    protected EcoreUtil.Copier _copier;
    protected ISchemaObjectImmutableModel _immutableModel;
    protected ChangeDescription _changeDescription;
    protected ChangeRecorder _changeRecorder;
    protected DatabaseIdentifier _dIdentifier;
    protected IDDLGeneratorWrapper _dGeneratorWrapper;
    protected String _backupedDDL;
    protected Resource _resource;

    public AbstractSchemaObjectEditModel(ISchemaObjectImmutableModel model, DatabaseIdentifier databaseIdentifier) {
        this._immutableModel = model;
        this._dIdentifier = databaseIdentifier;
        this._dGeneratorWrapper = new DDLGeneratorWrapper(this._dIdentifier);
        this._additionalObjects = new HashMap();
        this.generateEditModel();
    }

    @Override
    public Map getAdditionalSQLObjects() {
        return this._additionalObjects;
    }

    @Override
    public EcoreUtil.Copier getCopier() {
        return this._copier;
    }

    @Override
    public SQLObject getMainSQLObject() {
        return this._mainObject;
    }

    @Override
    public ISchemaObjectImmutableModel getSchemaObjectImmutableModel() {
        return this._immutableModel;
    }

    @Override
    public int refreshFromDB() {
        if (this._immutableModel != null && this._mainObject != null) {
            this._immutableModel.refreshFromDB(this._mainObject.getName());
        }
        if (this._immutableModel.getMainSQLObject() == null) {
            this.promptObjectLost();
            return 1;
        }
        this.generateEditModel();
        return 0;
    }

    @Override
    public void revert() {
        this.generateEditModel();
    }

    @Override
    public boolean checkModelExistence() {
        boolean isExist = this._immutableModel.isModelExist();
        if (!isExist) {
            this.promptObjectLost();
        }
        return isExist;
    }

    private void promptObjectLost() {
        try {
            IDDLProvider provider = (IDDLProvider)this.getAdapter(IDDLProvider.class);
            if (provider != null) {
                this._backupedDDL = provider.getDDL();
            }
        }
        catch (Exception exception) {
            this._backupedDDL = null;
        }
        this._mainObject = null;
    }

    protected void generateEditModel() {
        this.cloneSQLObjects();
        this.createAndAttachNecessaryTempObjects();
        this.startLogging();
    }

    protected void cloneSQLObjects() {
        this._copier = this.createCopier();
        this._copier.copy((EObject)this._immutableModel.getMainSQLObject());
        Map additionalObjs = this._immutableModel.getAdditionalSQLObjects();
        if (additionalObjs != null) {
            for (Object key : additionalObjs.keySet()) {
                Object value = additionalObjs.get(key);
                if (value instanceof Collection) {
                    Collection col = (Collection)value;
                    if (col == null) continue;
                    boolean itemsValid = true;
                    Iterator colIter = col.iterator();
                    while (colIter.hasNext()) {
                        if (colIter.next() instanceof EObject) continue;
                        itemsValid = false;
                    }
                    if (!itemsValid) continue;
                    Collection duplicates = this._copier.copyAll(col);
                    this._additionalObjects.put(key, duplicates);
                    continue;
                }
                if (!(value instanceof EObject)) continue;
                EObject obj = this._copier.copy((EObject)value);
                this._additionalObjects.put(key, obj);
            }
        }
        this._copier.copyReferences();
        this._mainObject = (SQLObject)this._copier.get((Object)this._immutableModel.getMainSQLObject());
    }

    protected EcoreUtil.Copier createCopier() {
        return new EcoreUtil.Copier();
    }

    protected abstract void createAndAttachNecessaryTempObjects();

    @Override
    public void startLogging() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this._resource = resourceSet.createResource(URI.createURI((String)"test.ecore"));
        this._resource.getContents().add((Object)this._mainObject);
        this._changeDescription = ChangeFactory.eINSTANCE.createChangeDescription();
        this._changeRecorder = new ChangeRecorder();
        this._changeRecorder.beginRecording(this._changeDescription, Collections.singletonList(this._mainObject));
    }

    @Override
    public void stopLogging() {
        this._changeRecorder.endRecording();
    }

    @Override
    public String getDeltaDDL() {
        return this.getDeltaDDL((EObject)this._mainObject, this._changeDescription);
    }

    protected String getDeltaDDL(EObject eObject, ChangeDescription _changeSummary) {
        if (this._dGeneratorWrapper == null) {
            this._dGeneratorWrapper = new DDLGeneratorWrapper(this._dIdentifier);
        }
        String currentUser = ProfileUtil.getProfileUserName((DatabaseIdentifier)this._dIdentifier, (boolean)false);
        String targetUser = ModelUtil.getSchemaName((EObject)eObject);
        this._dGeneratorWrapper.setGenSetUser(currentUser != null && !currentUser.equals(targetUser));
        String[] deltaDDL = this._dGeneratorWrapper.generateDeltaDDL(eObject, _changeSummary, null);
        return this.formatDeltaDDL(deltaDDL);
    }

    protected String formatDeltaDDL(String[] deltaDDL) {
        if (deltaDDL != null) {
            StringBuffer sb = new StringBuffer("");
            int i = 0;
            while (i < deltaDDL.length) {
                if (deltaDDL[i] != null && deltaDDL[i].trim().length() != 0 && !deltaDDL[i].equals("null")) {
                    sb.append(deltaDDL[i]);
                    sb.append(System.getProperty("line.separator"));
                    String delimiter = this.getSQLDelimiter();
                    if (delimiter == null) {
                        delimiter = "";
                    }
                    sb.append(this.getSQLDelimiter());
                    sb.append(System.getProperty("line.separator"));
                }
                ++i;
            }
            return sb.toString();
        }
        return "";
    }

    protected abstract String getSQLDelimiter();

    @Override
    public String getEditorTooltipText() {
        StringBuffer sb = new StringBuffer("");
        sb.append("(").append(this._dIdentifier.getProfileName()).append(")");
        if (this._immutableModel == null || this._immutableModel.getMainSQLObject() == null) {
            return "";
        }
        EObject root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)this._immutableModel.getMainSQLObject());
        if (root != null && root instanceof Database) {
            sb.append(ModelUtil.getDatabaseName((EObject)this._immutableModel.getMainSQLObject())).append(".");
            String schemaName = new String();
            if (this._mainObject instanceof Table) {
                schemaName = ((Table)this._mainObject).getSchema().getName();
            } else if (this._mainObject instanceof Routine) {
                schemaName = ((Routine)this._mainObject).getSchema().getName();
            }
            sb.append(schemaName);
        }
        sb.append(this._immutableModel.getMainSQLObject().getName());
        return sb.toString();
    }

    public String getBackupedDDL() {
        return this._backupedDDL;
    }
}

