/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.op.EGitGpgConfig;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.FormatJob;
import org.eclipse.egit.ui.internal.history.GitCommitReference;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.lib.SignatureVerifiers;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.jgit.util.SignatureUtils;
import org.eclipse.osgi.util.NLS;

public class CommitInfoBuilder {
    private static final String LF = "\n";
    private static final int MAXBRANCHES = 20;
    private PlotCommit<?> commit;
    private final Repository db;
    private final boolean fill;
    private final Collection<Ref> allRefs;
    private final PreferenceBasedDateFormatter dateFormatter;

    public CommitInfoBuilder(Repository db, PlotCommit commit, boolean fill, Collection<Ref> allRefs) {
        this.db = db;
        this.commit = commit;
        this.fill = fill;
        this.allRefs = allRefs;
        this.dateFormatter = PreferenceBasedDateFormatter.create();
    }

    public FormatJob.FormatResult format(IProgressMonitor monitor) throws IOException {
        String tagsString;
        RevWalk rw32;
        Throwable e2;
        boolean trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        monitor.setTaskName(UIText.CommitMessageViewer_FormattingMessageTaskName);
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        StringBuilder d = new StringBuilder();
        PersonIdent author = this.commit.getAuthorIdent();
        PersonIdent committer = this.commit.getCommitterIdent();
        ArrayList<GitCommitReference> hyperlinks = new ArrayList<GitCommitReference>();
        d.append(UIText.CommitMessageViewer_commit);
        d.append(' ');
        d.append(this.commit.getId().name());
        d.append(LF);
        PlotCommit<?> c = this.commit;
        if (preferences.getBoolean("HistoryView_VerifySignatures") && c.getRawGpgSignature() != null) {
            EGitGpgConfig cfg = new EGitGpgConfig((Config)this.db.getConfig());
            try {
                Repository repo = this.db;
                assert (repo != null);
                SignatureVerifier.SignatureVerification verification = SignatureVerifiers.verify((Repository)repo, (GpgConfig)cfg, c);
                if (verification != null) {
                    String[] text = SignatureUtils.toString((SignatureVerifier.SignatureVerification)verification, (PersonIdent)committer, (GitDateFormatter)this.dateFormatter).split(LF);
                    String prefix = verification.verifierName();
                    String[] stringArray = text;
                    int n = text.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        d.append(prefix).append(": ").append(line).append(LF);
                        ++n2;
                    }
                }
            }
            catch (IOException | JGitInternalException e2) {
                Activator.logError("Cannot verify signature on commit " + this.commit.name(), e2);
                d.append(UIText.CommitMessageViewer_signatureVerificationFailed).append(LF);
            }
        }
        this.addPersonIdent(d, author, UIText.CommitMessageViewer_author);
        this.addPersonIdent(d, committer, UIText.CommitMessageViewer_committer);
        int i = 0;
        while (i < this.commit.getParentCount()) {
            this.addCommit(d, (SWTCommit)this.commit.getParent(i), UIText.CommitMessageViewer_parent, hyperlinks);
            ++i;
        }
        i = 0;
        while (i < this.commit.getChildCount()) {
            this.addCommit(d, (SWTCommit)this.commit.getChild(i), UIText.CommitMessageViewer_child, hyperlinks);
            ++i;
        }
        if (preferences.getBoolean("HistoryView_ShowBranchSequence")) {
            try {
                Throwable i2 = null;
                e2 = null;
                try {
                    rw32 = new RevWalk(this.db);
                    try {
                        List<Ref> branches = CommitInfoBuilder.getBranches(this.commit, this.allRefs, this.db, monitor);
                        Collections.sort(branches, CommonUtils.REF_ASCENDING_COMPARATOR);
                        if (!branches.isEmpty()) {
                            d.append(UIText.CommitMessageViewer_branches);
                            d.append(": ");
                            int count = 0;
                            Iterator<Ref> i3 = branches.iterator();
                            while (i3.hasNext()) {
                                Ref head = i3.next();
                                RevCommit p = rw32.parseCommit((AnyObjectId)head.getObjectId());
                                this.addLink(d, this.formatHeadRef(head), hyperlinks, p);
                                if (!i3.hasNext()) continue;
                                if (count++ <= 20) {
                                    d.append(", ");
                                    continue;
                                }
                                d.append(NLS.bind((String)UIText.CommitMessageViewer_MoreBranches, (Object)(branches.size() - 20)));
                                break;
                            }
                            d.append(LF);
                        }
                    }
                    finally {
                        if (rw32 != null) {
                            rw32.close();
                        }
                    }
                }
                catch (Throwable e2) {
                    if (i2 == null) {
                        i2 = e2;
                    } else if (i2 != e2) {
                        i2.addSuppressed(e2);
                    }
                    throw i2;
                }
            }
            catch (IOException e3) {
                Activator.logError(e3.getMessage(), e3);
            }
        }
        if ((tagsString = this.getTagsString()).length() > 0) {
            d.append(UIText.CommitMessageViewer_tags);
            d.append(": ");
            d.append(tagsString);
            d.append(LF);
        }
        if (preferences.getBoolean("HistoryView_ShowTagSequence")) {
            RevWalk rw;
            try {
                e2 = null;
                rw32 = null;
                try {
                    rw = new RevWalk(this.db);
                    try {
                        monitor.setTaskName(UIText.CommitMessageViewer_GettingPreviousTagTaskName);
                        this.addTag(d, UIText.CommitMessageViewer_follows, rw, this.getNextTag(false, monitor), hyperlinks);
                    }
                    finally {
                        if (rw != null) {
                            rw.close();
                        }
                    }
                }
                catch (Throwable rw32) {
                    if (e2 == null) {
                        e2 = rw32;
                    } else if (e2 != rw32) {
                        e2.addSuppressed(rw32);
                    }
                    throw e2;
                }
            }
            catch (IOException e4) {
                Activator.logError(e4.getMessage(), e4);
            }
            try {
                e2 = null;
                rw32 = null;
                try {
                    rw = new RevWalk(this.db);
                    try {
                        monitor.setTaskName(UIText.CommitMessageViewer_GettingNextTagTaskName);
                        this.addTag(d, UIText.CommitMessageViewer_precedes, rw, this.getNextTag(true, monitor), hyperlinks);
                    }
                    finally {
                        if (rw != null) {
                            rw.close();
                        }
                    }
                }
                catch (Throwable rw32) {
                    if (e2 == null) {
                        e2 = rw32;
                    } else if (e2 != rw32) {
                        e2.addSuppressed(rw32);
                    }
                    throw e2;
                }
            }
            catch (IOException e5) {
                Activator.logError(e5.getMessage(), e5);
            }
        }
        d.append(LF);
        int headerEnd = d.length();
        String msg = this.commit.getFullMessage().trim();
        int footerStart = CommonUtils.getFooterOffset(msg);
        if (footerStart >= 0) {
            if (this.fill) {
                String footer = msg.substring(footerStart);
                msg = msg.substring(0, footerStart);
                msg = String.valueOf(msg.replaceAll("([\\w.,; \t])\n(\\w)", "$1 $2")) + footer;
                footerStart = headerEnd + msg.length() - footer.length();
            } else {
                footerStart = headerEnd + footerStart;
            }
        } else if (this.fill) {
            msg = msg.replaceAll("([\\w.,; \t])\n(\\w)", "$1 $2");
        }
        d.append(msg);
        if (!msg.endsWith(LF)) {
            d.append(LF);
        }
        if (trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        return new FormatJob.FormatResult(d.toString(), hyperlinks, headerEnd, footerStart >= 0 ? footerStart : d.length());
    }

    private void addLink(StringBuilder d, String linkLabel, Collection<GitCommitReference> hyperlinks, RevCommit to) {
        if (to != null) {
            hyperlinks.add(new GitCommitReference(to, (IRegion)new Region(d.length(), linkLabel.length())));
        }
        d.append(linkLabel);
    }

    private void addLink(StringBuilder d, Collection<GitCommitReference> hyperlinks, RevCommit to) {
        this.addLink(d, to.getId().name(), hyperlinks, to);
    }

    private void addPersonIdent(StringBuilder d, PersonIdent ident, String label) {
        if (ident != null) {
            d.append(label).append(": ");
            d.append(ident.getName().trim());
            d.append(" <").append(ident.getEmailAddress().trim()).append("> ");
            d.append(this.dateFormatter.formatDate(ident));
            d.append(LF);
        }
    }

    private void addCommit(StringBuilder d, SWTCommit gitcommit, String label, List<GitCommitReference> hyperlinks) throws IOException {
        if (gitcommit != null) {
            d.append(label).append(": ");
            gitcommit.parseBody();
            this.addLink(d, hyperlinks, (RevCommit)gitcommit);
            d.append(" (").append(gitcommit.getShortMessage()).append(')');
            d.append(LF);
        }
    }

    private void addTag(StringBuilder d, String label, RevWalk walk, Ref tag, List<GitCommitReference> hyperlinks) throws IOException {
        if (tag != null) {
            d.append(label).append(": ");
            RevCommit p = walk.parseCommit((AnyObjectId)tag.getObjectId());
            this.addLink(d, this.formatTagRef(tag), hyperlinks, p);
            d.append(LF);
        }
    }

    private static List<Ref> getBranches(RevCommit commit, Collection<Ref> allRefs, Repository db, IProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        EclipseGitProgressTransformer progress = new EclipseGitProgressTransformer((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)allRefs.size()));
        Throwable throwable = null;
        Object var6_7 = null;
        try (RevWalk revWalk = new RevWalk(db);){
            revWalk.setRetainBody(false);
            return RevWalkUtils.findBranchesReachableFrom((RevCommit)commit, (RevWalk)revWalk, allRefs, (ProgressMonitor)progress);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String formatHeadRef(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/heads/")) {
            return name.substring("refs/heads/".length());
        }
        if (name.startsWith("refs/remotes/")) {
            return name.substring("refs/remotes/".length());
        }
        return name;
    }

    private String formatTagRef(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/tags/")) {
            return name.substring("refs/tags/".length());
        }
        return name;
    }

    private String getTagsString() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Ref ref : this.db.getRefDatabase().getRefsByPrefix("refs/tags/")) {
            ObjectId target = ref.getPeeledObjectId();
            if (target == null) {
                target = ref.getObjectId();
            }
            if (target == null || !target.equals(this.commit)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.formatTagRef(ref));
        }
        return sb.toString();
    }

    private Ref getNextTag(boolean searchDescendant, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk revWalk = new RevWalk(this.db);){
            revWalk.setRetainBody(false);
            Ref tagRef = null;
            for (Ref ref : this.db.getRefDatabase().getRefsByPrefix("refs/tags/")) {
                RevCommit newTag;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                RevCommit current = revWalk.parseCommit(this.commit);
                RevObject any = revWalk.peel(revWalk.parseAny((AnyObjectId)ref.getObjectId()));
                if (!(any instanceof RevCommit) || (newTag = (RevCommit)any).getId().equals(this.commit) || !this.isMergedInto(revWalk, newTag, current, searchDescendant)) continue;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (tagRef != null) {
                    RevCommit oldTag = revWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
                    if (!this.isMergedInto(revWalk, oldTag, newTag, searchDescendant)) continue;
                    tagRef = ref;
                    continue;
                }
                tagRef = ref;
            }
            return tagRef;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean isMergedInto(RevWalk rw, RevCommit base, RevCommit tip, boolean swap) throws IOException {
        return !swap ? rw.isMergedInto(base, tip) : rw.isMergedInto(tip, base);
    }
}

