/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.variables;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDIModelPresentation;
import org.eclipse.jdt.internal.debug.ui.variables.JavaVariableColumnPresentation;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.FontData;

public class JavaVariableLabelProvider
extends VariableLabelProvider
implements IEclipsePreferences.IPreferenceChangeListener {
    public static JDIModelPresentation fLabelProvider = new JDIModelPresentation();
    private final Map<String, Boolean> fQualifiedNameSettings = new HashMap<String, Boolean>();
    private boolean fQualifiedNames = false;
    private int fSerializeMode = 1;
    private static final int SERIALIZE_ALL = 0;
    private static final int SERIALIZE_NONE = 1;
    private static final int SERIALIZE_SOME = 2;

    public JavaVariableLabelProvider() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugUIPlugin.getUniqueIdentifier());
        if (prefs != null) {
            prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.determineSerializationMode(prefs.get(IJDIPreferencesConstants.PREF_SHOW_DETAILS, "DETAIL_PANE"));
        }
    }

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        if (value instanceof IJavaValue) {
            return fLabelProvider.getFormattedValueText((IJavaValue)value);
        }
        return super.getValueText(variable, value, context);
    }

    protected String getValueTypeName(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = value.getReferenceTypeName();
            if (!this.fQualifiedNames) {
                return fLabelProvider.removeQualifierFromGenericName(typeName);
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return typeName;
    }

    protected FontData getFontData(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        IJavaVariable variable;
        IValue value;
        FontData result = super.getFontData(elementPath, presentationContext, columnId);
        if (result == null) {
            return result;
        }
        Object element = elementPath.getLastSegment();
        if (element instanceof IJavaVariable && (value = (variable = (IJavaVariable)element).getValue()) instanceof IJavaObject && ((IJavaObject)value).getLabel() != null) {
            return new FontData(result.getName(), result.getHeight(), result.getStyle() ^ 1);
        }
        return result;
    }

    protected String getVariableTypeName(IVariable variable, IPresentationContext context) throws CoreException {
        String typeName = DebugUIMessages.JDIModelPresentation_unknown_type__2;
        try {
            typeName = variable.getReferenceTypeName();
            if (!this.fQualifiedNames) {
                return fLabelProvider.removeQualifierFromGenericName(typeName);
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return typeName;
    }

    private Boolean isShowQualfiiedNames(IPresentationContext context) {
        Boolean qualified = this.fQualifiedNameSettings.get(context.getId());
        if (qualified == null) {
            qualified = Platform.getPreferencesService().getBoolean(JDIDebugUIPlugin.getUniqueIdentifier(), context.getId() + "." + IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES, false, null);
            this.fQualifiedNameSettings.put(context.getId(), qualified);
        }
        return qualified;
    }

    protected String getColumnText(IVariable variable, IValue value, IPresentationContext context, String columnId) throws CoreException {
        if (JavaVariableColumnPresentation.COLUMN_INSTANCE_ID.equals(columnId)) {
            long uniqueId;
            if (value instanceof JDIObjectValue && (uniqueId = ((JDIObjectValue)value).getUniqueId()) >= 0L) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(uniqueId);
                return buffer.toString();
            }
            return "";
        }
        if (JavaVariableColumnPresentation.COLUMN_INSTANCE_COUNT.equals(columnId)) {
            if (value instanceof IJavaObject) {
                IJavaType jType = ((IJavaObject)value).getJavaType();
                if (jType == null && variable instanceof IJavaVariable) {
                    jType = ((IJavaVariable)variable).getJavaType();
                }
                if (jType instanceof IJavaReferenceType && !(jType instanceof IJavaInterfaceType)) {
                    long count = ((IJavaReferenceType)jType).getInstanceCount();
                    if (count == -1L) {
                        return DebugUIMessages.JavaVariableLabelProvider_0;
                    }
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(count);
                    return buffer.toString();
                }
            }
            return "";
        }
        if (JavaVariableColumnPresentation.COLUMN_LABEL.equals(columnId)) {
            String label;
            if (value instanceof IJavaObject && (label = ((IJavaObject)value).getLabel()) != null) {
                return label;
            }
            return "";
        }
        return super.getColumnText(variable, value, context, columnId);
    }

    protected void retrieveLabel(ILabelUpdate update) throws CoreException {
        Boolean showQ = this.isShowQualfiiedNames(update.getPresentationContext());
        this.fQualifiedNames = showQ;
        fLabelProvider.setAttribute("DISPLAY_QUALIFIED_NAMES", showQ);
        super.retrieveLabel(update);
    }

    private void determineSerializationMode(String value) {
        this.fSerializeMode = "INLINE_ALL".equals(value) ? 1 : ("INLINE_FORMATTERS".equals(value) ? 2 : 0);
    }

    protected String getLabel(TreePath elementPath, IPresentationContext context, String columnId) throws CoreException {
        IDebugModelPresentation presentation;
        if (columnId == null && (presentation = this.getModelPresentation(context, JDIDebugModel.getPluginIdentifier())) != null) {
            return presentation.getText(elementPath.getLastSegment());
        }
        return super.getLabel(elementPath, context, columnId);
    }

    protected ISchedulingRule getRule(ILabelUpdate update) {
        IJavaStackFrame frame = null;
        switch (this.fSerializeMode) {
            case 1: {
                return null;
            }
            case 0: {
                Object input = update.getViewerInput();
                frame = (IJavaStackFrame)DebugPlugin.getAdapter((Object)input, IJavaStackFrame.class);
                break;
            }
            case 2: {
                Object element = update.getElement();
                if (!(element instanceof IJavaVariable)) break;
                try {
                    IValue value = ((IJavaVariable)element).getValue();
                    if (!(value instanceof IJavaValue) || fLabelProvider.isShowLabelDetails((IJavaValue)value)) break;
                    Object input = update.getViewerInput();
                    frame = (IJavaStackFrame)DebugPlugin.getAdapter((Object)input, IJavaStackFrame.class);
                    break;
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
            }
        }
        if (frame != null) {
            return ((JDIThread)frame.getThread()).getThreadRule();
        }
        return null;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().endsWith(IJDIPreferencesConstants.PREF_SHOW_QUALIFIED_NAMES)) {
            this.fQualifiedNameSettings.clear();
        } else if (event.getKey().equals(IJDIPreferencesConstants.PREF_SHOW_DETAILS)) {
            this.determineSerializationMode((String)event.getNewValue());
        }
    }
}

