/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.repo;

import aQute.bnd.build.Project;
import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.RepositoryPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.pde.bnd.ui.HyperlinkStyler;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.pde.bnd.ui.model.repo.ContinueSearchElement;
import org.eclipse.pde.bnd.ui.model.repo.LoadingContentElement;
import org.eclipse.pde.bnd.ui.model.repo.ProjectBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundleVersion;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryResourceElement;
import org.eclipse.swt.graphics.Image;

public class RepositoryTreeLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    final Image arrowImg = Resources.getImage("arrow_down.png");
    final Image bundleImg = Resources.getImage("bundle.png");
    final Image matchImg = Resources.getImage("star-small.png");
    final Image projectImg = Resources.getImage("$IMG_OBJ_PROJECT");
    final Image loadingImg = Resources.getImage("loading_16x16.gif");
    private final boolean showRepoId;

    public RepositoryTreeLabelProvider(boolean showRepoId) {
        this.showRepoId = showRepoId;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int index = cell.getColumnIndex();
        StyledString label = new StyledString();
        Image image = null;
        try {
            if (element instanceof RepositoryPlugin) {
                if (index == 0) {
                    RepositoryPlugin repo = (RepositoryPlugin)element;
                    String status = repo.getStatus();
                    String name = null;
                    if (repo instanceof Actionable) {
                        name = ((Actionable)repo).title(new Object[0]);
                    }
                    if (name == null) {
                        name = repo.getName();
                    }
                    label.append(name);
                    if (status != null) {
                        label.append(" : ");
                        label.append(status, StyledString.QUALIFIER_STYLER);
                    }
                    image = Resources.getImage(repo.getIcon());
                }
            } else if (element instanceof Project) {
                if (index == 0) {
                    Project project = (Project)element;
                    boolean isOk = project.isOk();
                    label.append(project.getName());
                    if (this.showRepoId) {
                        label.append(" ");
                        label.append("[Workspace]", StyledString.QUALIFIER_STYLER);
                    }
                    if (!isOk) {
                        label.append(" ");
                        label.append("Errors: " + project.getErrors().size(), StyledString.COUNTER_STYLER);
                    }
                    image = this.projectImg;
                }
            } else if (element instanceof ProjectBundle) {
                if (index == 0) {
                    ProjectBundle projectBundle = (ProjectBundle)element;
                    label.append(projectBundle.getBsn());
                    if (this.showRepoId) {
                        label.append(" ");
                        if (projectBundle.isSub()) {
                            label.append("[Workspace:" + String.valueOf(projectBundle.getProject()) + "]", StyledString.QUALIFIER_STYLER);
                        } else {
                            label.append("[Workspace]", StyledString.QUALIFIER_STYLER);
                        }
                    }
                    image = this.bundleImg;
                }
            } else if (element instanceof RepositoryBundle) {
                if (index == 0) {
                    RepositoryBundle bundle = (RepositoryBundle)element;
                    label.append(bundle.getText());
                    if (this.showRepoId) {
                        label.append(" ");
                        label.append("[" + bundle.getRepo().getName() + "]", StyledString.QUALIFIER_STYLER);
                    }
                    image = this.bundleImg;
                }
            } else if (element instanceof RepositoryBundleVersion) {
                if (index == 0) {
                    RepositoryBundleVersion bundleVersion = (RepositoryBundleVersion)element;
                    String versionText = bundleVersion.getText();
                    if (versionText.contains(" \u21e9")) {
                        versionText = versionText.replaceAll(" \u21e9", "");
                        image = this.arrowImg;
                    }
                    label.append(versionText, StyledString.COUNTER_STYLER);
                }
            } else if (element instanceof RepositoryResourceElement) {
                RepositoryResourceElement resourceElem = (RepositoryResourceElement)element;
                label.append(resourceElem.getIdentity()).append(" ");
                label.append(resourceElem.getVersionString(), StyledString.COUNTER_STYLER);
                image = this.matchImg;
            } else if (element instanceof ContinueSearchElement) {
                label.append("Continue Search on repository...", (StyledString.Styler)new HyperlinkStyler());
                image = null;
            } else if (element instanceof LoadingContentElement) {
                label.append(element.toString());
                image = this.loadingImg;
            } else if (element != null) {
                label.append(element.toString());
            }
        }
        catch (Exception e) {
            label.append("error: " + Exceptions.causes((Throwable)e));
            image = Resources.getImage("error");
        }
        cell.setText(label.getString());
        cell.setStyleRanges(label.getStyleRanges());
        cell.setImage(image);
    }

    public String getToolTipText(Object element) {
        try {
            if (element instanceof Actionable) {
                return ((Actionable)element).tooltip(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.arrowImg;
    }

    public String getText(Object element) {
        if (element instanceof RepositoryPlugin) {
            RepositoryPlugin rp = (RepositoryPlugin)element;
            return rp.getName();
        }
        if (element instanceof Project) {
            Project pr = (Project)element;
            return pr.getName();
        }
        if (element instanceof ProjectBundle) {
            ProjectBundle pb = (ProjectBundle)element;
            return pb.getBsn();
        }
        if (element instanceof RepositoryBundle) {
            RepositoryBundle rb = (RepositoryBundle)element;
            return rb.getText();
        }
        if (element instanceof RepositoryBundleVersion) {
            RepositoryBundleVersion rbv = (RepositoryBundleVersion)element;
            return rbv.getText();
        }
        if (element instanceof RepositoryResourceElement) {
            RepositoryResourceElement re = (RepositoryResourceElement)element;
            return re.getIdentity();
        }
        return element.toString();
    }
}

