/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal;

import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.DefaultTypedConfigGetter;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.FS;

public class ReportingTypedConfigGetter
extends DefaultTypedConfigGetter {
    public boolean getBoolean(Config config, String section, String subsection, String name, boolean defaultValue) {
        try {
            return super.getBoolean(config, section, subsection, name, defaultValue);
        }
        catch (IllegalArgumentException e) {
            ReportingTypedConfigGetter.warn(config, ReportingTypedConfigGetter.join(section, subsection, name), Boolean.toString(defaultValue), e);
            return defaultValue;
        }
    }

    public <T extends Enum<?>> T getEnum(Config config, T[] all, String section, String subsection, String name, T defaultValue) {
        try {
            return (T)super.getEnum(config, all, section, subsection, name, defaultValue);
        }
        catch (IllegalArgumentException e) {
            String valueUsed = null;
            if (defaultValue instanceof Config.ConfigEnum) {
                valueUsed = ((Config.ConfigEnum)defaultValue).toConfigValue();
            } else if (defaultValue != null) {
                valueUsed = defaultValue.toString().toLowerCase(Locale.ROOT);
            }
            ReportingTypedConfigGetter.warn(config, ReportingTypedConfigGetter.join(section, subsection, name), valueUsed, e);
            return defaultValue;
        }
    }

    public int getInt(Config config, String section, String subsection, String name, int defaultValue) {
        try {
            return super.getInt(config, section, subsection, name, defaultValue);
        }
        catch (IllegalArgumentException e) {
            ReportingTypedConfigGetter.warn(config, ReportingTypedConfigGetter.join(section, subsection, name), Integer.toString(defaultValue), e);
            return defaultValue;
        }
    }

    public int getIntInRange(Config config, String section, String subsection, String name, int minValue, int maxValue, int defaultValue) {
        try {
            return super.getIntInRange(config, section, subsection, name, minValue, maxValue, defaultValue);
        }
        catch (IllegalArgumentException e) {
            ReportingTypedConfigGetter.warn(config, ReportingTypedConfigGetter.join(section, subsection, name), Integer.toString(defaultValue), e);
            return defaultValue;
        }
    }

    public long getLong(Config config, String section, String subsection, String name, long defaultValue) {
        try {
            return super.getLong(config, section, subsection, name, defaultValue);
        }
        catch (IllegalArgumentException e) {
            ReportingTypedConfigGetter.warn(config, ReportingTypedConfigGetter.join(section, subsection, name), Long.toString(defaultValue), e);
            return defaultValue;
        }
    }

    public long getTimeUnit(Config config, String section, String subsection, String name, long defaultValue, TimeUnit wantUnit) {
        try {
            return super.getTimeUnit(config, section, subsection, name, defaultValue, wantUnit);
        }
        catch (IllegalArgumentException e) {
            ReportingTypedConfigGetter.warn(config, ReportingTypedConfigGetter.join(section, subsection, name), String.valueOf(Long.toString(defaultValue)) + ' ' + ReportingTypedConfigGetter.toString(wantUnit), e);
            return defaultValue;
        }
    }

    public Path getPath(Config config, String section, String subsection, String name, @NonNull FS fs, File resolveAgainst, Path defaultValue) {
        try {
            return super.getPath(config, section, subsection, name, fs, resolveAgainst, defaultValue);
        }
        catch (IllegalArgumentException e) {
            ReportingTypedConfigGetter.warn(config, ReportingTypedConfigGetter.join(section, subsection, name), defaultValue == null ? null : defaultValue.toString(), e);
            return defaultValue;
        }
    }

    @NonNull
    public List<RefSpec> getRefSpecs(Config config, String section, String subsection, String name) {
        String[] values = config.getStringList(section, subsection, name);
        ArrayList<RefSpec> result = new ArrayList<RefSpec>(values.length);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String spec = stringArray[n2];
            try {
                result.add(new RefSpec(spec));
            }
            catch (IllegalArgumentException e) {
                ReportingTypedConfigGetter.warn(config, ReportingTypedConfigGetter.join(section, subsection, name), null, e);
            }
            ++n2;
        }
        return result;
    }

    private static void warn(Config config, String entry, String defaultValue, Throwable cause) {
        String location = null;
        if (config instanceof FileBasedConfig) {
            File file = ((FileBasedConfig)config).getFile();
            location = file.getAbsolutePath();
        }
        Activator.logWarning(ReportingTypedConfigGetter.msg(location, entry, defaultValue), cause);
    }

    private static String msg(String location, String entry, String defaultValue) {
        if (location == null) {
            if (defaultValue == null) {
                return MessageFormat.format(CoreText.ReportingTypedConfigGetter_invalidConfigIgnored, entry);
            }
            return MessageFormat.format(CoreText.ReportingTypedConfigGetter_invalidConfig, entry, defaultValue);
        }
        if (defaultValue == null) {
            return MessageFormat.format(CoreText.ReportingTypedConfigGetter_invalidConfigWithLocationIgnored, location, entry);
        }
        return MessageFormat.format(CoreText.ReportingTypedConfigGetter_invalidConfigWithLocation, location, entry, defaultValue);
    }

    private static String join(String section, String subsection, String name) {
        if (subsection == null) {
            return String.valueOf(section) + '.' + name;
        }
        return String.valueOf(section) + '.' + subsection + '.' + name;
    }

    private static String toString(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u00b5s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        return "";
    }
}

