/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;

public class DataTypeFulfillsEvaluator {
    private final Predicate<IDataType> m_evalStrategy;
    private final Function<IDataType, Stream<IDataType>> m_childrenSupplier;

    public DataTypeFulfillsEvaluator(Predicate<IDataType> evalStrategy) {
        this(evalStrategy, IDataType::childTypes);
    }

    public DataTypeFulfillsEvaluator(Predicate<IDataType> evalStrategy, Function<IDataType, Stream<IDataType>> childrenSupplier) {
        this.m_evalStrategy = evalStrategy;
        this.m_childrenSupplier = childrenSupplier;
    }

    public boolean fulfills(IDataType dataType) {
        if (dataType == null) {
            return false;
        }
        return switch (dataType.flavor()) {
            default -> throw new IncompatibleClassChangeError();
            case IDataType.DataTypeFlavor.Union -> this.checkUnion(dataType);
            case IDataType.DataTypeFlavor.Intersection -> this.checkIntersection(dataType);
            case IDataType.DataTypeFlavor.Array -> this.checkArray(dataType);
            case IDataType.DataTypeFlavor.Single -> this.checkSingle(dataType);
        };
    }

    protected boolean checkUnion(IDataType dataType) {
        return this.m_childrenSupplier.apply(dataType).anyMatch(this::fulfills);
    }

    protected boolean checkIntersection(IDataType dataType) {
        return this.m_childrenSupplier.apply(dataType).allMatch(this::fulfills);
    }

    protected boolean checkArray(IDataType dataType) {
        return this.m_evalStrategy.test(dataType);
    }

    protected boolean checkSingle(IDataType dataType) {
        if (this.m_evalStrategy.test(dataType)) {
            return true;
        }
        return this.checkUnion(dataType);
    }
}

