/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api;

import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.util.Strings;

public class DataTypeNameEvaluator {
    private final Function<IDataType, Stream<IDataType>> m_childrenSupplier;

    public DataTypeNameEvaluator() {
        this(IDataType::childTypes);
    }

    public DataTypeNameEvaluator(Function<IDataType, Stream<IDataType>> childrenSupplier) {
        this.m_childrenSupplier = childrenSupplier;
    }

    public String eval(IDataType type) {
        if (type == null) {
            return null;
        }
        return switch (type.flavor()) {
            default -> throw new IncompatibleClassChangeError();
            case IDataType.DataTypeFlavor.Array -> this.m_childrenSupplier.apply(type).findFirst().map(c -> this.boxComponentDataType(IDataType.DataTypeFlavor.Array, (IDataType)c)).orElse("") + "[]".repeat(type.arrayDimension());
            case IDataType.DataTypeFlavor.Union -> this.m_childrenSupplier.apply(type).map(c -> this.boxComponentDataType(IDataType.DataTypeFlavor.Union, (IDataType)c)).filter(Objects::nonNull).collect(Collectors.joining(" | "));
            case IDataType.DataTypeFlavor.Intersection -> this.m_childrenSupplier.apply(type).map(c -> this.boxComponentDataType(IDataType.DataTypeFlavor.Intersection, (IDataType)c)).filter(Objects::nonNull).collect(Collectors.joining(" & "));
            case IDataType.DataTypeFlavor.Single -> this.nameForSimpleDataType(type);
        };
    }

    protected String nameForSimpleDataType(IDataType type) {
        Object args = type.typeArguments().map(this::eval).collect(Collectors.joining(", "));
        if (!Strings.isEmpty((CharSequence)args)) {
            args = "<" + (String)args + ">";
        }
        return this.nameForLeafType(type) + (String)args;
    }

    protected String nameForLeafType(IDataType type) {
        return type.name();
    }

    protected String boxComponentDataType(IDataType.DataTypeFlavor parentFlavor, IDataType componentDataType) {
        boolean requiresParentheses;
        if (componentDataType == null) {
            return null;
        }
        String componentDataTypeName = this.eval(componentDataType);
        if (Strings.isBlank((CharSequence)componentDataTypeName)) {
            return null;
        }
        switch (parentFlavor) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case Array: {
                boolean bl;
                if (componentDataType.flavor() == IDataType.DataTypeFlavor.Union || componentDataType.flavor() == IDataType.DataTypeFlavor.Intersection) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case Union: {
                boolean bl;
                if (componentDataType.flavor() == IDataType.DataTypeFlavor.Intersection) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case Intersection: {
                boolean bl;
                if (componentDataType.flavor() == IDataType.DataTypeFlavor.Union) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case Single: {
                boolean bl = requiresParentheses = false;
            }
        }
        if (requiresParentheses) {
            return "(" + componentDataTypeName + ")";
        }
        return componentDataTypeName;
    }
}

