/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.InputEvent;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.parts.AbstractEditPartViewer;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Event;

public class DomainEventDispatcher
extends SWTEventDispatcher {
    protected EditDomain domain;
    protected EditPartViewer viewer;
    private boolean editorCaptured = false;
    private Cursor overrideCursor;
    private final Map<Integer, AccessibleEditPart> accessibles = new HashMap<Integer, AccessibleEditPart>();
    private EditPartAccessibilityDispatcher accessibilityDispatcher;

    public DomainEventDispatcher(EditDomain d, EditPartViewer v) {
        this.domain = d;
        this.viewer = v;
        this.setEnableKeyTraversal(false);
    }

    public void dispatchFocusGained(FocusEvent event) {
        super.dispatchFocusGained(event);
        this.domain.focusGained(event, this.viewer);
    }

    public void dispatchFocusLost(FocusEvent event) {
        super.dispatchFocusLost(event);
        this.domain.focusLost(event, this.viewer);
        this.setRouteEventsToEditor(false);
    }

    public void dispatchKeyPressed(KeyEvent e) {
        if (!this.editorCaptured) {
            super.dispatchKeyPressed(e);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.domain.keyDown(e, this.viewer);
        }
    }

    public void dispatchKeyTraversed(TraverseEvent e) {
        if (!this.editorCaptured) {
            super.dispatchKeyTraversed(e);
            if (!e.doit) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.domain.keyTraversed(e, this.viewer);
        }
    }

    public void dispatchKeyReleased(KeyEvent e) {
        if (!this.editorCaptured) {
            super.dispatchKeyReleased(e);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.domain.keyUp(e, this.viewer);
        }
    }

    public void dispatchMouseDoubleClicked(MouseEvent me) {
        if (!this.editorCaptured) {
            super.dispatchMouseDoubleClicked(me);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.domain.mouseDoubleClick(me, this.viewer);
        }
    }

    public void dispatchMouseEntered(MouseEvent me) {
        if (!this.editorCaptured) {
            super.dispatchMouseEntered(me);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.domain.viewerEntered(me, this.viewer);
        }
    }

    public void dispatchMouseExited(MouseEvent me) {
        if (!this.editorCaptured) {
            super.dispatchMouseExited(me);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.domain.viewerExited(me, this.viewer);
        }
    }

    public void dispatchMouseHover(MouseEvent me) {
        if (!this.editorCaptured) {
            super.dispatchMouseHover(me);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.domain.mouseHover(me, this.viewer);
        }
    }

    public void dispatchMousePressed(MouseEvent me) {
        if (!this.editorCaptured) {
            super.dispatchMousePressed(me);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.setFocus(null);
            this.control.forceFocus();
            this.setRouteEventsToEditor(true);
            this.domain.mouseDown(me, this.viewer);
        }
    }

    public void dispatchMouseMoved(MouseEvent me) {
        if (!this.editorCaptured) {
            super.dispatchMouseMoved(me);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            if ((me.stateMask & InputEvent.ANY_BUTTON) != 0) {
                this.domain.mouseDrag(me, this.viewer);
            } else {
                this.domain.mouseMove(me, this.viewer);
            }
        }
    }

    public void dispatchMouseReleased(MouseEvent me) {
        if (!this.editorCaptured) {
            super.dispatchMouseReleased(me);
            if (this.draw2dBusy()) {
                return;
            }
        }
        if (this.okToDispatch()) {
            this.setRouteEventsToEditor(false);
            this.domain.mouseUp(me, this.viewer);
            this.updateFigureUnderCursor(me);
        }
    }

    public void dispatchNativeDragFinished(DragSourceEvent event, AbstractEditPartViewer viewer) {
        this.domain.nativeDragFinished(event, viewer);
    }

    public void dispatchNativeDragStarted(DragSourceEvent event, AbstractEditPartViewer viewer) {
        this.setRouteEventsToEditor(false);
        this.domain.nativeDragStarted(event, viewer);
    }

    public void dispatchMouseWheelScrolled(Event evt) {
        if (!this.editorCaptured) {
            super.dispatchMouseWheelScrolled(evt);
        }
        if (evt.doit && this.okToDispatch()) {
            this.domain.mouseWheelScrolled(evt, this.viewer);
        }
    }

    private boolean draw2dBusy() {
        if (this.getCurrentEvent() != null && this.getCurrentEvent().isConsumed()) {
            return true;
        }
        return this.isCaptured();
    }

    protected EventDispatcher.AccessibilityDispatcher getAccessibilityDispatcher() {
        if (this.accessibilityDispatcher == null) {
            this.accessibilityDispatcher = new EditPartAccessibilityDispatcher();
        }
        return this.accessibilityDispatcher;
    }

    protected final EditPartViewer getViewer() {
        return this.viewer;
    }

    private boolean okToDispatch() {
        return this.domain != null;
    }

    void putAccessible(AccessibleEditPart acc) {
        this.accessibles.put(acc.getAccessibleID(), acc);
    }

    void removeAccessible(AccessibleEditPart acc) {
        this.accessibles.remove(acc.getAccessibleID());
    }

    protected void setCapture(IFigure figure) {
        super.setCapture(figure);
        if (figure == null) {
            this.releaseCapture();
            this.setRouteEventsToEditor(true);
        }
    }

    protected void setCursor(Cursor newCursor) {
        if (this.overrideCursor == null) {
            super.setCursor(newCursor);
        } else {
            super.setCursor(this.overrideCursor);
        }
    }

    public void setRouteEventsToEditor(boolean value) {
        this.editorCaptured = value;
    }

    public void setOverrideCursor(Cursor newCursor) {
        if (this.overrideCursor == newCursor) {
            return;
        }
        this.overrideCursor = newCursor;
        if (this.overrideCursor == null) {
            this.updateCursor();
        } else {
            this.setCursor(this.overrideCursor);
        }
    }

    protected class EditPartAccessibilityDispatcher
    extends EventDispatcher.AccessibilityDispatcher {
        protected EditPartAccessibilityDispatcher() {
        }

        private AccessibleEditPart get(int childID) {
            if (childID == -1 || childID == -2) {
                if (DomainEventDispatcher.this.getViewer().getContents() != null) {
                    return (AccessibleEditPart)((Object)DomainEventDispatcher.this.getViewer().getContents().getAdapter(AccessibleEditPart.class));
                }
                return null;
            }
            return DomainEventDispatcher.this.accessibles.get(childID);
        }

        public void getChildAtPoint(AccessibleControlEvent e) {
            org.eclipse.swt.graphics.Point p = new org.eclipse.swt.graphics.Point(e.x, e.y);
            p = DomainEventDispatcher.this.getViewer().getControl().toControl(p);
            EditPart part = DomainEventDispatcher.this.getViewer().findObjectAt(new Point(p.x, p.y));
            if (part == null) {
                return;
            }
            AccessibleEditPart acc = (AccessibleEditPart)((Object)part.getAdapter(AccessibleEditPart.class));
            if (acc != null) {
                e.childID = acc.getAccessibleID();
            }
        }

        public void getChildCount(AccessibleControlEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getChildCount(e);
            }
        }

        public void getChildren(AccessibleControlEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getChildren(e);
            }
        }

        public void getDefaultAction(AccessibleControlEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getDefaultAction(e);
            }
        }

        public void getDescription(AccessibleEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getDescription(e);
            }
        }

        public void getFocus(AccessibleControlEvent e) {
            AccessibleEditPart acc = (AccessibleEditPart)((Object)DomainEventDispatcher.this.getViewer().getFocusEditPart().getAdapter(AccessibleEditPart.class));
            if (acc != null) {
                e.childID = acc.getAccessibleID();
            }
        }

        public void getHelp(AccessibleEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getHelp(e);
            }
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getKeyboardShortcut(e);
            }
        }

        public void getLocation(AccessibleControlEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getLocation(e);
            }
        }

        public void getName(AccessibleEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getName(e);
            }
        }

        public void getRole(AccessibleControlEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getRole(e);
            }
        }

        public void getSelection(AccessibleControlEvent e) {
        }

        public void getState(AccessibleControlEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getState(e);
            }
        }

        public void getValue(AccessibleControlEvent e) {
            AccessibleEditPart acc = this.get(e.childID);
            if (acc != null) {
                acc.getValue(e);
            }
        }
    }
}

