/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java;

import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.util.Strings;

public final class JavaUtils {
    private static final Pattern REGEX_COMMENT_REMOVE_1 = Pattern.compile("//.*?\r\n");
    private static final Pattern REGEX_COMMENT_REMOVE_2 = Pattern.compile("//.*?\n");
    private static final Pattern REGEX_COMMENT_REMOVE_3 = Pattern.compile("(?s)/\\*.*?\\*/");

    private JavaUtils() {
    }

    public static String removeComments(CharSequence methodBody) {
        if (methodBody == null) {
            return null;
        }
        if (Strings.isBlank((CharSequence)methodBody)) {
            return methodBody.toString();
        }
        String retVal = REGEX_COMMENT_REMOVE_1.matcher(methodBody).replaceAll("");
        retVal = REGEX_COMMENT_REMOVE_2.matcher(retVal).replaceAll("");
        retVal = REGEX_COMMENT_REMOVE_3.matcher(retVal).replaceAll("");
        return retVal;
    }

    public static CharSequence fromStringLiteral(CharSequence literal) {
        if (literal == null) {
            return null;
        }
        CharSequence s = Strings.withoutQuotes((CharSequence)literal);
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s, idx + 1, idx + 5, 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && JavaUtils.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s, idx, escapeEnd, 8));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException("Couldn't parse " + s.subSequence(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer;
    }

    private static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    public static CharSequence toStringLiteral(CharSequence s) {
        return JavaUtils.toStringLiteral(s, "\"", true);
    }

    public static CharSequence toStringLiteral(CharSequence s, CharSequence stringDelimiter, boolean surroundWithStringDelimiter) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length * 2);
        if (surroundWithStringDelimiter && stringDelimiter != null) {
            buffer.append(stringDelimiter);
        }
        block7: for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    continue block7;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block7;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block7;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block7;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block7;
                }
                default: {
                    if (ch == '\\') {
                        buffer.append("\\\\");
                        continue block7;
                    }
                    if (stringDelimiter != null && Strings.indexOf((char)ch, (CharSequence)stringDelimiter) > -1) {
                        buffer.append("\\").append(ch);
                        continue block7;
                    }
                    if (!JavaUtils.isPrintableUnicode(ch)) {
                        String hexCode = Integer.toHexString(ch).toUpperCase(Locale.US);
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        continue block7;
                    }
                    buffer.append(ch);
                }
            }
        }
        if (surroundWithStringDelimiter && stringDelimiter != null) {
            buffer.append(stringDelimiter);
        }
        return buffer;
    }

    private static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }
}

