/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.builder.comment;

import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.comment.CommentBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.ICommentBuilder;
import org.eclipse.scout.sdk.core.java.builder.comment.IDefaultElementCommentGeneratorSpi;
import org.eclipse.scout.sdk.core.java.builder.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.generator.compilationunit.ICompilationUnitGenerator;
import org.eclipse.scout.sdk.core.java.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.imports.IImportValidator;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class JavaElementCommentBuilder<TYPE extends IJavaElementCommentBuilder<TYPE>>
extends CommentBuilder<TYPE>
implements IJavaElementCommentBuilder<TYPE> {
    private static volatile IDefaultElementCommentGeneratorSpi commentGeneratorSpi;
    public static final String LINK_PREFIX = "{@link ";
    public static final char LINK_SUFFIX = '}';
    public static final char LINK_MEMBER_DELIMITER = '#';
    private static final Pattern LINK_REFERENCE_PATTERN;
    private final Supplier<ISourceGenerator<ICommentBuilder<?>>> m_defaultCommentGeneratorSupplier;
    private final FinalValue<ISourceGenerator<ICommentBuilder<?>>> m_defaultElementCommentGenerator = new FinalValue();
    private final IJavaBuilderContext m_context;

    protected JavaElementCommentBuilder(ISourceBuilder<?> inner, Supplier<ISourceGenerator<ICommentBuilder<?>>> defaultCommentGeneratorSupplier) {
        super(inner);
        this.m_defaultCommentGeneratorSupplier = (Supplier)Ensure.notNull(defaultCommentGeneratorSupplier);
        IBuilderContext context = inner.context();
        this.m_context = context instanceof IJavaBuilderContext ? (IJavaBuilderContext)context : null;
    }

    public static IDefaultElementCommentGeneratorSpi getCommentGeneratorSpi() {
        return commentGeneratorSpi;
    }

    public static void setCommentGeneratorSpi(IDefaultElementCommentGeneratorSpi newCommentGeneratorSpi) {
        commentGeneratorSpi = newCommentGeneratorSpi;
    }

    static JavaElementCommentBuilder<?> newJavaElementCommentBuilder(ISourceBuilder<?> inner, Function<IDefaultElementCommentGeneratorSpi, ISourceGenerator<ICommentBuilder<?>>> mapper) {
        return new JavaElementCommentBuilder(inner, () -> Optional.ofNullable(JavaElementCommentBuilder.getCommentGeneratorSpi()).map(mapper).orElse(ISourceGenerator.empty()));
    }

    public static IJavaElementCommentBuilder<?> create(ISourceBuilder<?> inner) {
        return new JavaElementCommentBuilder(inner, ISourceGenerator::empty);
    }

    public static IJavaElementCommentBuilder<?> createForCompilationUnit(ISourceBuilder<?> inner, ICompilationUnitGenerator<?> target) {
        return JavaElementCommentBuilder.newJavaElementCommentBuilder(inner, spi -> spi.createCompilationUnitComment(target));
    }

    public static IJavaElementCommentBuilder<?> createForType(ISourceBuilder<?> inner, ITypeGenerator<?> target) {
        return JavaElementCommentBuilder.newJavaElementCommentBuilder(inner, spi -> spi.createTypeComment(target));
    }

    public static IJavaElementCommentBuilder<?> createForMethod(ISourceBuilder<?> inner, IMethodGenerator<?, ?> target) {
        return JavaElementCommentBuilder.newJavaElementCommentBuilder(inner, spi -> spi.createMethodComment(target));
    }

    public static IJavaElementCommentBuilder<?> createForMethodGetter(ISourceBuilder<?> inner, IMethodGenerator<?, ?> target) {
        return JavaElementCommentBuilder.newJavaElementCommentBuilder(inner, spi -> spi.createGetterMethodComment(target));
    }

    public static IJavaElementCommentBuilder<?> createForMethodSetter(ISourceBuilder<?> inner, IMethodGenerator<?, ?> target) {
        return JavaElementCommentBuilder.newJavaElementCommentBuilder(inner, spi -> spi.createSetterMethodComment(target));
    }

    public static IJavaElementCommentBuilder<?> createForField(ISourceBuilder<?> inner, IFieldGenerator<?> target) {
        return JavaElementCommentBuilder.newJavaElementCommentBuilder(inner, spi -> spi.createFieldComment(target));
    }

    @Override
    public TYPE appendDefaultElementComment() {
        return (TYPE)((IJavaElementCommentBuilder)this.append(this.defaultElementComment().generalize(CommentBuilder::create)));
    }

    public ISourceGenerator<ICommentBuilder<?>> defaultElementComment() {
        return (ISourceGenerator)this.m_defaultElementCommentGenerator.computeIfAbsentAndGet(this.m_defaultCommentGeneratorSupplier);
    }

    @Override
    public TYPE appendLink(IType ref) {
        return this.appendLink(ref, null);
    }

    @Override
    public TYPE appendLink(IType ref, CharSequence label) {
        if (ref == null) {
            return (TYPE)((IJavaElementCommentBuilder)this.thisInstance());
        }
        return this.appendLink(ref.reference(), label);
    }

    @Override
    public TYPE appendLink(CharSequence ref) {
        return this.appendLink(ref, null);
    }

    @Override
    public TYPE appendLink(CharSequence ref, CharSequence label) {
        if (!Strings.hasText((CharSequence)ref)) {
            return (TYPE)((IJavaElementCommentBuilder)this.thisInstance());
        }
        if (Strings.indexOf((char)'#', (CharSequence)ref) < 0 && Strings.lastIndexOf((char)'>', (CharSequence)ref) > 0) {
            JavaTypes.ReferenceParser p = new JavaTypes.ReferenceParser((fqn, typeArgDepth) -> this.createTypeLink((CharSequence)fqn));
            String refWithLinks = p.useReference(ref);
            return (TYPE)((IJavaElementCommentBuilder)this.append(refWithLinks));
        }
        boolean useLink = JavaElementCommentBuilder.isLinkPossible(ref);
        if (useLink) {
            this.append(LINK_PREFIX);
        }
        if (this.m_context != null) {
            this.appendLinkReference(this.m_context.validator(), ref);
        } else {
            this.append(ref);
        }
        if (useLink) {
            if (Strings.hasText((CharSequence)label)) {
                if (!Character.isWhitespace(label.charAt(0))) {
                    this.append(' ');
                }
                this.append(label);
            }
            this.append('}');
        }
        return (TYPE)((IJavaElementCommentBuilder)this.thisInstance());
    }

    protected static boolean isLinkPossible(CharSequence ref) {
        return !JavaTypes.isPrimitive(ref) && !JavaTypes.isArray(ref) && !JavaTypes.isWildcard(ref);
    }

    protected void appendLinkReference(IImportValidator validator, CharSequence ref) {
        Matcher m = LINK_REFERENCE_PATTERN.matcher(JavaTypes.erasure(ref));
        if (!m.matches()) {
            this.append(ref);
            return;
        }
        String className = m.group(1);
        String member = m.group(2);
        String args = m.group(3);
        if (Strings.hasText((CharSequence)className)) {
            this.append(validator.useReference(className));
        }
        if (Strings.hasText((CharSequence)member)) {
            ((IJavaElementCommentBuilder)((IJavaElementCommentBuilder)this.append('#')).append(member)).append('(');
            this.appendArgumentNames(validator, args);
            this.append(')');
        }
    }

    protected CharSequence createTypeLink(CharSequence fqn) {
        CharSequence ref = this.m_context != null ? this.m_context.validator().useReference(fqn) : fqn;
        return LINK_PREFIX + ref + "}";
    }

    protected void appendArgumentNames(IImportValidator validator, String args) {
        if (!Strings.hasText((CharSequence)args)) {
            return;
        }
        StringTokenizer arguments = new StringTokenizer(args, String.valueOf(','));
        CharSequence arg = Strings.trim((CharSequence)arguments.nextToken());
        this.append(validator.useReference(arg));
        while (arguments.hasMoreTokens()) {
            arg = Strings.trim((CharSequence)arguments.nextToken());
            ((IJavaElementCommentBuilder)this.append(", ")).append(validator.useReference(arg));
        }
    }

    static {
        LINK_REFERENCE_PATTERN = Pattern.compile("([\\w.\\[\\]]+)?(?:#(\\w+)\\(([\\w\\s,.\\[\\]]*)\\))?");
    }
}

