/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.apidef.Api;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.model.CompilationUnitInfo;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.IUnresolvedType;
import org.eclipse.scout.sdk.core.java.model.api.MissingTypeException;
import org.eclipse.scout.sdk.core.java.model.api.internal.UnresolvedTypeImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.ClasspathSpi;
import org.eclipse.scout.sdk.core.java.model.spi.JavaEnvironmentSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class JavaEnvironmentImplementor
implements IJavaEnvironment {
    private final JavaEnvironmentSpi m_spi;
    private FinalValue<List<IClasspathEntry>> m_sourceFoldersSorted;
    private final Map<Class<? extends IApiSpecification>, Optional<? extends IApiSpecification>> m_apiCache;

    public JavaEnvironmentImplementor(JavaEnvironmentSpi spi) {
        this.m_spi = spi;
        this.m_sourceFoldersSorted = new FinalValue();
        this.m_apiCache = new ConcurrentHashMap<Class<? extends IApiSpecification>, Optional<? extends IApiSpecification>>();
    }

    @Override
    public Optional<IType> findType(ITypeNameSupplier nameSupplier) {
        return this.findType(nameSupplier.fqn());
    }

    @Override
    public Optional<IType> findType(String fqn) {
        return Optional.ofNullable(this.m_spi.findType(fqn)).map(TypeSpi::wrap);
    }

    @Override
    public <A extends IApiSpecification> Optional<IType> findTypeFrom(Class<A> apiDefinition, Function<A, ITypeNameSupplier> nameSupplier) {
        return new ApiFunction<A, ITypeNameSupplier>(apiDefinition, nameSupplier).apply(this).flatMap(this::findType);
    }

    @Override
    public IType requireType(ITypeNameSupplier nameSupplier) {
        return this.requireType(nameSupplier.fqn());
    }

    @Override
    public IType requireType(String fqn) {
        return this.findType(fqn).orElseThrow(() -> Ensure.newFail((CharSequence)"Type '{}' cannot be found.", (Object[])new Object[]{fqn}));
    }

    @Override
    public <A extends IApiSpecification> IType requireTypeFrom(Class<A> apiDefinition, Function<A, ITypeNameSupplier> nameSupplier) {
        return new ApiFunction<A, ITypeNameSupplier>(apiDefinition, nameSupplier).apply(this).map(this::requireType).orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot find API '{}' in this context.", (Object[])new Object[]{apiDefinition.getSimpleName()}));
    }

    @Override
    public boolean exists(IType t) {
        return t != null && (t.javaEnvironment() == this || this.exists(t.name()));
    }

    @Override
    public boolean exists(String fqn) {
        return Strings.hasText((CharSequence)fqn) && this.m_spi.findType(fqn) != null;
    }

    @Override
    public IUnresolvedType findUnresolvedType(String fqn) {
        try {
            Optional<IType> t = this.findType(fqn);
            if (t.isPresent()) {
                return new UnresolvedTypeImplementor(new UnresolvedTypeImplementor.UnresolvedTypeSpi(this.unwrap(), t.orElseThrow()));
            }
        }
        catch (MissingTypeException ex) {
            SdkLog.debug((CharSequence)"Missing type during unresolved-type creation.", (Object[])new Object[]{ex});
        }
        return new UnresolvedTypeImplementor(new UnresolvedTypeImplementor.UnresolvedTypeSpi(this.unwrap(), fqn));
    }

    @Override
    public void reload() {
        this.m_spi.reload();
    }

    @Override
    public boolean registerCompilationUnitOverride(CharSequence source, String packageName, String fileName) {
        return this.registerCompilationUnitOverride(source, null, packageName, fileName);
    }

    @Override
    public boolean registerCompilationUnitOverride(CharSequence source, Path sourceFolder, String packageName, String fileName) {
        return this.registerCompilationUnitOverride(source, new CompilationUnitInfo(sourceFolder, packageName, fileName));
    }

    @Override
    public boolean registerCompilationUnitOverride(CharSequence source, CompilationUnitInfo cuInfo) {
        return this.m_spi.registerCompilationUnitOverride(Strings.toCharArray((CharSequence)source), cuInfo);
    }

    @Override
    public List<String> compileErrors(IType type) {
        return this.m_spi.getCompileErrors(((IType)Ensure.notNull((Object)type)).unwrap());
    }

    @Override
    public List<String> compileErrors(String fqn) {
        return this.m_spi.getCompileErrors(fqn);
    }

    @Override
    public Stream<IClasspathEntry> classpath() {
        return this.m_spi.getClasspath().stream().map(ClasspathSpi::wrap);
    }

    @Override
    public boolean classpathContains(Path path) {
        if (path == null) {
            return false;
        }
        return this.m_spi.getClasspath().stream().map(ClasspathSpi::getPath).anyMatch(path::startsWith);
    }

    @Override
    public <A extends IApiSpecification> Optional<A> api(Class<A> apiDefinition) {
        Class key = apiDefinition == null ? IApiSpecification.class : apiDefinition;
        Optional api = this.m_apiCache.computeIfAbsent(key, this::createApi);
        return api;
    }

    @Override
    public <A extends IApiSpecification> A requireApi(Class<A> apiDefinition) {
        return (A)((IApiSpecification)this.api(apiDefinition).orElseThrow(() -> Ensure.newFail((CharSequence)"API '{}' could not be found.", (Object[])new Object[]{apiDefinition.getSimpleName()})));
    }

    protected <A extends IApiSpecification> Optional<A> createApi(Class<A> apiDefinition) {
        if (apiDefinition == IApiSpecification.class) {
            return Optional.empty();
        }
        return Api.create(apiDefinition, this);
    }

    @Override
    public Stream<IClasspathEntry> sourceFolders() {
        return this.sourceFoldersSorted().stream();
    }

    @Override
    public Optional<IClasspathEntry> primarySourceFolder() {
        List<IClasspathEntry> sourceFoldersSorted = this.sourceFoldersSorted();
        if (sourceFoldersSorted.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(sourceFoldersSorted.get(0));
    }

    protected List<IClasspathEntry> sourceFoldersSorted() {
        return (List)this.m_sourceFoldersSorted.computeIfAbsentAndGet(() -> {
            List<ClasspathSpi> src = this.m_spi.getClasspath();
            TreeSet<P_ClasspathComposite> sorter = new TreeSet<P_ClasspathComposite>(Comparator.comparingInt(P_ClasspathComposite::order).thenComparingInt(P_ClasspathComposite::pos));
            for (int i = 0; i < src.size(); ++i) {
                ClasspathSpi classpathSpi = src.get(i);
                if (!classpathSpi.isSourceFolder()) continue;
                sorter.add(new P_ClasspathComposite(classpathSpi.wrap(), i));
            }
            return sorter.stream().map(P_ClasspathComposite::entry).collect(Collectors.toList());
        });
    }

    @Override
    public JavaEnvironmentSpi unwrap() {
        return this.m_spi;
    }

    public void spiChanged() {
        this.m_sourceFoldersSorted = new FinalValue();
        this.m_apiCache.clear();
    }

    protected static int priorityOfSourceFolder(IClasspathEntry sf) {
        return JavaEnvironmentImplementor.priorityOfSourceFolder(sf.path());
    }

    public static int priorityOfSourceFolder(Path absolutePath) {
        int numEndSegments;
        if (absolutePath.endsWith("src/main/java")) {
            return 1;
        }
        if (absolutePath.endsWith("src")) {
            return 11;
        }
        if (absolutePath.endsWith("src/test/java")) {
            return 20;
        }
        int totalSegments = absolutePath.getNameCount();
        Path rel = absolutePath.subpath(totalSegments - (numEndSegments = Math.min(totalSegments, 3)), totalSegments);
        if (rel.startsWith(Paths.get("src/main/java", new String[0]).subpath(0, 2))) {
            return 12;
        }
        if (rel.startsWith(Paths.get("src/test/java", new String[0]).subpath(0, 2))) {
            return 22;
        }
        return 30;
    }

    private static final class P_ClasspathComposite {
        private final IClasspathEntry m_entry;
        private final int m_order;
        private final int m_pos;

        private P_ClasspathComposite(IClasspathEntry entry, int pos) {
            this.m_entry = entry;
            this.m_pos = pos;
            this.m_order = JavaEnvironmentImplementor.priorityOfSourceFolder(entry);
        }

        private IClasspathEntry entry() {
            return this.m_entry;
        }

        private int order() {
            return this.m_order;
        }

        public int pos() {
            return this.m_pos;
        }
    }
}

