/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.java.model.api.IImport;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IPackage;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.internal.AbstractMemberImplementor;
import org.eclipse.scout.sdk.core.java.model.api.query.AnnotationQuery;
import org.eclipse.scout.sdk.core.java.model.api.query.FieldQuery;
import org.eclipse.scout.sdk.core.java.model.api.query.HierarchyInnerTypeQuery;
import org.eclipse.scout.sdk.core.java.model.api.query.MethodQuery;
import org.eclipse.scout.sdk.core.java.model.api.query.SuperTypeQuery;
import org.eclipse.scout.sdk.core.java.model.api.spliterator.WrappingSpliterator;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.Strings;

public class TypeImplementor
extends AbstractMemberImplementor<TypeSpi>
implements IType {
    private static final Pattern PRIMITIVE_TYPE_ASSIGNABLE_PAT = Pattern.compile("char=(?:char|Character)|byte=(?:byte|Byte)|short=(?:short|Short)|int=(?:int|Integer)|long=(?:long|Long)|float=(?:float|Float)|double=(?:double|Double)|Character=(?:char|Character)|Byte=(?:byte|Byte)|Short=(?:short|Short)|Integer=(?:int|Integer)|Long=(?:long|Long)|Float=(?:float|Float)|Double=(?:double|Double)");
    private String m_reference;
    private String m_referenceErasureOnly;

    public TypeImplementor(TypeSpi spi) {
        super(spi);
    }

    @Override
    public boolean isArray() {
        return ((TypeSpi)this.m_spi).getArrayDimension() > 0;
    }

    @Override
    public int arrayDimension() {
        return ((TypeSpi)this.m_spi).getArrayDimension();
    }

    @Override
    public Optional<IType> leafComponentType() {
        return Optional.ofNullable(((TypeSpi)this.m_spi).getLeafComponentType()).map(TypeSpi::wrap);
    }

    @Override
    public Stream<? extends IJavaElement> children() {
        Comparator<IJavaElement> c = Comparator.comparing(e -> e.source().map(SourceRange::start).orElse(0));
        return Stream.of(this.fields().stream(), this.methods().stream(), this.innerTypes().stream(), this.typeParameters(), this.annotations().stream()).flatMap(f -> f).sorted(c);
    }

    @Override
    public boolean isPrimitive() {
        return ((TypeSpi)this.m_spi).isPrimitive();
    }

    @Override
    public boolean isParameterType() {
        return ((TypeSpi)this.m_spi).isAnonymous();
    }

    @Override
    public String name() {
        return ((TypeSpi)this.m_spi).getName();
    }

    @Override
    public IPackage containingPackage() {
        return ((TypeSpi)this.m_spi).getPackage().wrap();
    }

    @Override
    public Optional<IType> superClass() {
        return Optional.ofNullable(((TypeSpi)this.m_spi).getSuperClass()).map(TypeSpi::wrap);
    }

    @Override
    public IType requireSuperClass() {
        return this.superClass().orElseThrow(() -> Ensure.newFail((CharSequence)"Type '{}' has no super class.", (Object[])new Object[]{this.name()}));
    }

    @Override
    public Stream<IType> superInterfaces() {
        return WrappingSpliterator.stream(((TypeSpi)this.m_spi).getSuperInterfaces());
    }

    @Override
    public Stream<IType> directSuperTypes() {
        return Stream.concat(this.superClass().stream(), this.superInterfaces());
    }

    @Override
    public Stream<IType> typeArguments() {
        return WrappingSpliterator.stream(((TypeSpi)this.m_spi).getTypeArguments());
    }

    @Override
    public Optional<ICompilationUnit> compilationUnit() {
        return Optional.ofNullable(((TypeSpi)this.m_spi).getCompilationUnit()).map(CompilationUnitSpi::wrap);
    }

    @Override
    public ICompilationUnit requireCompilationUnit() {
        return this.compilationUnit().orElseThrow(() -> Ensure.newFail((CharSequence)"Type '{}' does not have a compilation unit.", (Object[])new Object[]{this.name()}));
    }

    @Override
    public boolean isWildcardType() {
        return ((TypeSpi)this.m_spi).isWildcardType();
    }

    @Override
    public Optional<SourceRange> sourceOfStaticInitializer() {
        return Optional.ofNullable(((TypeSpi)this.m_spi).getSourceOfStaticInitializer());
    }

    @Override
    public String qualifier() {
        return this.declaringType().map(IType::name).orElseGet(() -> this.compilationUnit().map(ICompilationUnit::containingPackage).map(IPackage::elementName).orElse(""));
    }

    @Override
    public void internalSetSpi(TypeSpi spi) {
        super.internalSetSpi(spi);
        this.m_reference = null;
        this.m_referenceErasureOnly = null;
    }

    @Override
    public boolean isVoid() {
        return "void".equals(this.name());
    }

    @Override
    public boolean isInterface() {
        return Flags.isInterface(this.flags());
    }

    @Override
    public String reference() {
        return this.reference(false);
    }

    @Override
    public String reference(boolean erasureOnly) {
        return erasureOnly ? this.referenceErasureOnly() : this.referenceWithTypeArgs();
    }

    protected String referenceWithTypeArgs() {
        if (this.m_reference == null) {
            this.m_reference = TypeImplementor.buildReference(this, false);
        }
        return this.m_reference;
    }

    protected String referenceErasureOnly() {
        if (this.m_referenceErasureOnly == null) {
            this.m_referenceErasureOnly = TypeImplementor.buildReference(this, true);
        }
        return this.m_referenceErasureOnly;
    }

    protected static String buildReference(IType type, boolean erasureOnly) {
        StringBuilder builder = new StringBuilder(128);
        TypeImplementor.buildReferenceRec(type, erasureOnly, builder);
        return builder.toString();
    }

    protected static void buildReferenceRec(IType type, boolean erasureOnly, StringBuilder builder) {
        boolean isWildCardOnly;
        if (type.isArray()) {
            TypeImplementor.buildReferenceRec(type.leafComponentType().orElseThrow(), erasureOnly, builder);
            builder.append(JavaTypes.arrayMarker(type.arrayDimension()));
            return;
        }
        String name = type.name();
        boolean bl = isWildCardOnly = name == null;
        if (type.isWildcardType()) {
            builder.append('?');
            if (isWildCardOnly) {
                return;
            }
            builder.append(" extends ");
        }
        if (!isWildCardOnly) {
            builder.append(name);
        }
        if (erasureOnly) {
            return;
        }
        List<IType> typeArgs = type.typeArguments().toList();
        if (!typeArgs.isEmpty()) {
            builder.append('<');
            TypeImplementor.buildReferenceRec(typeArgs.get(0), false, builder);
            for (int i = 1; i < typeArgs.size(); ++i) {
                builder.append(',');
                TypeImplementor.buildReferenceRec(typeArgs.get(i), false, builder);
            }
            builder.append('>');
        }
    }

    @Override
    public AnnotationQuery<IAnnotation> annotations() {
        return new AnnotationQuery<IAnnotation>(this, this.m_spi);
    }

    @Override
    public SuperTypeQuery superTypes() {
        return new SuperTypeQuery(this);
    }

    @Override
    public HierarchyInnerTypeQuery innerTypes() {
        return new HierarchyInnerTypeQuery(this);
    }

    @Override
    public MethodQuery methods() {
        return new MethodQuery(this);
    }

    @Override
    public FieldQuery fields() {
        return new FieldQuery(this);
    }

    @Override
    public Optional<Stream<IType>> resolveTypeParamValue(int typeParamIndex, String levelFqn) {
        return this.superTypes().withName(levelFqn).first().flatMap(levelType -> levelType.resolveTypeParamValue(typeParamIndex));
    }

    @Override
    public Optional<Stream<IType>> resolveTypeParamValue(int typeParamIndex) {
        return this.typeArguments().skip(typeParamIndex).findAny().map(t -> t.isParameterType() ? t.directSuperTypes() : Stream.of(t));
    }

    @Override
    public Optional<IType> resolveSimpleName(String simpleName) {
        if (Strings.isBlank((CharSequence)simpleName)) {
            return Optional.empty();
        }
        Optional<ICompilationUnit> optCu = this.compilationUnit();
        if (optCu.isEmpty()) {
            return Optional.empty();
        }
        IJavaEnvironment env = this.javaEnvironment();
        ICompilationUnit compilationUnit = optCu.orElseThrow();
        Optional<IType> fromImports = this.resolveNameUsingImports(compilationUnit, simpleName);
        if (fromImports.isPresent()) {
            return fromImports;
        }
        String pck = Strings.notBlank((CharSequence)compilationUnit.containingPackage().elementName()).map(p -> p + ".").orElse("");
        Optional<IType> fromPackage = env.findType(pck + simpleName);
        if (fromPackage.isPresent()) {
            return fromPackage;
        }
        Optional<IType> fromFqn = env.findType(simpleName);
        if (fromFqn.isPresent()) {
            return fromFqn;
        }
        return env.findType("java.lang." + simpleName);
    }

    protected Optional<IType> resolveNameUsingImports(ICompilationUnit compilationUnit, String simpleName) {
        IJavaEnvironment env = this.javaEnvironment();
        return compilationUnit.imports().map(imp -> TypeImplementor.toImportName(imp, simpleName)).filter(Objects::nonNull).map(env::findType).flatMap(Optional::stream).findAny();
    }

    private static String toImportName(IImport imp, String simpleNameToResolve) {
        String impName = imp.name();
        if (impName.endsWith("." + simpleNameToResolve)) {
            return impName;
        }
        String wildcardSuffix = ".*";
        if (impName.endsWith(wildcardSuffix)) {
            return impName.substring(0, impName.length() - 1) + simpleNameToResolve;
        }
        return null;
    }

    @Override
    public boolean isInstanceOf(ITypeNameSupplier typeName) {
        return this.isInstanceOf(typeName.fqn());
    }

    @Override
    public boolean isInstanceOf(String queryType) {
        return this.superTypes().withName(queryType).existsAny();
    }

    @Override
    public boolean isAssignableFrom(IType specificClass) {
        if (this.isPrimitive() || specificClass.isPrimitive()) {
            return PRIMITIVE_TYPE_ASSIGNABLE_PAT.matcher(this.elementName() + "=" + specificClass.elementName()).matches();
        }
        if (this.isArray() || specificClass.isArray()) {
            return this.name().equals(specificClass.name());
        }
        return specificClass.superTypes().withName(this.name()).existsAny();
    }

    @Override
    public IType boxPrimitiveType() {
        if (!this.isPrimitive()) {
            return this;
        }
        String boxedFqn = JavaTypes.boxPrimitive(this.name());
        if (boxedFqn == null) {
            return this;
        }
        return this.javaEnvironment().requireType(boxedFqn);
    }

    @Override
    public IType unboxToPrimitive() {
        if (this.isPrimitive()) {
            return this;
        }
        String myName = this.name();
        String unboxed = JavaTypes.unboxToPrimitive(myName);
        if (unboxed == myName) {
            return this;
        }
        return this.javaEnvironment().requireType(unboxed);
    }

    @Override
    public IType primary() {
        IType result = null;
        Optional<IType> tmp = Optional.of(this);
        while (tmp.isPresent()) {
            result = tmp.orElseThrow();
            tmp = result.declaringType();
        }
        return result;
    }

    @Override
    public ITypeGenerator<?> toWorkingCopy(IWorkingCopyTransformer transformer) {
        return TypeGenerator.create(this, transformer);
    }

    @Override
    public ITypeGenerator<?> toWorkingCopy() {
        return this.toWorkingCopy(null);
    }

    @Override
    public String toString() {
        return this.name();
    }
}

