/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.query;

import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.model.api.AbstractManagedAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.spliterator.HierarchicalStreamBuilder;
import org.eclipse.scout.sdk.core.java.model.api.spliterator.WrappingSpliterator;
import org.eclipse.scout.sdk.core.java.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.java.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.util.Ensure;

public class AnnotationQuery<T>
extends AbstractQuery<T>
implements Predicate<IAnnotation> {
    private final IType m_containerType;
    private final Function<IType, Optional<? extends IAnnotatable>> m_ownerInLevelFinder;
    private boolean m_includeSuperClasses;
    private boolean m_includeSuperInterfaces;
    private ApiFunction<?, ITypeNameSupplier> m_name;
    private Class<AbstractManagedAnnotation> m_managedWrapperType;

    public AnnotationQuery(IType containerType, JavaElementSpi owner) {
        this.m_containerType = containerType;
        if (owner instanceof TypeSpi) {
            this.m_ownerInLevelFinder = Optional::of;
        } else if (owner instanceof MethodSpi) {
            this.m_ownerInLevelFinder = AnnotationQuery.getMethodLookup((MethodSpi)owner);
        } else if (owner instanceof FieldSpi) {
            this.m_ownerInLevelFinder = level -> level.fields().withName(owner.getElementName()).first();
        } else if (owner instanceof MethodParameterSpi) {
            MethodParameterSpi param = (MethodParameterSpi)owner;
            this.m_ownerInLevelFinder = AnnotationQuery.getMethodLookup(param.getDeclaringMethod()).andThen(method -> method.flatMap(m -> ((IMethod)m).parameters().item(param.getIndex())));
        } else if (owner instanceof PackageSpi) {
            this.m_ownerInLevelFinder = Optional::of;
        } else {
            throw new IllegalArgumentException("Unsupported annotation container: " + owner.getClass().getName());
        }
    }

    protected static Function<IType, Optional<? extends IAnnotatable>> getMethodLookup(MethodSpi method) {
        IMethod m = method.wrap();
        IType declaringType = m.declaringType().orElse(null);
        return level -> {
            if (declaringType == level) {
                return Optional.of(m);
            }
            return level.methods().withMethodIdentifier(m.identifier()).first();
        };
    }

    protected IType getType() {
        return this.m_containerType;
    }

    protected Function<IType, Optional<? extends IAnnotatable>> lookupOwnerOnLevel() {
        return this.m_ownerInLevelFinder;
    }

    public AnnotationQuery<T> withSuperTypes(boolean b) {
        this.m_includeSuperClasses = b;
        this.m_includeSuperInterfaces = b;
        return this;
    }

    public AnnotationQuery<T> withSuperClasses(boolean b) {
        this.m_includeSuperClasses = b;
        return this;
    }

    protected boolean isIncludeSuperClasses() {
        return this.m_includeSuperClasses;
    }

    public AnnotationQuery<T> withSuperInterfaces(boolean b) {
        this.m_includeSuperInterfaces = b;
        return this;
    }

    protected boolean isIncludeSuperInterfaces() {
        return this.m_includeSuperInterfaces;
    }

    public AnnotationQuery<T> withName(CharSequence fullyQualifiedName) {
        return this.withNameFrom(null, api -> ITypeNameSupplier.of(fullyQualifiedName));
    }

    public <API extends IApiSpecification> AnnotationQuery<T> withNameFrom(Class<API> api, Function<API, ITypeNameSupplier> nameFunction) {
        this.m_name = nameFunction == null ? null : new ApiFunction<API, ITypeNameSupplier>(api, nameFunction);
        return this;
    }

    protected ApiFunction<?, ITypeNameSupplier> getName() {
        return this.m_name;
    }

    public <A extends AbstractManagedAnnotation> AnnotationQuery<A> withManagedWrapper(Class<A> managedWrapperType) {
        this.m_managedWrapperType = managedWrapperType;
        this.m_name = AbstractManagedAnnotation.typeName(managedWrapperType);
        return this;
    }

    protected Class<AbstractManagedAnnotation> getManagedWrapper() {
        return this.m_managedWrapperType;
    }

    @Override
    public boolean test(IAnnotation a) {
        ApiFunction<?, ITypeNameSupplier> name = this.getName();
        if (name == null) {
            return true;
        }
        Optional<String> fqn = name.apply(a.javaEnvironment()).map(ITypeNameSupplier::fqn);
        return fqn.isPresent() && fqn.orElseThrow().equals(a.name());
    }

    private static Spliterator<IAnnotation> getAnnotationsSpliterator(IAnnotatable o) {
        return new WrappingSpliterator<IAnnotation>(o.unwrap().getAnnotations());
    }

    protected Stream<T> createStream() {
        Function levelSpliteratorProvider = this.lookupOwnerOnLevel().andThen(owner -> owner.map(AnnotationQuery::getAnnotationsSpliterator).orElse(null));
        Stream<IAnnotation> result = new HierarchicalStreamBuilder().withSuperClasses(this.isIncludeSuperClasses()).withSuperInterfaces(this.isIncludeSuperInterfaces()).withStartType(true).build((IType)Ensure.notNull((Object)this.getType()), levelSpliteratorProvider).filter(this);
        Class<AbstractManagedAnnotation> wrapperClass = this.getManagedWrapper();
        if (wrapperClass == null) {
            return result;
        }
        Stream<AbstractManagedAnnotation> converted = result.map(annotation -> annotation.wrap(wrapperClass));
        return converted;
    }
}

