/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.eventimpl;

import java.util.List;
import java.util.Vector;
import org.eclipse.wst.css.core.internal.event.ICSSStyleListener;
import org.eclipse.wst.css.core.internal.event.ICSSStyleNotifier;
import org.eclipse.wst.css.core.internal.eventimpl.CSSStyleEventDeliverer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.css.core.internal.util.ImportedCollector;
import org.eclipse.wst.css.core.internal.util.SelectorsCollector;

public class CSSStyleNotifyAdapter
implements ICSSStyleNotifier {
    protected Vector listeners;
    protected final ICSSModel model;
    protected boolean recording = false;

    public CSSStyleNotifyAdapter(ICSSModel model) {
        this.model = model;
    }

    @Override
    public void addStyleListener(ICSSStyleListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(listener)) {
            ImportedCollector trav = new ImportedCollector();
            trav.apply(this.model.getDocument());
            for (ICSSStyleSheet sheet : trav.getExternals()) {
                SelectorsCollector selTrav = new SelectorsCollector();
                selTrav.apply(sheet);
                int nSel = selTrav.getSelectors().size();
                ICSSSelector[] added = new ICSSSelector[nSel];
                int i = 0;
                while (i < nSel) {
                    added[i] = (ICSSSelector)selTrav.getSelectors().get(i);
                    ++i;
                }
                CSSStyleEventDeliverer deliverer = new CSSStyleEventDeliverer();
                deliverer.fireTo(listener, sheet.getModel(), null, added, null);
            }
            this.listeners.add(listener);
        }
    }

    public void beginRecording() {
        this.recording = true;
    }

    public void endRecording() {
        this.recording = false;
    }

    public void fire(ICSSSelector[] removed, ICSSSelector[] added, String media) {
        CSSStyleEventDeliverer deliv = new CSSStyleEventDeliverer();
        deliv.fire(this.model, removed, added, null);
    }

    @Override
    public List getStyleListeners() {
        return this.listeners;
    }

    @Override
    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public void removeStyleListener(ICSSStyleListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
            ImportedCollector trav = new ImportedCollector();
            trav.apply(this.model.getDocument());
            for (ICSSStyleSheet sheet : trav.getExternals()) {
                SelectorsCollector selTrav = new SelectorsCollector();
                selTrav.apply(sheet);
                int nSel = selTrav.getSelectors().size();
                ICSSSelector[] removed = new ICSSSelector[nSel];
                int i = 0;
                while (i < nSel) {
                    removed[i] = (ICSSSelector)selTrav.getSelectors().get(i);
                    ++i;
                }
                CSSStyleEventDeliverer deliverer = new CSSStyleEventDeliverer();
                deliverer.fireTo(listener, sheet.getModel(), removed, null, null);
            }
        }
    }

    @Override
    public void styleChanged(ICSSModel srcModel, ICSSSelector[] removed, ICSSSelector[] added, String media) {
    }

    @Override
    public void styleUpdate(ICSSModel srcModel) {
    }
}

