/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import org.eclipse.ant.internal.ui.AntSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.text.AntDocumentSetupParticipant;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AntSourceViewerInformationControl
implements IInformationControl,
IInformationControlExtension,
DisposeListener {
    private Shell fShell;
    private final SourceViewer fViewer;
    private StyledText fText;

    public AntSourceViewerInformationControl(Shell parent) {
        this.fShell = new Shell(parent, 16388);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        Shell composite = this.fShell;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        this.fViewer = this.createViewer((Composite)composite);
        this.fText = this.fViewer.getTextWidget();
        gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.fText.setForeground(parent.getDisplay().getSystemColor(28));
        this.fText.setBackground(parent.getDisplay().getSystemColor(29));
        this.fText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AntSourceViewerInformationControl.this.fShell.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, 0);
        AntSourceViewerConfiguration configuration = new AntSourceViewerConfiguration();
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
        viewer.getTextWidget().setFont(font);
        return viewer;
    }

    public void setInformation(String content) {
        if (content == null) {
            this.fViewer.setInput(null);
            return;
        }
        Document document = new Document(content);
        new AntDocumentSetupParticipant().setup((IDocument)document);
        this.fViewer.setDocument((IDocument)document);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public void setVisible(boolean visible) {
        this.fShell.setVisible(visible);
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void setLocation(Point location) {
        Rectangle trim = this.fShell.computeTrim(0, 0, 0, 0);
        Point textLocation = this.fText.getLocation();
        location.x += trim.x - textLocation.x;
        location.y += trim.y - textLocation.y;
        this.fShell.setLocation(location);
    }

    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.fShell = null;
        this.fText = null;
    }
}

