/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.JavaEnvironmentWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.internal.AnnotationImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class BindingAnnotationWithEcj
extends AbstractJavaElementWithEcj<IAnnotation>
implements AnnotationSpi {
    private final AnnotatableSpi m_owner;
    private final AnnotationBinding m_binding;
    private final FinalValue<Map<String, AnnotationElementSpi>> m_values;
    private final FinalValue<TypeSpi> m_type;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<Annotation> m_annotationDeclaration;

    protected BindingAnnotationWithEcj(AbstractJavaEnvironment env, AnnotatableSpi owner, AnnotationBinding binding) {
        super(env);
        this.m_binding = (AnnotationBinding)Ensure.notNull((Object)binding);
        this.m_owner = (AnnotatableSpi)Ensure.notNull((Object)owner);
        this.m_values = new FinalValue();
        this.m_type = new FinalValue();
        this.m_source = new FinalValue();
        this.m_annotationDeclaration = new FinalValue();
    }

    public AnnotationSpi internalFindNewElement() {
        return SpiWithEcjUtils.findNewAnnotationIn(this.getOwner(), this.getElementName());
    }

    protected IAnnotation internalCreateApi() {
        return new AnnotationImplementor((AnnotationSpi)this);
    }

    public AnnotationBinding getInternalBinding() {
        return this.m_binding;
    }

    protected static ReferenceBinding getBindingAnnotationType(BindingAnnotationWithEcj a) {
        return a.m_binding.getAnnotationType();
    }

    public TypeSpi getType() {
        return (TypeSpi)this.m_type.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), (TypeBinding)BindingAnnotationWithEcj.getBindingAnnotationType(this), () -> (TypeBinding)this.withNewElement(BindingAnnotationWithEcj::getBindingAnnotationType)));
    }

    private static <T> Map<T, Integer> buildPositionsMap(Collection<T> collection) {
        HashMap<T, Integer> elementPositionMap = new HashMap<T, Integer>(collection.size());
        int pos = 0;
        for (T name : collection) {
            elementPositionMap.put(name, pos);
            ++pos;
        }
        return elementPositionMap;
    }

    private static Map<String, AnnotationElementSpi> buildAnnotationElementMap(Map<String, ?> defaultsMap, Object[] declaredPairs, AnnotationSpi owner, JavaEnvironmentWithEcj env) {
        Map<String, Integer> elementPositionMap = BindingAnnotationWithEcj.buildPositionsMap(defaultsMap.keySet());
        AnnotationElementSpi[] resultArr = new AnnotationElementSpi[defaultsMap.size()];
        if (declaredPairs != null) {
            for (Object declaredPair : declaredPairs) {
                AnnotationElementSpi v = BindingAnnotationWithEcj.createAnnotationElementSpi(declaredPair, false, owner, env);
                Integer idx = elementPositionMap.get(v.getElementName());
                resultArr[idx.intValue()] = v;
            }
        }
        int pos = 0;
        LinkedHashMap<String, AnnotationElementSpi> result = new LinkedHashMap<String, AnnotationElementSpi>(defaultsMap.size());
        for (Map.Entry<String, ?> e : defaultsMap.entrySet()) {
            AnnotationElementSpi declaredElement = resultArr[pos];
            if (declaredElement == null) {
                Object defaultValue = e.getValue();
                String name = e.getKey();
                if (defaultValue == null) {
                    result.put(name, env.createNullAnnotationValue(owner, name, true));
                } else {
                    result.put(name, BindingAnnotationWithEcj.createAnnotationElementSpi(defaultValue, true, owner, env));
                }
            } else {
                result.put(declaredElement.getElementName(), declaredElement);
            }
            ++pos;
        }
        return result;
    }

    private static AnnotationElementSpi createAnnotationElementSpi(Object nameValuePair, boolean syntheticDefaultValue, AnnotationSpi owner, JavaEnvironmentWithEcj env) {
        if (nameValuePair instanceof MemberValuePair) {
            return env.createDeclarationAnnotationValue(owner, (MemberValuePair)nameValuePair, syntheticDefaultValue);
        }
        if (nameValuePair instanceof ElementValuePair) {
            return env.createBindingAnnotationValue(owner, (ElementValuePair)nameValuePair, syntheticDefaultValue);
        }
        throw Ensure.newFail((CharSequence)"Unsupported annotation element type: '{}'.", (Object[])new Object[]{nameValuePair});
    }

    private static Map<String, ?> getAnnotationDefaultValues(TypeBinding annotationType, JavaEnvironmentWithEcj env) {
        if (annotationType instanceof ReferenceBinding) {
            return env.getBindingAnnotationSyntheticDefaultValues((ReferenceBinding)annotationType);
        }
        return env.getDeclarationAnnotationSyntheticDefaultValues(annotationType);
    }

    static Map<String, AnnotationElementSpi> buildAnnotationElementMap(Object annotation, AnnotationSpi owner, JavaEnvironmentWithEcj env) {
        TypeBinding annotationType;
        Object[] explicitValues;
        if (annotation instanceof Annotation) {
            Annotation binding = (Annotation)annotation;
            explicitValues = binding.memberValuePairs();
            annotationType = binding.type.resolvedType;
        } else if (annotation instanceof AnnotationBinding) {
            AnnotationBinding binding = (AnnotationBinding)annotation;
            explicitValues = binding.getElementValuePairs();
            annotationType = binding.getAnnotationType();
        } else {
            throw Ensure.newFail((CharSequence)"Unsupported annotation type: '{}'.", (Object[])new Object[]{annotation});
        }
        Map<String, ?> defaultValues = BindingAnnotationWithEcj.getAnnotationDefaultValues(annotationType, env);
        return BindingAnnotationWithEcj.buildAnnotationElementMap(defaultValues, explicitValues, owner, env);
    }

    public Map<String, AnnotationElementSpi> getValues() {
        return (Map)this.m_values.computeIfAbsentAndGet(() -> BindingAnnotationWithEcj.buildAnnotationElementMap(this.m_binding, this, this.javaEnvWithEcj()));
    }

    public AnnotatableSpi getOwner() {
        return this.m_owner;
    }

    public String getElementName() {
        return this.getType().getElementName();
    }

    Annotation annotationDeclaration() {
        return (Annotation)this.m_annotationDeclaration.computeIfAbsentAndGet(() -> SpiWithEcjUtils.findAnnotationDeclaration(this));
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            Annotation decl = this.annotationDeclaration();
            if (decl == null) {
                return null;
            }
            CompilationUnitSpi cu = SpiWithEcjUtils.declaringTypeOf(this).getCompilationUnit();
            return this.javaEnvWithEcj().getSource(cu, decl.sourceStart, decl.declarationSourceEnd);
        });
    }
}

