/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.io.PrintWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.scout.sdk.core.log.SdkLog;

public class EcjAstCompiler
extends Compiler {
    private static final Level VERBOSE_LOG_LEVEL = Level.FINER;
    private final Map<CompilationUnitDeclaration, ICompilationUnit> m_sources = new HashMap<CompilationUnitDeclaration, ICompilationUnit>();
    private final Object m_lock;

    protected EcjAstCompiler(INameEnvironment nameEnv, CompilerOptions opts, Object lock) {
        super(nameEnv, DefaultErrorHandlingPolicies.proceedWithAllProblems(), opts == null ? EcjAstCompiler.createDefaultOptions() : opts, (ICompilerRequestor)new EmptyCompilerRequestor(), (IProblemFactory)new CollectingProblemFactory(), new PrintWriter(new SdkLogWriter()), null);
        this.m_lock = lock;
        this.lookupEnvironment.completeTypeBindings();
    }

    public static CompilerOptions createDefaultOptions() {
        CompilerOptions result = new CompilerOptions();
        result.produceDebugAttributes = 0;
        result.originalComplianceLevel = result.complianceLevel = ClassFileConstants.getLatestJDKLevel();
        result.sourceLevel = result.complianceLevel;
        result.originalSourceLevel = result.complianceLevel;
        result.targetJDK = result.complianceLevel;
        result.verbose = SdkLog.isLevelEnabled((Level)VERBOSE_LOG_LEVEL);
        result.preserveAllLocalVariables = true;
        result.parseLiteralExpressionsAsConstants = false;
        result.reportUnusedParameterIncludeDocCommentReference = false;
        result.reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable = false;
        result.suppressOptionalErrors = true;
        result.performMethodsFullRecovery = false;
        result.performStatementsRecovery = true;
        result.generateClassFiles = false;
        result.reportMissingOverrideAnnotationForInterfaceMethodImplementation = false;
        result.ignoreSourceFolderWarningOption = true;
        result.analyseResourceLeaks = false;
        result.ignoreMethodBodies = true;
        result.docCommentSupport = true;
        result.isAnnotationBasedNullAnalysisEnabled = false;
        result.storeAnnotations = true;
        return result;
    }

    protected synchronized void addCompilationUnit(ICompilationUnit sourceUnit, CompilationUnitDeclaration parsedUnit) {
        super.addCompilationUnit(sourceUnit, parsedUnit);
        this.m_sources.put(parsedUnit, sourceUnit);
    }

    public synchronized ICompilationUnit getSource(CompilationUnitDeclaration decl) {
        return this.m_sources.get(decl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCompileErrors(CompilationUnitDeclaration unit) {
        Object object = this.m_lock;
        synchronized (object) {
            this.process(unit, 0);
        }
        CategorizedProblem[] errors = unit.compilationResult().getErrors();
        if (errors == null || errors.length < 1) {
            return Collections.emptyList();
        }
        return Arrays.stream(errors).map(IProblem::getMessage).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(IModule module, LookupEnvironment environment) {
        Object object = this.m_lock;
        synchronized (object) {
            super.accept(module, environment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        Object object = this.m_lock;
        synchronized (object) {
            super.accept(binaryType, packageBinding, accessRestriction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        Object object = this.m_lock;
        synchronized (object) {
            super.accept(sourceTypes, packageBinding, accessRestriction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        Object object = this.m_lock;
        synchronized (object) {
            super.accept(sourceUnit, accessRestriction);
        }
    }

    static final class EmptyCompilerRequestor
    implements ICompilerRequestor {
        EmptyCompilerRequestor() {
        }

        public void acceptResult(CompilationResult result) {
        }
    }

    static final class CollectingProblemFactory
    extends DefaultProblemFactory {
        CollectingProblemFactory() {
        }

        public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
            return this.createProblem(originatingFileName, problemId, problemArguments, 0, messageArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
        }

        public CategorizedProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, int elaborationId, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber, int columnNumber) {
            if ((severity & 0x281) != 0) {
                String txt = this.getLocalizedMessage(problemId, elaborationId, messageArguments);
                StringBuilder msg = new StringBuilder(txt.length() + 128);
                if (originatingFileName != null) {
                    msg.append(originatingFileName).append(':');
                }
                if (lineNumber > 0) {
                    msg.append(lineNumber);
                }
                if (!msg.isEmpty()) {
                    msg.append(' ');
                }
                msg.append(txt);
                return new DefaultProblem(originatingFileName, msg.toString(), problemId, problemArguments, severity, startPosition, endPosition, lineNumber, columnNumber);
            }
            return null;
        }
    }

    static final class SdkLogWriter
    extends Writer {
        SdkLogWriter() {
        }

        @Override
        public void write(char[] buffer, int off, int len) {
            if (!SdkLog.isLevelEnabled((Level)VERBOSE_LOG_LEVEL)) {
                return;
            }
            SdkLog.log((Level)VERBOSE_LOG_LEVEL, (CharSequence)CharBuffer.wrap(buffer, off, len), (Object[])new Object[0]);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

