/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.StreamUtils;
import org.eclipse.scout.sdk.core.util.Strings;

public class JreInfo {
    public static final String VERSION_1_8 = "1.8";
    private final Path m_rtSrcZip;
    private final boolean m_supportsJrtModules;
    private final Path m_jreHome;
    private final String m_version;
    private final FinalValue<List<Path>> m_bootClasspath;
    private final int m_feature;

    public JreInfo(Path jreHome) {
        this.m_jreHome = (Path)Ensure.notNull((Object)jreHome);
        this.m_rtSrcZip = JreInfo.resolveRtSourceZip(jreHome);
        Path jrt = jreHome.resolve("lib").resolve("jrt-fs.jar");
        this.m_supportsJrtModules = Files.isReadable(jrt) && Files.isRegularFile(jrt, new LinkOption[0]);
        this.m_version = JreInfo.computeVersion(jreHome);
        this.m_feature = JreInfo.computeFeatureLevel(this.m_version);
        this.m_bootClasspath = new FinalValue();
    }

    public Path rtSrcZip() {
        return this.m_rtSrcZip;
    }

    public String version() {
        return this.m_version;
    }

    public int feature() {
        return this.m_feature;
    }

    public Path jreHome() {
        return this.m_jreHome;
    }

    public boolean supportsJrtModules() {
        return this.m_supportsJrtModules;
    }

    public List<Path> bootClasspath() {
        return (List)this.m_bootClasspath.computeIfAbsentAndGet(() -> {
            if (this.supportsJrtModules()) {
                return Collections.emptyList();
            }
            return this.resolvePlatformLibrariesLegacy();
        });
    }

    protected List<Path> resolvePlatformLibrariesLegacy() {
        Path jreHome = this.jreHome();
        Stream<Path> libDirs = Stream.of(jreHome.resolve("lib"), jreHome.resolve("lib/ext"));
        List result = libDirs.flatMap(JreInfo::listFiles).filter(JreInfo::isArchive).collect(Collectors.toList());
        Optional.of(jreHome.resolve("classes")).filter(Files::isReadable).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).ifPresent(result::add);
        return Collections.unmodifiableList(result);
    }

    protected static int computeFeatureLevel(String version) {
        if (version.startsWith("1.") && version.length() > 2) {
            return Integer.parseInt(version, 2, version.length(), 10);
        }
        int dotPos = version.indexOf(46);
        if (dotPos > 0) {
            return Integer.parseInt(version, 0, dotPos, 10);
        }
        return Integer.parseInt(version);
    }

    protected static String computeVersion(Path jreHome) {
        Path release = jreHome.resolve("release");
        if (!Files.isReadable(release) || !Files.isRegularFile(release, new LinkOption[0])) {
            return VERSION_1_8;
        }
        try {
            String parsedVersion = JreInfo.parseVersion(Files.readAllLines(release, StandardCharsets.UTF_8));
            return (String)Ensure.notNull((Object)parsedVersion, (CharSequence)"Cannot parse Java version for location '{}'.", (Object[])new Object[]{jreHome});
        }
        catch (IOException e) {
            throw new SdkException((CharSequence)"Error parsing Java release file: '{}'.", new Object[]{jreHome, e});
        }
    }

    protected static String parseVersion(Iterable<String> lines) {
        String prefix = "JAVA_VERSION=";
        for (String line : lines) {
            CharSequence value;
            if (Strings.isBlank((CharSequence)line) || !Strings.startsWith((String)line, (String)prefix, (boolean)false) || (value = Strings.withoutQuotes((CharSequence)Strings.trim((CharSequence)line.substring(prefix.length())))).isEmpty()) continue;
            return JreInfo.parseVersion(value);
        }
        return null;
    }

    protected static String parseVersion(CharSequence versionString) {
        char dot = '.';
        int firstDot = Strings.indexOf((char)dot, (CharSequence)versionString);
        if (firstDot < 1) {
            return versionString.toString();
        }
        StringBuilder majorAndMinor = new StringBuilder(5);
        majorAndMinor.append(versionString.subSequence(0, firstDot));
        int secondDot = Strings.indexOf((char)dot, (CharSequence)versionString, (int)(firstDot + 1));
        if (secondDot > firstDot + 1) {
            majorAndMinor.append(dot).append(versionString.subSequence(firstDot + 1, secondDot));
        }
        while (majorAndMinor.length() > 2 && majorAndMinor.charAt(majorAndMinor.length() - 2) == dot && majorAndMinor.charAt(majorAndMinor.length() - 1) == '0') {
            majorAndMinor.delete(majorAndMinor.length() - 2, majorAndMinor.length());
        }
        return majorAndMinor.toString();
    }

    protected static Stream<Path> listFiles(Path directory) {
        if (!Files.isReadable(directory) || !Files.isDirectory(directory, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            return Files.list(directory);
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected static boolean isArchive(Path candidate) {
        Path fileName = candidate.getFileName();
        if (fileName == null) {
            return false;
        }
        String name = fileName.toString().toLowerCase(Locale.US);
        return name.endsWith(".jar") || name.endsWith(".zip");
    }

    public static Path resolveRtSourceZip(Path jreHome) {
        if (jreHome == null) {
            return null;
        }
        Path innerSrcZip = jreHome.resolve("lib/src.zip");
        if (Files.isReadable(innerSrcZip) && Files.isRegularFile(innerSrcZip, new LinkOption[0])) {
            return innerSrcZip;
        }
        Path parent = jreHome.getParent();
        if (parent == null) {
            return null;
        }
        return parent.resolve("src.zip");
    }

    public static Path runningJavaHome() {
        return ((File)Ensure.notNull((Object)Util.getJavaHome(), (CharSequence)"Cannot calculate the running Java home. Please specify a JRE home explicitly.", (Object[])new Object[0])).toPath();
    }

    public static JreInfo runningJreInfo() {
        return new JreInfo(JreInfo.runningJavaHome());
    }

    public static Stream<Path> runningUserClassPath(Path javaHome) {
        String javaClassPathRaw = System.getProperty("java.class.path");
        if (Strings.isBlank((CharSequence)javaClassPathRaw)) {
            return Stream.empty();
        }
        Path jreHome = Optional.ofNullable(javaHome).orElseGet(JreInfo::runningJavaHome);
        return StreamUtils.toStream((Enumeration)new StringTokenizer(javaClassPathRaw, File.pathSeparator)).map(Object::toString).map(x$0 -> Paths.get(x$0, new String[0])).filter(classpathItem -> !JreInfo.isJreLib(classpathItem, jreHome));
    }

    protected static boolean isJreLib(Path candidate, Path javaHome) {
        return candidate != null && candidate.startsWith(javaHome);
    }

    public String toString() {
        return JreInfo.class.getSimpleName() + " for " + this.jreHome();
    }

    public int hashCode() {
        return this.m_jreHome.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JreInfo other = (JreInfo)obj;
        return this.m_jreHome.equals(other.m_jreHome);
    }
}

