/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dataobject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.java.apidef.ITypeNameSupplier;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.s.dataobject.DataObjectNode;
import org.eclipse.scout.sdk.core.s.java.annotation.GeneratedAnnotation;
import org.eclipse.scout.sdk.core.s.java.annotation.IgnoreConvenienceMethodGenerationAnnotation;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutInterfaceApi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class DataObjectModel {
    private final IType m_source;
    private final List<DataObjectNode> m_nodes;

    protected DataObjectModel(IType source, List<DataObjectNode> nodes) {
        this.m_source = (IType)Ensure.notNull((Object)source);
        this.m_nodes = nodes;
    }

    public static Optional<DataObjectModel> wrap(IType dataObject) {
        return Optional.ofNullable(dataObject).filter(DataObjectModel::isValid).map(DataObjectModel::parse);
    }

    protected static boolean isValid(IType candidate) {
        int flags = candidate.flags();
        if (Flags.isInterface((int)flags) || !Flags.isPublic((int)flags) || Flags.isEnum((int)flags)) {
            return false;
        }
        Optional scoutApi = candidate.javaEnvironment().api(IScoutApi.class);
        if (scoutApi.isEmpty()) {
            return false;
        }
        IScoutInterfaceApi.IDataObject iDataObject = ((IScoutApi)scoutApi.orElseThrow()).IDataObject();
        return !DataObjectModel.isIgnored((IAnnotatable)candidate) && candidate.isInstanceOf((ITypeNameSupplier)iDataObject);
    }

    protected static boolean isIgnored(IAnnotatable annotatable) {
        return annotatable.annotations().withManagedWrapper(IgnoreConvenienceMethodGenerationAnnotation.class).existsAny();
    }

    protected static DataObjectModel parse(IType dataObject) {
        LinkedHashMap nodes = dataObject.methods().withSuperTypes(true).withFlags(1).stream().flatMap(m -> DataObjectModel.parseDoMethod(dataObject, m).stream()).collect(Collectors.toMap(DataObjectNode::name, Function.identity(), DataObjectModel::preferInheritedNodes, LinkedHashMap::new));
        return new DataObjectModel(dataObject, new ArrayList<DataObjectNode>(nodes.values()));
    }

    protected static DataObjectNode preferInheritedNodes(DataObjectNode a, DataObjectNode b) {
        if (b.isInherited() && !a.isInherited()) {
            return b;
        }
        return a;
    }

    protected static Optional<DataObjectNode> parseDoMethod(IType source, IMethod method) {
        int flags = method.flags();
        if (method.isConstructor() || Flags.isStatic((int)flags)) {
            return Optional.empty();
        }
        if (Flags.isBridge((int)flags) || Flags.isSynthetic((int)flags)) {
            return Optional.empty();
        }
        int declaringTypeFlags = method.requireDeclaringType().flags();
        if (Flags.isInterface((int)declaringTypeFlags)) {
            return Optional.empty();
        }
        boolean hasParameters = method.parameters().first().isPresent();
        if (hasParameters || DataObjectModel.isIgnored((IAnnotatable)method)) {
            return Optional.empty();
        }
        if (method.annotations().withManagedWrapper(GeneratedAnnotation.class).existsAny()) {
            return Optional.empty();
        }
        IType returnType = method.requireReturnType();
        Optional<DataObjectNode.DataObjectNodeKind> optKind = DataObjectNode.DataObjectNodeKind.valueOf(returnType);
        if (optKind.isEmpty()) {
            return Optional.empty();
        }
        Optional<IType> optDoValue = DataObjectModel.parseValueType(returnType);
        if (optDoValue.isEmpty()) {
            return Optional.empty();
        }
        IType declaringType = method.declaringType().orElse(null);
        boolean hasJavaDoc = method.javaDoc().isPresent();
        boolean isInherited = declaringType != source || DataObjectModel.isImplementedInSuperHierarchy(method);
        return Optional.of(new DataObjectNode(optKind.orElseThrow(), method, optDoValue.orElseThrow(), isInherited, hasJavaDoc));
    }

    protected static boolean isImplementedInSuperHierarchy(IMethod method) {
        return method.superMethods().withSelf(false).stream().anyMatch(sm -> !Flags.isAbstract((int)sm.flags()) && !Flags.isInterface((int)sm.flags()));
    }

    protected static Optional<IType> parseValueType(IType returnType) {
        return returnType.typeArguments().findAny();
    }

    public List<DataObjectNode> nodes() {
        return Collections.unmodifiableList(this.m_nodes);
    }

    public IType unwrap() {
        return this.m_source;
    }

    public String toString() {
        return new StringJoiner(", ", DataObjectModel.class.getSimpleName() + " [", "]").add("source=" + this.m_source).add("nodes=" + this.m_nodes).toString();
    }
}

