/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.dataobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.comment.IJavaElementCommentBuilder;
import org.eclipse.scout.sdk.core.java.generator.IAnnotatableGenerator;
import org.eclipse.scout.sdk.core.java.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotatable;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.s.dataobject.DataObjectModel;
import org.eclipse.scout.sdk.core.s.dataobject.DataObjectNode;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.environment.SdkFuture;
import org.eclipse.scout.sdk.core.s.java.annotation.GeneratedAnnotation;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutAnnotationApi;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.generator.annotation.ScoutAnnotationGenerator;
import org.eclipse.scout.sdk.core.s.java.generator.method.IScoutMethodGenerator;
import org.eclipse.scout.sdk.core.s.java.generator.method.ScoutDoMethodGenerator;
import org.eclipse.scout.sdk.core.util.SourceRange;
import org.eclipse.scout.sdk.core.util.SourceState;
import org.eclipse.scout.sdk.core.util.Strings;

public class DoConvenienceMethodsUpdateOperation
implements BiConsumer<IEnvironment, IProgress> {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("import\\s+[\\w_.]+;");
    private final List<IType> m_dataObjects = new ArrayList<IType>();
    private String m_lineSeparator;

    @Override
    public void accept(IEnvironment environment, IProgress progress) {
        List<IType> dataObjects = this.dataObjects();
        progress.init(dataObjects.size(), this.toString(), new Object[0]);
        List writeOperations = dataObjects.stream().flatMap(t -> this.updateDataObject((IType)t, environment, progress.newChild(1)).stream()).collect(Collectors.toList());
        SdkFuture.awaitAll(writeOperations);
    }

    protected Optional<IFuture<IType>> updateDataObject(IType dataObject, IEnvironment environment, IProgress progress) {
        return DataObjectModel.wrap(dataObject).flatMap(this::buildNewSource).map(newSrc -> this.write((CharSequence)newSrc, dataObject, environment, progress));
    }

    protected IFuture<IType> write(CharSequence newSource, IType dataObjectType, IEnvironment environment, IProgress progress) {
        return environment.writeCompilationUnitAsync(newSource, dataObjectType.requireCompilationUnit(), progress);
    }

    protected Optional<CharSequence> buildNewSource(DataObjectModel dataObject) {
        IType dataObjectType = dataObject.unwrap();
        Optional originalSource = dataObjectType.requireCompilationUnit().source();
        if (originalSource.isEmpty()) {
            return Optional.empty();
        }
        CharSequence cuSource = ((SourceRange)originalSource.orElseThrow()).asCharSequence();
        JavaBuilderContext buildContext = new JavaBuilderContext(dataObjectType.javaEnvironment());
        HashSet replacedMethods = new HashSet();
        IScoutApi scoutApi = (IScoutApi)dataObjectType.javaEnvironment().requireApi(IScoutApi.class);
        List<Replacement> replacements = dataObject.nodes().stream().flatMap(node -> this.buildMethodGeneratorsFor((DataObjectNode)node, dataObjectType, scoutApi)).flatMap(gen -> this.buildReplacements((IMethodGenerator<?, ?>)gen, dataObjectType, cuSource, (IJavaBuilderContext)buildContext, replacedMethods)).collect(Collectors.toList());
        dataObjectType.methods().withAnnotationFrom(IScoutApi.class, IScoutAnnotationApi::Generated).stream().filter(m -> !replacedMethods.contains(m)).filter(this::hasDoConvenienceGeneratedAnnotation).map(m -> this.toMethodDeleteReplacement((IMethod)m, cuSource)).forEach(replacements::add);
        if (replacements.isEmpty()) {
            return Optional.empty();
        }
        replacements.sort(Comparator.comparingInt(Replacement::offset).thenComparing(Replacement::order));
        this.addConvenienceMethodsMarkerCommentToFirst(replacements);
        CharSequence newSource = this.insertMissingImports((IJavaBuilderContext)buildContext, this.applyModifications(replacements, cuSource));
        return Optional.of(newSource);
    }

    protected void addConvenienceMethodsMarkerCommentToFirst(Collection<Replacement> replacements) {
        replacements.stream().filter(r -> !r.newSource().isEmpty()).findFirst().ifPresent(r -> r.setNewSource(this.lineSeparator() + ScoutDoMethodGenerator.convenienceMethodsMarkerComment(this.lineSeparator()) + this.lineSeparator() + r.newSource()));
    }

    protected CharSequence insertMissingImports(IJavaBuilderContext buildContext, CharSequence newSource) {
        String importsToAdd = buildContext.validator().importCollector().createImportDeclarations(false).collect(Collectors.joining(this.lineSeparator(), this.lineSeparator(), ""));
        if (Strings.isBlank((CharSequence)importsToAdd)) {
            return newSource;
        }
        return IMPORT_PATTERN.matcher(newSource).results().filter(r -> SourceState.isInCode((CharSequence)newSource, (int)r.start())).findAny().map(r -> this.insertInto(newSource, importsToAdd, r.end())).orElse(newSource);
    }

    protected CharSequence insertInto(CharSequence target, String insertText, int pos) {
        return new StringBuilder(target).insert(pos, insertText);
    }

    protected CharSequence applyModifications(Iterable<Replacement> replacements, CharSequence originalSource) {
        StringBuilder newSource = new StringBuilder();
        int startPos = 0;
        for (Replacement replacement : replacements) {
            newSource.append(originalSource, startPos, replacement.offset());
            newSource.append(replacement.newSource());
            startPos = replacement.offset() + replacement.length();
        }
        newSource.append(originalSource, startPos, originalSource.length());
        return newSource.toString();
    }

    protected String createMethodDeclarationSource(IMethod m) {
        List paramSource = m.parameters().stream().map(p -> (SourceRange)p.source().orElseThrow()).map(SourceRange::asCharSequence).collect(Collectors.toList());
        return JavaTypes.createMethodIdentifier((CharSequence)m.elementName(), paramSource);
    }

    protected String createMethodDeclarationSource(IMethodGenerator<?, ?> m, IJavaBuilderContext context) {
        List paramSource = m.parameters().map(p -> p.toJavaSource(context)).collect(Collectors.toList());
        return JavaTypes.createMethodIdentifier((CharSequence)((CharSequence)m.elementName(context).orElseThrow()), paramSource);
    }

    protected Stream<Replacement> buildReplacements(IMethodGenerator<?, ?> generator, IType dataObjectType, CharSequence cuSource, IJavaBuilderContext context, Collection<IMethod> replacedMethods) {
        String methodDeclarationSource = this.createMethodDeclarationSource(generator, context);
        String methodName = (String)generator.elementName(context).orElseThrow();
        Optional<IMethod> existingMethod = dataObjectType.methods().withName(methodName).stream().filter(m -> methodDeclarationSource.equals(this.createMethodDeclarationSource((IMethod)m))).findAny();
        int insertIndex = ((SourceRange)dataObjectType.source().orElseThrow()).end() - 1;
        StringBuilder newSource = generator.toJavaSource(context);
        Replacement newMethodReplacement = new Replacement(insertIndex, 0, newSource);
        if (existingMethod.isEmpty()) {
            return Stream.of(newMethodReplacement);
        }
        IMethod methodToDelete = existingMethod.orElseThrow();
        replacedMethods.add(methodToDelete);
        Replacement methodDeleteReplacement = this.toMethodDeleteReplacement(methodToDelete, cuSource);
        return Stream.of(methodDeleteReplacement, newMethodReplacement);
    }

    protected boolean hasDoConvenienceGeneratedAnnotation(IAnnotatable annotatable) {
        List generatedValues = annotatable.annotations().withManagedWrapper(GeneratedAnnotation.class).first().map(GeneratedAnnotation::value).map(Arrays::asList).orElse(Collections.emptyList());
        if (generatedValues.isEmpty()) {
            return false;
        }
        return generatedValues.contains("DoConvenienceMethodsGenerator");
    }

    protected Replacement toMethodDeleteReplacement(IMethod method, CharSequence cuSource) {
        SourceRange sourceRange = (SourceRange)method.source().orElseThrow();
        int methodStartOffset = sourceRange.start();
        int declarationStartRelativeToMethodSource = ((SourceRange)method.sourceOfDeclaration().orElseThrow()).start() - sourceRange.start();
        int pos = Strings.indexOf((CharSequence)"/* ******************", (CharSequence)sourceRange.asCharSequence(), (int)0, (int)declarationStartRelativeToMethodSource);
        if (pos > 0) {
            methodStartOffset += pos;
        }
        while (methodStartOffset >= 1 && Character.isWhitespace(cuSource.charAt(methodStartOffset - 1))) {
            --methodStartOffset;
        }
        return new Replacement(methodStartOffset, sourceRange.end() - methodStartOffset + 1, "");
    }

    protected Stream<IScoutMethodGenerator<?, ?>> buildMethodGeneratorsFor(DataObjectNode node, IType owner, IScoutAnnotationApi scoutApi) {
        Stream<IScoutMethodGenerator<?, ?>> methodGenerators = ScoutDoMethodGenerator.createConvenienceMethods(node.name(), node.kind(), node.dataType().reference(), node.isInherited(), owner);
        methodGenerators = methodGenerators.peek(g -> this.copyAnnotations((IAnnotatable)node.method(), (IAnnotatableGenerator<?>)g, scoutApi));
        if (!node.hasJavaDoc()) {
            return methodGenerators;
        }
        return methodGenerators.peek(g -> g.withComment(b -> this.appendJavaDocLink((IJavaElementCommentBuilder<?>)b, node.name())));
    }

    protected void copyAnnotations(IAnnotatable source, IAnnotatableGenerator<?> target, IScoutAnnotationApi scoutApi) {
        source.annotations().stream().filter(a -> !this.isAnnotationIgnoredForCopy((IAnnotation)a, scoutApi)).map(IAnnotation::toWorkingCopy).forEach(arg_0 -> target.withAnnotation(arg_0));
    }

    protected boolean isAnnotationIgnoredForCopy(IAnnotation a, IScoutAnnotationApi scoutApi) {
        String annotationFqn = a.type().name();
        return Override.class.getName().equals(annotationFqn) || scoutApi.AttributeName().fqn().equals(annotationFqn) || scoutApi.ValueFormat().fqn().equals(annotationFqn);
    }

    protected void appendJavaDocLink(IJavaElementCommentBuilder<?> b, String name) {
        ((IJavaElementCommentBuilder)((IJavaElementCommentBuilder)((IJavaElementCommentBuilder)((IJavaElementCommentBuilder)((IJavaElementCommentBuilder)((IJavaElementCommentBuilder)b.appendJavaDocStart()).nl()).append("* See ")).appendLink((CharSequence)("#" + name + "()")).append('.')).nl()).appendBlockCommentEnd()).nl();
    }

    protected IAnnotationGenerator<?> createGenerated() {
        return ScoutAnnotationGenerator.createGenerated("DoConvenienceMethodsGenerator", null);
    }

    public List<IType> dataObjects() {
        return Collections.unmodifiableList(this.m_dataObjects);
    }

    public DoConvenienceMethodsUpdateOperation withDataObjects(Collection<IType> dos) {
        this.m_dataObjects.clear();
        this.m_dataObjects.addAll(dos);
        return this;
    }

    public DoConvenienceMethodsUpdateOperation withLineSeparator(String lineSeparator) {
        this.m_lineSeparator = lineSeparator;
        return this;
    }

    public String lineSeparator() {
        return this.m_lineSeparator;
    }

    public String toString() {
        return "Update DataObject convenience methods";
    }

    protected static class Replacement {
        private static final AtomicLong ORDER_SEQUENCE = new AtomicLong();
        private final int m_offset;
        private final int m_length;
        private CharSequence m_newSource;
        private final long m_order;

        public Replacement(int offset, int length, CharSequence newSource) {
            this.m_offset = offset;
            this.m_length = length;
            this.m_newSource = newSource;
            this.m_order = ORDER_SEQUENCE.incrementAndGet();
        }

        public int offset() {
            return this.m_offset;
        }

        public int length() {
            return this.m_length;
        }

        public long order() {
            return this.m_order;
        }

        public CharSequence newSource() {
            return this.m_newSource;
        }

        public void setNewSource(CharSequence src) {
            this.m_newSource = src;
        }
    }
}

