/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.maven;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.scout.sdk.core.java.apidef.ApiVersion;
import org.eclipse.scout.sdk.core.java.model.api.IClasspathEntry;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.util.maven.Pom;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MavenArtifactVersions {
    private static final Map<Path, Optional<ApiVersion>> VERSION_CACHE = new ConcurrentHashMap<Path, Optional<ApiVersion>>();

    private MavenArtifactVersions() {
    }

    public static Optional<ApiVersion> usedIn(String artifactId, IJavaEnvironment context) {
        return MavenArtifactVersions.modulePathIn(artifactId, context).flatMap(MavenArtifactVersions::version);
    }

    public static Stream<String> allOnCentral(String groupId, String artifactId) throws IOException {
        try {
            String g = URLEncoder.encode(groupId, StandardCharsets.UTF_8);
            String a = URLEncoder.encode(artifactId, StandardCharsets.UTF_8);
            URI uri = new URI("https://search.maven.org/solrsearch/select?q=g:" + g + "+AND+a:" + a + "&core=gav&rows=100&wt=xml");
            Document dom = Xml.get((URI)uri);
            return Xml.evaluateXPath((String)"result/doc/str[@name='v']", (Node)dom.getDocumentElement()).stream().map(Node::getTextContent).filter(Strings::hasText);
        }
        catch (URISyntaxException | XPathExpressionException e) {
            throw new IOException(e);
        }
    }

    static Optional<Path> modulePathIn(String moduleName, IJavaEnvironment context) {
        if (context == null || Strings.isBlank((CharSequence)moduleName)) {
            return Optional.empty();
        }
        Optional<Path> jarPath = context.classpath().filter(p -> MavenArtifactVersions.isModuleJar(moduleName, p)).map(IClasspathEntry::path).findAny();
        if (jarPath.isPresent()) {
            return jarPath;
        }
        return context.classpath().filter(p -> MavenArtifactVersions.isModuleSourceFolder(moduleName, p)).map(IClasspathEntry::path).findAny();
    }

    static Optional<ApiVersion> version(Path pathToModule) {
        return VERSION_CACHE.computeIfAbsent(pathToModule, MavenArtifactVersions::detectVersion);
    }

    static Optional<ApiVersion> detectVersion(Path pathToModule) {
        if (Files.isRegularFile(pathToModule, new LinkOption[0])) {
            return MavenArtifactVersions.versionOfJar(pathToModule);
        }
        return MavenArtifactVersions.versionOfSourceFolder(pathToModule);
    }

    static Optional<ApiVersion> versionOfSourceFolder(Path sourceFolder) {
        Path mainFolder = sourceFolder.getParent();
        if (mainFolder == null) {
            return Optional.empty();
        }
        Path srcFolder = mainFolder.getParent();
        if (srcFolder == null) {
            return Optional.empty();
        }
        Path modulePath = srcFolder.getParent();
        if (modulePath == null) {
            return Optional.empty();
        }
        try {
            Document pomContent = Xml.get((Path)modulePath.resolve("pom.xml"));
            return Pom.version(pomContent).flatMap(ApiVersion::parse);
        }
        catch (IOException e) {
            throw new SdkException((CharSequence)"Error parsing version of source folder '{}'.", new Object[]{sourceFolder, e});
        }
    }

    static Optional<ApiVersion> versionOfJar(Path jar) {
        Optional<ApiVersion> optional;
        JarFile f = new JarFile(jar.toFile(), false, 1);
        try {
            optional = Optional.ofNullable(f.getManifest()).map(mf -> mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION.toString())).flatMap(ApiVersion::parse);
        }
        catch (Throwable throwable) {
            try {
                try {
                    f.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SdkException((CharSequence)"Error parsing version of jar '{}'.", new Object[]{jar, e});
            }
        }
        f.close();
        return optional;
    }

    static boolean isModuleSourceFolder(String moduleName, IClasspathEntry entry) {
        if (!entry.isDirectory()) {
            return false;
        }
        return entry.path().endsWith(moduleName + "/src/main/java");
    }

    static boolean isModuleJar(String moduleName, IClasspathEntry entry) {
        if (entry.isDirectory()) {
            return false;
        }
        Path lastSegment = entry.path().getFileName();
        if (lastSegment == null) {
            return false;
        }
        String fileName = lastSegment.toString();
        return Strings.endsWith((CharSequence)fileName, (CharSequence)".jar", (boolean)false) && Strings.startsWith((String)fileName, (String)(moduleName + "-")) && !Strings.endsWith((CharSequence)fileName, (CharSequence)"-sources.jar", (boolean)false) && !Strings.endsWith((CharSequence)fileName, (CharSequence)"-javadoc.jar", (boolean)false);
    }
}

