/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IExpression;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.ast.IObjectLiteralField;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ObjectLiteralField
extends Expression
implements IObjectLiteralField {
    public Expression fieldName;
    public Expression initializer;
    public Javadoc javaDoc;

    public ObjectLiteralField(Expression field, Expression value, int start, int end) {
        this.fieldName = field;
        this.initializer = value;
        this.sourceEnd = end;
        this.sourceStart = start;
    }

    @Override
    public IExpression getFieldName() {
        return this.fieldName;
    }

    @Override
    public IExpression getInitializer() {
        return this.initializer;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.javaDoc != null) {
            this.javaDoc.print(indent, output);
        }
        this.fieldName.printExpression(indent, output);
        output.append(" : ");
        this.initializer.printExpression(indent, output);
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.javaDoc != null) {
                this.javaDoc.traverse(visitor, scope);
            }
            if (this.fieldName != null) {
                this.fieldName.traverse(visitor, scope);
            }
            if (this.initializer != null) {
                this.initializer.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        return this.initializer.resolveType(scope);
    }

    @Override
    public FlowInfo analyseCode(BlockScope classScope, FlowContext initializationContext, FlowInfo flowInfo) {
        flowInfo = this.initializer.analyseCode(classScope, initializationContext, flowInfo);
        return flowInfo;
    }

    @Override
    public int getASTType() {
        return 77;
    }

    @Override
    public IJsDoc getJsDoc() {
        return this.javaDoc;
    }
}

