/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class VarCheck
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final DiagnosticType UNDEFINED_VAR_ERROR = DiagnosticType.error("JSC_UNDEFINED_VARIABLE", "variable {0} is undeclared");
    static final DiagnosticType VIOLATED_MODULE_DEP_ERROR = DiagnosticType.error("JSC_VIOLATED_MODULE_DEPENDENCY", "module {0} cannot reference {2}, defined in module {1}, since {1} loads after {0}");
    static final DiagnosticType MISSING_MODULE_DEP_ERROR = DiagnosticType.warning("JSC_MISSING_MODULE_DEPENDENCY", "missing module dependency; module {0} should depend on module {1} because it references {2}");
    static final DiagnosticType STRICT_MODULE_DEP_ERROR = DiagnosticType.disabled("JSC_STRICT_MODULE_DEPENDENCY", "cannot reference {2} because of a missing module dependency\ndefined in module {1}, referenced from module {0}");
    static final DiagnosticType NAME_REFERENCE_IN_EXTERNS_ERROR = DiagnosticType.warning("JSC_NAME_REFERENCE_IN_EXTERNS", "accessing name {0} in externs has no effect. Perhaps you forgot to add a var keyword?");
    static final DiagnosticType UNDEFINED_EXTERN_VAR_ERROR = DiagnosticType.warning("JSC_UNDEFINED_EXTERN_VAR_ERROR", "name {0} is not defined in the externs.");
    static final DiagnosticType VAR_MULTIPLY_DECLARED_ERROR = DiagnosticType.error("JSC_VAR_MULTIPLY_DECLARED_ERROR", "Variable {0} first declared in {1}");
    static final DiagnosticType VAR_ARGUMENTS_SHADOWED_ERROR = DiagnosticType.error("JSC_VAR_ARGUMENTS_SHADOWED_ERROR", "Shadowing \"arguments\" is not allowed");
    static final DiagnosticType LET_CONST_MULTIPLY_DECLARED_ERROR = DiagnosticType.error("JSC_LET_CONST_MULTIPLY_DECLARED_ERROR", "Duplicate let / const declaration in the same scope is not allowed.");
    private static final String ARGUMENTS = "arguments";
    private final Set<String> varsToDeclareInExterns = new HashSet<String>();
    private final AbstractCompiler compiler;
    private final boolean sanityCheck;
    private final boolean strictExternCheck;

    VarCheck(AbstractCompiler compiler) {
        this(compiler, false);
    }

    VarCheck(AbstractCompiler compiler, boolean sanityCheck) {
        this.compiler = compiler;
        this.strictExternCheck = compiler.getErrorLevel(JSError.make("", 0, 0, UNDEFINED_EXTERN_VAR_ERROR, new String[0])) == CheckLevel.ERROR;
        this.sanityCheck = sanityCheck;
    }

    private ScopeCreator createScopeCreator() {
        if (this.sanityCheck) {
            return new Es6SyntacticScopeCreator(this.compiler);
        }
        return new Es6SyntacticScopeCreator(this.compiler, new RedeclarationCheckHandler());
    }

    @Override
    public void process(Node externs, Node root) {
        ScopeCreator scopeCreator = this.createScopeCreator();
        if (!this.sanityCheck) {
            NodeTraversal traversal = new NodeTraversal(this.compiler, new NameRefInExternsCheck(), scopeCreator);
            traversal.traverse(externs);
        }
        NodeTraversal t = new NodeTraversal(this.compiler, this, scopeCreator);
        t.traverseRoots(externs, root);
        for (String varName : this.varsToDeclareInExterns) {
            this.createSynthesizedExternVar(varName);
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        Preconditions.checkState((boolean)scriptRoot.isScript());
        ScopeCreator scopeCreator = this.createScopeCreator();
        NodeTraversal t = new NodeTraversal(this.compiler, this, scopeCreator);
        Scope topScope = scopeCreator.createScope(this.compiler.getRoot(), null);
        t.traverseWithScope(scriptRoot, topScope);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isName() || n.isStringKey() && !n.hasChildren()) {
            CompilerInput varInput;
            Scope scope;
            Var var;
            String varName = n.getString();
            if (varName.isEmpty()) {
                Preconditions.checkState((boolean)parent.isFunction());
                Preconditions.checkState((boolean)NodeUtil.isFunctionExpression(parent));
                return;
            }
            if ((parent.isVar() || NodeUtil.isFunctionDeclaration(parent)) && this.varsToDeclareInExterns.contains(varName)) {
                this.createSynthesizedExternVar(varName);
                JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(n.getJSDocInfo());
                builder.addSuppression("duplicate");
                n.setJSDocInfo(builder.build());
            }
            if ((var = (scope = t.getScope()).getVar(varName)) == null) {
                if (!(NodeUtil.isFunctionExpression(parent) || NodeUtil.isClassExpression(parent) && n == parent.getFirstChild())) {
                    boolean isArguments;
                    boolean bl = isArguments = scope.isLocal() && ARGUMENTS.equals(varName);
                    if (!(isArguments || this.strictExternCheck && t.getInput().isExtern())) {
                        t.report(n, UNDEFINED_VAR_ERROR, varName);
                    }
                    if (this.sanityCheck) {
                        throw new IllegalStateException("Unexpected variable " + varName);
                    }
                    this.createSynthesizedExternVar(varName);
                    scope.getGlobalScope().declare(varName, n, this.compiler.getSynthesizedExternsInput());
                }
                return;
            }
            CompilerInput currInput = t.getInput();
            if (currInput == (varInput = var.input) || currInput == null || varInput == null) {
                return;
            }
            JSModule currModule = currInput.getModule();
            JSModule varModule = varInput.getModule();
            JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
            if (!this.sanityCheck && varModule != currModule && varModule != null && currModule != null && !moduleGraph.dependsOn(currModule, varModule)) {
                if (scope.isGlobal()) {
                    if (moduleGraph.dependsOn(varModule, currModule)) {
                        t.report(n, VIOLATED_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                    } else {
                        t.report(n, MISSING_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                    }
                } else {
                    t.report(n, STRICT_MODULE_DEP_ERROR, currModule.getName(), varModule.getName(), varName);
                }
            }
        }
    }

    private void createSynthesizedExternVar(String varName) {
        Node nameNode = IR.name(varName);
        if (this.compiler.getCodingConvention().isConstant(varName)) {
            nameNode.putBooleanProp(43, true);
        }
        this.getSynthesizedExternsRoot().addChildToBack(IR.var(nameNode));
        this.varsToDeclareInExterns.remove(varName);
        this.compiler.reportCodeChange();
    }

    static boolean hasDuplicateDeclarationSuppression(Node n, Var origVar) {
        Preconditions.checkState((n.isName() || n.isRest() || n.isStringKey() ? 1 : 0) != 0, (Object)n);
        Node parent = n.getParent();
        Node origParent = origVar.getParentNode();
        if (VarCheck.isExternNamespace(n)) {
            return true;
        }
        JSDocInfo info = parent.getJSDocInfo();
        if (info != null && info.getSuppressions().contains("duplicate")) {
            return true;
        }
        info = origParent.getJSDocInfo();
        return info != null && info.getSuppressions().contains("duplicate");
    }

    private static boolean isExternNamespace(Node n) {
        return n.getParent().isVar() && n.isFromExterns() && NodeUtil.isNamespaceDecl(n);
    }

    private Node getSynthesizedExternsRoot() {
        return this.compiler.getSynthesizedExternsInput().getAstRoot(this.compiler);
    }

    private class NameRefInExternsCheck
    extends NodeTraversal.AbstractPostOrderCallback {
        private NameRefInExternsCheck() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isName()) {
                switch (parent.getType()) {
                    case 83: 
                    case 105: 
                    case 118: 
                    case 149: 
                    case 158: 
                    case 162: {
                        break;
                    }
                    case 33: {
                        Scope scope;
                        Var var;
                        if (n != parent.getFirstChild() || (var = (scope = t.getScope()).getVar(n.getString())) != null) break;
                        t.report(n, UNDEFINED_EXTERN_VAR_ERROR, n.getString());
                        VarCheck.this.varsToDeclareInExterns.add(n.getString());
                        break;
                    }
                    case 86: {
                        if (n == parent.getLastChild() && n.isQualifiedName() && parent.getFirstChild().isQualifiedName()) break;
                    }
                    default: {
                        Scope scope;
                        Var var;
                        if (!parent.isName() || parent.getParent() == null || !NodeUtil.isNameDeclaration(parent.getParent())) {
                            t.report(n, NAME_REFERENCE_IN_EXTERNS_ERROR, n.getString());
                        }
                        if ((var = (scope = t.getScope()).getVar(n.getString())) != null) break;
                        VarCheck.this.varsToDeclareInExterns.add(n.getString());
                    }
                }
            }
        }
    }

    private class RedeclarationCheckHandler
    implements SyntacticScopeCreator.RedeclarationHandler {
        private RedeclarationCheckHandler() {
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            Node parent = n.getParent();
            if (s.isGlobal()) {
                Var origVar = s.getVar(name);
                Node origParent = origVar.getParentNode();
                if (origParent.isCatch() && parent.isCatch()) {
                    return;
                }
                if (parent.isLet() || parent.isConst() || origParent.isLet() || origParent.isConst()) {
                    VarCheck.this.compiler.report(JSError.make(n, LET_CONST_MULTIPLY_DECLARED_ERROR, new String[0]));
                    return;
                }
                boolean allowDupe = VarCheck.hasDuplicateDeclarationSuppression(n, origVar);
                if (VarCheck.isExternNamespace(n)) {
                    parent.getParent().removeChild(parent);
                    VarCheck.this.compiler.reportCodeChange();
                    return;
                }
                if (!allowDupe) {
                    VarCheck.this.compiler.report(JSError.make(n, VAR_MULTIPLY_DECLARED_ERROR, name, origVar.input != null ? origVar.input.getName() : "??"));
                }
            } else if (name.equals(VarCheck.ARGUMENTS) && !NodeUtil.isVarDeclaration(n)) {
                VarCheck.this.compiler.report(JSError.make(n, VAR_ARGUMENTS_SHADOWED_ERROR, new String[0]));
            }
        }
    }
}

