/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.refactoring.ErrorToFixMapper;
import com.google.javascript.refactoring.SuggestedFix;
import java.util.Collection;
import java.util.List;

public class FixingErrorManager
extends BasicErrorManager {
    private AbstractCompiler compiler;
    private final ListMultimap<JSError, SuggestedFix> fixes = ArrayListMultimap.create();

    public void setCompiler(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void report(CheckLevel level, JSError error) {
        super.report(level, error);
        this.fixes.putAll((Object)error, ErrorToFixMapper.getFixesForJsError(error, this.compiler));
    }

    public List<SuggestedFix> getFixesForJsError(JSError error) {
        return this.fixes.get((Object)error);
    }

    public Collection<SuggestedFix> getAllFixes() {
        return this.fixes.values();
    }

    @Override
    public void printSummary() {
    }

    @Override
    public void println(CheckLevel level, JSError error) {
    }
}

