/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.collection.internal;

import java.util.List;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.collection.CollectResult;
import org.apache.maven.shared.transfer.collection.DependencyCollectionException;
import org.apache.maven.shared.transfer.collection.DependencyCollector;
import org.apache.maven.shared.transfer.collection.internal.Invoker;
import org.apache.maven.shared.transfer.collection.internal.Maven30DependencyCollector;
import org.apache.maven.shared.transfer.collection.internal.Maven31DependencyCollector;
import org.apache.maven.shared.transfer.collection.internal.MavenDependencyCollector;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;

@Component(role=DependencyCollector.class, hint="default")
class DefaultDependencyCollector
implements DependencyCollector,
Contextualizable {
    private PlexusContainer container;

    DefaultDependencyCollector() {
    }

    @Override
    public CollectResult collectDependencies(ProjectBuildingRequest buildingRequest, Dependency root) throws DependencyCollectionException {
        this.validateParameters(buildingRequest, root);
        try {
            return this.getMavenDependencyCollector(buildingRequest).collectDependencies(root);
        }
        catch (ComponentLookupException e) {
            throw new DependencyCollectionException(e.getMessage(), e);
        }
    }

    @Override
    public CollectResult collectDependencies(ProjectBuildingRequest buildingRequest, DependableCoordinate root) throws DependencyCollectionException {
        this.validateParameters(buildingRequest, root);
        try {
            return this.getMavenDependencyCollector(buildingRequest).collectDependencies(root);
        }
        catch (ComponentLookupException e) {
            throw new DependencyCollectionException(e.getMessage(), e);
        }
    }

    @Override
    public CollectResult collectDependencies(ProjectBuildingRequest buildingRequest, Model root) throws DependencyCollectionException {
        this.validateParameters(buildingRequest, root);
        try {
            return this.getMavenDependencyCollector(buildingRequest).collectDependencies(root);
        }
        catch (ComponentLookupException e) {
            throw new DependencyCollectionException(e.getMessage(), e);
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, DependableCoordinate root) {
        this.validateBuildingRequestAndRoot(buildingRequest, root);
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, Dependency root) {
        this.validateBuildingRequestAndRoot(buildingRequest, root);
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, Model root) {
        this.validateBuildingRequestAndRoot(buildingRequest, root);
    }

    private void validateBuildingRequestAndRoot(ProjectBuildingRequest buildingRequest, Object root) {
        this.validateBuildingRequest(buildingRequest);
        this.validateRoot(root);
    }

    private void validateBuildingRequest(ProjectBuildingRequest buildingRequest) {
        Objects.requireNonNull(buildingRequest, "The parameter buildingRequest is not allowed to be null.");
    }

    private void validateRoot(Object root) {
        Objects.requireNonNull(root, "The parameter root is not allowed to be null.");
    }

    private boolean isMaven31() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.aether.artifact.Artifact");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private MavenDependencyCollector getMavenDependencyCollector(ProjectBuildingRequest buildingRequest) throws ComponentLookupException, DependencyCollectionException {
        ArtifactHandlerManager artifactHandlerManager = (ArtifactHandlerManager)this.container.lookup(ArtifactHandlerManager.class);
        if (this.isMaven31()) {
            org.eclipse.aether.RepositorySystem m31RepositorySystem = (org.eclipse.aether.RepositorySystem)this.container.lookup(org.eclipse.aether.RepositorySystem.class);
            org.eclipse.aether.RepositorySystemSession session = (org.eclipse.aether.RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
            List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
            return new Maven31DependencyCollector(m31RepositorySystem, artifactHandlerManager, session, aetherRepositories);
        }
        RepositorySystem m30RepositorySystem = (RepositorySystem)this.container.lookup(RepositorySystem.class);
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
        return new Maven30DependencyCollector(m30RepositorySystem, artifactHandlerManager, session, aetherRepositories);
    }
}

