/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinaryTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTBinaryTypeIdExpression
extends ASTNode
implements ICPPASTExpression,
IASTBinaryTypeIdExpression {
    private IASTBinaryTypeIdExpression.Operator fOperator;
    private IASTTypeId fOperand1;
    private IASTTypeId fOperand2;
    private ICPPEvaluation fEvaluation;

    public CPPASTBinaryTypeIdExpression() {
    }

    public CPPASTBinaryTypeIdExpression(IASTBinaryTypeIdExpression.Operator op, IASTTypeId typeId1, IASTTypeId typeId2) {
        this.fOperator = op;
        this.setOperand1(typeId1);
        this.setOperand2(typeId2);
    }

    @Override
    public CPPASTBinaryTypeIdExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTBinaryTypeIdExpression copy(IASTNode.CopyStyle style) {
        CPPASTBinaryTypeIdExpression copy = new CPPASTBinaryTypeIdExpression(this.fOperator, this.fOperand1 == null ? null : this.fOperand1.copy(style), this.fOperand2 == null ? null : this.fOperand2.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTBinaryTypeIdExpression.Operator getOperator() {
        return this.fOperator;
    }

    @Override
    public void setOperator(IASTBinaryTypeIdExpression.Operator value) {
        this.assertNotFrozen();
        this.fOperator = value;
    }

    @Override
    public void setOperand1(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.fOperand1 = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(OPERAND1);
        }
    }

    @Override
    public void setOperand2(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.fOperand2 = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(OPERAND2);
        }
    }

    @Override
    public IASTTypeId getOperand1() {
        return this.fOperand1;
    }

    @Override
    public IASTTypeId getOperand2() {
        return this.fOperand2;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fOperand1 != null && !this.fOperand1.accept(action)) {
            return false;
        }
        if (this.fOperand2 != null && !this.fOperand2.accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            if (this.fOperand1 == null || this.fOperand2 == null) {
                this.fEvaluation = EvalFixed.INCOMPLETE;
            } else {
                IType t1 = CPPVisitor.createType(this.fOperand1);
                IType t2 = CPPVisitor.createType(this.fOperand2);
                this.fEvaluation = t1 == null || t2 == null ? EvalFixed.INCOMPLETE : new EvalBinaryTypeId(this.fOperator, t1, t2, this);
            }
        }
        return this.fEvaluation;
    }

    @Override
    public IType getExpressionType() {
        return CPPEvaluation.getType(this);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        return IASTImplicitDestructorName.EMPTY_NAME_ARRAY;
    }
}

