/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.util.List;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.util.Timeout;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsAuthenticationStrategy;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.CacheCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientCustomizer;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientTransport;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpServiceContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SynchronizedCredentialsProvider;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.SystemCredentialsProvider;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(name="org.eclipse.epp.mpc.core.http.client.factory", service={HttpClientFactory.class})
public class HttpClientFactory {
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.STATIC, fieldOption=FieldOption.REPLACE)
    private List<HttpClientCustomizer> customizers;

    public List<HttpClientCustomizer> getCustomizers() {
        return this.customizers;
    }

    public void setCustomizers(List<HttpClientCustomizer> customizers) {
        this.customizers = customizers;
    }

    public HttpServiceContext build() {
        return this.build(null);
    }

    public HttpServiceContext build(HttpServiceContext oldContext) {
        CredentialsStore credentialsProvider;
        CredentialsStore initialCredentialsProvider;
        CredentialsStore cacheProvider;
        CookieStore cookieStore;
        HttpClientBuilder clientBuilder = this.builder();
        CookieStore cookieStore2 = cookieStore = oldContext == null ? null : oldContext.getCookieStore();
        if (cookieStore == null) {
            cookieStore = this.createCookieStore();
        }
        CredentialsStore credentialsStore = cacheProvider = oldContext == null ? null : oldContext.getCredentialsCacheProvider();
        if (cacheProvider == null) {
            cacheProvider = this.createCredentialsCacheProvider();
        }
        CredentialsStore credentialsStore2 = initialCredentialsProvider = oldContext == null ? null : oldContext.getInitialCredentialsProvider();
        if (initialCredentialsProvider == null) {
            initialCredentialsProvider = this.createCredentialsProvider();
        }
        if ((credentialsProvider = initialCredentialsProvider) != null) {
            credentialsProvider = this.customizeCredentialsProvider(clientBuilder, credentialsProvider, cacheProvider);
        }
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        clientBuilder.setDefaultCookieStore(cookieStore);
        clientBuilder = this.customizeBuilder(clientBuilder);
        return new HttpServiceContext(clientBuilder.build(), cookieStore, credentialsProvider, initialCredentialsProvider, cacheProvider);
    }

    protected CredentialsStore createCredentialsProvider() {
        return new SystemCredentialsProvider();
    }

    protected CredentialsStore createCredentialsCacheProvider() {
        return new CacheCredentialsProvider();
    }

    protected CookieStore createCookieStore() {
        return new BasicCookieStore();
    }

    private CredentialsStore customizeCredentialsProvider(HttpClientBuilder clientBuilder, CredentialsStore credentialsProvider, CredentialsStore cacheProvider) {
        credentialsProvider = this.customizeCredentialsProvider(credentialsProvider);
        if (cacheProvider != null) {
            credentialsProvider = new ChainedCredentialsProvider(cacheProvider, credentialsProvider);
            clientBuilder.addRequestInterceptorFirst((request, entityDetails, context) -> {
                Object object = context.setAttribute(CacheCredentialsAuthenticationStrategy.CREDENTIALS_CACHE_ATTRIBUTE, (Object)cacheProvider);
            });
        }
        credentialsProvider = new SynchronizedCredentialsProvider(credentialsProvider);
        return credentialsProvider;
    }

    protected HttpClientBuilder builder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultMaxPerRoute(100);
        connManager.setMaxTotal(200);
        builder.setConnectionManager((HttpClientConnectionManager)connManager);
        HttpClientFactory.setClientDefaultTimeouts(builder);
        builder.addResponseInterceptorLast((HttpResponseInterceptor)new CacheCredentialsAuthenticationStrategy());
        builder.setUserAgent(HttpClientTransport.USER_AGENT);
        return builder;
    }

    private static void setClientDefaultTimeouts(HttpClientBuilder builder) {
        int connectTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.CONNECT_TIMEOUT_PROPERTY, HttpClientTransport.DEFAULT_CONNECT_TIMEOUT);
        int readTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.READ_TIMEOUT_PROPERTY, HttpClientTransport.DEFAULT_READ_TIMEOUT);
        int connectionRequestTimeout = HttpClientFactory.getTimeoutValue(HttpClientTransport.CONNECTION_REQUEST_TIMEOUT_PROPERTY, HttpClientTransport.DEFAULT_CONNECTION_REQUEST_TIMEOUT);
        SocketConfig defaultSocketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT).setSoTimeout(Timeout.ofMilliseconds((long)readTimeout)).setTcpNoDelay(true).build();
        RequestConfig defaultRequestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setResponseTimeout(Timeout.ofMilliseconds((long)readTimeout)).setConnectTimeout(Timeout.ofMilliseconds((long)connectTimeout)).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)connectionRequestTimeout)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setDefaultSocketConfig(defaultSocketConfig);
        builder.setConnectionManager((HttpClientConnectionManager)connManager);
        builder.setDefaultRequestConfig(defaultRequestConfig);
    }

    private static int getTimeoutValue(String property, int defaultValue) {
        String propertyValue = FrameworkUtil.getBundle(HttpClientTransport.class).getBundleContext().getProperty(property);
        if (propertyValue == null || "".equals(propertyValue)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    protected HttpClientBuilder customizeBuilder(HttpClientBuilder builder) {
        HttpClientBuilder customBuilder = builder;
        for (HttpClientCustomizer customizer : this.customizers) {
            customBuilder = HttpClientFactory.customizeBuilder(customizer, customBuilder);
        }
        return customBuilder;
    }

    private static HttpClientBuilder customizeBuilder(HttpClientCustomizer customizer, HttpClientBuilder builder) {
        if (customizer == null) {
            return builder;
        }
        HttpClientBuilder customBuilder = customizer.customizeBuilder(builder);
        return customBuilder == null ? builder : customBuilder;
    }

    private CredentialsStore customizeCredentialsProvider(CredentialsStore credentialsProvider) {
        CredentialsStore customizedCredentialsProvider = credentialsProvider;
        for (HttpClientCustomizer customizer : this.customizers) {
            customizedCredentialsProvider = HttpClientFactory.customizeCredentialsProvider(customizer, customizedCredentialsProvider);
        }
        return customizedCredentialsProvider;
    }

    private static CredentialsStore customizeCredentialsProvider(HttpClientCustomizer customizer, CredentialsStore credentialsProvider) {
        if (customizer == null) {
            return credentialsProvider;
        }
        CredentialsStore customCredentialsProvider = customizer.customizeCredentialsProvider(credentialsProvider);
        return customCredentialsProvider == null ? credentialsProvider : customCredentialsProvider;
    }
}

