/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.ui.internal;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.cmake.core.properties.CMakeGenerator;
import org.eclipse.cdt.cmake.ui.internal.Messages;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.launch.ui.corebuild.CommonBuildTab;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CMakeBuildTab
extends CommonBuildTab {
    private static final String[] buildTypes = new String[]{"Debug", "Release", "RelWithDebInfo", "MinSizeRel"};
    private Button useDefaultCmakeSettings;
    private Combo generatorCombo;
    private Text cmakeArgsText;
    private Text buildCommandText;
    private Text allTargetText;
    private Text cleanTargetText;
    private Label generatorLabel;
    private Label cmakeArgsLabel;
    private Label buildCommandLabel;
    private Label allTargetLabel;
    private Label cleanTargetLabel;
    private Combo buildTypeCombo;
    private Label buildTypeLabel;
    private Label usedForLaunchModeLabel;

    protected String getBuildConfigProviderId() {
        return "org.eclipse.cdt.cmake.core.provider";
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        this.setControl((Control)comp);
        Control tcControl = this.createToolchainSelector(comp);
        tcControl.setLayoutData((Object)new GridData(4, 4, true, false));
        Group cmakeGroup = new Group(comp, 0);
        cmakeGroup.setText(Messages.CMakeBuildTab_Settings);
        cmakeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        cmakeGroup.setLayout((Layout)new GridLayout());
        this.useDefaultCmakeSettings = new Button((Composite)cmakeGroup, 32);
        this.useDefaultCmakeSettings.setText(Messages.CMakeBuildTab_useDefaultCmakeSettings);
        this.useDefaultCmakeSettings.setToolTipText(Messages.CMakeBuildTab_useDefaultCmakeSettingsTip);
        this.useDefaultCmakeSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab.this.showDefaultsInUi();
                CMakeBuildTab.this.updateEnablement();
                CMakeBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.generatorLabel = new Label((Composite)cmakeGroup, 0);
        this.generatorLabel.setText(Messages.CMakeBuildTab_Generator);
        CMakeGenerator[] generators = CMakeGenerator.values();
        String[] generatorNames = (String[])Arrays.stream(generators).map(CMakeGenerator::getCMakeName).toArray(String[]::new);
        this.generatorCombo = new Combo((Composite)cmakeGroup, 4);
        this.generatorCombo.setItems(generatorNames);
        this.generatorCombo.select(0);
        this.generatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.cmakeArgsLabel = new Label((Composite)cmakeGroup, 0);
        this.cmakeArgsLabel.setText(Messages.CMakeBuildTab_CMakeArgs);
        this.cmakeArgsText = new Text((Composite)cmakeGroup, 2048);
        this.cmakeArgsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cmakeArgsText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        this.buildCommandLabel = new Label((Composite)cmakeGroup, 0);
        this.buildCommandLabel.setText(Messages.CMakeBuildTab_BuildCommand);
        this.buildCommandText = new Text((Composite)cmakeGroup, 2048);
        this.buildCommandText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buildCommandText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        this.allTargetLabel = new Label((Composite)cmakeGroup, 0);
        this.allTargetLabel.setText(Messages.CMakeBuildTab_AllTarget);
        this.allTargetText = new Text((Composite)cmakeGroup, 2048);
        this.allTargetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.allTargetText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        this.cleanTargetLabel = new Label((Composite)cmakeGroup, 0);
        this.cleanTargetLabel.setText(Messages.CMakeBuildTab_CleanTarget);
        this.cleanTargetText = new Text((Composite)cmakeGroup, 2048);
        this.cleanTargetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cleanTargetText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
        Composite buildTypeComp = new Composite((Composite)cmakeGroup, 0);
        buildTypeComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buildTypeComp.setLayout((Layout)new GridLayout(3, false));
        this.buildTypeLabel = new Label(buildTypeComp, 0);
        this.buildTypeLabel.setText(Messages.CMakeBuildTab_BuildType);
        this.buildTypeLabel.setToolTipText(Messages.CMakeBuildTab_BuildType_Tooltip);
        this.buildTypeCombo = new Combo(buildTypeComp, 4);
        this.buildTypeCombo.setItems(buildTypes);
        this.buildTypeCombo.setToolTipText(Messages.CMakeBuildTab_BuildTypeCombo_Tooltip);
        this.buildTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CMakeBuildTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.usedForLaunchModeLabel = new Label(buildTypeComp, 0);
    }

    private void showDefaultsInUi() {
        if (this.useDefaultCmakeSettings.getSelection()) {
            this.restoreProperties(this.getBuildConfiguration().getDefaultProperties());
        }
    }

    private void updateEnablement() {
        boolean isDefaultCMakeProperties = this.useDefaultCmakeSettings.getSelection();
        boolean enabled = !isDefaultCMakeProperties;
        this.generatorLabel.setEnabled(enabled);
        this.generatorCombo.setEnabled(enabled);
        this.cmakeArgsLabel.setEnabled(enabled);
        this.cmakeArgsText.setEnabled(enabled);
        this.buildCommandLabel.setEnabled(enabled);
        this.buildCommandText.setEnabled(enabled);
        this.allTargetLabel.setEnabled(enabled);
        this.allTargetText.setEnabled(enabled);
        this.cleanTargetLabel.setEnabled(enabled);
        this.cleanTargetText.setEnabled(enabled);
        this.buildTypeLabel.setEnabled(enabled);
        this.buildTypeCombo.setEnabled(enabled);
        this.usedForLaunchModeLabel.setEnabled(enabled);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        buildConfig.setProperty("cmake.use.default.cmake.settings", "true");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        boolean isDefaultCMakeProperties = Boolean.valueOf(buildConfig.getProperty("cmake.use.default.cmake.settings"));
        this.useDefaultCmakeSettings.setSelection(isDefaultCMakeProperties);
        if (isDefaultCMakeProperties) {
            this.restoreProperties(buildConfig.getDefaultProperties());
        } else {
            this.restoreProperties(buildConfig.getProperties());
        }
        this.updateEnablement();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        ICBuildConfiguration buildConfig = this.getBuildConfiguration();
        String generator = this.generatorCombo.getText().trim();
        buildConfig.setProperty("cmake.generator", generator);
        String cmakeArgs = this.cmakeArgsText.getText().trim();
        if (!cmakeArgs.isEmpty()) {
            buildConfig.setProperty("cmake.arguments", cmakeArgs);
        } else {
            buildConfig.removeProperty("cmake.arguments");
        }
        String buildCommand = this.buildCommandText.getText().trim();
        if (!buildCommand.isEmpty()) {
            buildConfig.setProperty("cmake.command.build", buildCommand);
        } else {
            buildConfig.removeProperty("cmake.command.build");
        }
        String allTarget = this.allTargetText.getText().trim();
        if (!allTarget.isEmpty()) {
            buildConfig.setProperty("cmake.target.all", allTarget);
        } else {
            buildConfig.removeProperty("cmake.target.all");
        }
        String cleanTarget = this.cleanTargetText.getText().trim();
        if (!cleanTarget.isEmpty()) {
            buildConfig.setProperty("cmake.target.clean", cleanTarget);
        } else {
            buildConfig.removeProperty("cmake.target.clean");
        }
        boolean isDefaultCMakeProperties = this.useDefaultCmakeSettings.getSelection();
        buildConfig.setProperty("cmake.use.default.cmake.settings", Boolean.toString(isDefaultCMakeProperties));
        String buildType = this.buildTypeCombo.getText().trim();
        if (!buildType.isBlank() && !isDefaultCMakeProperties) {
            buildConfig.setProperty("cmake.build.type", buildType);
        } else {
            buildConfig.removeProperty("cmake.build.type");
        }
    }

    protected void saveProperties(Map<String, String> properties) {
        super.saveProperties(properties);
        properties.put("cmake.generator", this.generatorCombo.getText().trim());
        properties.put("cmake.arguments", this.cmakeArgsText.getText().trim());
        properties.put("cmake.command.build", this.buildCommandText.getText().trim());
        properties.put("cmake.target.all", this.allTargetText.getText().trim());
        properties.put("cmake.target.clean", this.cleanTargetText.getText().trim());
        properties.put("cmake.build.type", this.buildTypeCombo.getText().trim());
    }

    protected void restoreProperties(Map<String, String> properties) {
        super.restoreProperties(properties);
        String gen = properties.getOrDefault("cmake.generator", "Ninja");
        this.generatorCombo.setText(gen);
        String cmakeArgs = properties.getOrDefault("cmake.arguments", "");
        this.cmakeArgsText.setText(cmakeArgs);
        String buildCmd = properties.getOrDefault("cmake.command.build", "cmake");
        this.buildCommandText.setText(buildCmd);
        String allTarget = properties.getOrDefault("cmake.target.all", "all");
        this.allTargetText.setText(allTarget);
        String cleanTarget = properties.getOrDefault("cmake.target.clean", "clean");
        this.cleanTargetText.setText(cleanTarget);
        String defaultBuildType = this.getDefaultBuildType();
        String buildType = properties.getOrDefault("cmake.build.type", defaultBuildType);
        this.buildTypeCombo.setText(buildType);
        ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.getBuildConfiguration().getLaunchMode());
        String launchModeLabel = launchMode != null ? launchMode.getLabel() : this.getBuildConfiguration().getLaunchMode();
        this.usedForLaunchModeLabel.setText(MessageFormat.format(Messages.CMakeBuildTab_UsedForLaunchMode, launchModeLabel));
    }

    public String getName() {
        return Messages.CMakeBuildTab_Cmake;
    }

    private String getDefaultBuildType() {
        return "debug".equals(this.getBuildConfiguration().getLaunchMode()) ? buildTypes[0] : buildTypes[1];
    }
}

