/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.tld;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class LoadBundleUtil {
    private LoadBundleUtil() {
    }

    public static IStorage getLoadBundleResource(IProject project, String baseName) throws CoreException {
        if (project == null || baseName == null) {
            return null;
        }
        Object loadBundleResource = null;
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IFile sourceFile = LoadBundleUtil.getSourceFile(javaProject, baseName);
            loadBundleResource = sourceFile == null || !sourceFile.exists() ? LoadBundleUtil.getJarFile(javaProject, baseName) : sourceFile;
        }
        return loadBundleResource;
    }

    private static IFile getSourceFile(IJavaProject javaProject, String baseName) throws JavaModelException {
        return LoadBundleUtil.getSourceFile(javaProject, baseName, new HashSet<IProject>());
    }

    private static IFile getSourceFile(IJavaProject javaProject, String baseName, Set<IProject> searchedProjects) throws JavaModelException {
        if (javaProject == null || searchedProjects.contains(javaProject.getProject())) {
            return null;
        }
        searchedProjects.add(javaProject.getProject());
        IClasspathEntry[] classpathEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < classpathEntries.length) {
            if (classpathEntries[i].getEntryKind() == 3) {
                IFile file = LoadBundleUtil.getFile(javaProject, baseName, classpathEntries, i);
                if (file.exists()) {
                    return file;
                }
            } else if (classpathEntries[i].getEntryKind() == 2) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(classpathEntries[i].getPath().toString());
                IJavaProject javaProject3 = JavaCore.create((IProject)project);
                IFile file = LoadBundleUtil.getSourceFile(javaProject3, baseName, searchedProjects);
                if (file != null && file.exists()) {
                    return file;
                }
            } else if (classpathEntries[i].getEntryKind() == 5 && classpathEntries[i].getPath().equals((Object)new Path("org.eclipse.jst.j2ee.internal.module.container"))) {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)classpathEntries[i].getPath(), (IJavaProject)javaProject);
                IClasspathEntry[] classpathEntries2 = container.getClasspathEntries();
                int j = 0;
                while (j < classpathEntries2.length) {
                    IProject project;
                    IJavaProject javaProject3;
                    IFile file;
                    if (classpathEntries2[j].getEntryKind() == 2 && (file = LoadBundleUtil.getSourceFile(javaProject3 = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(classpathEntries2[j].getPath().toString()))), baseName, searchedProjects)) != null && file.exists()) {
                        return file;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private static IFile getFile(IJavaProject javaProject, String baseName, IClasspathEntry[] classpathEntries, int i) {
        IPath path = classpathEntries[i].getPath().append(LoadBundleUtil.getFilePath(baseName)).removeFirstSegments(1);
        path = javaProject.getProject().getFullPath().append(path);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    private static IPath getFilePath(String baseName) {
        Path path = new Path(baseName.replace('.', '/'));
        path = path.addFileExtension("properties");
        return path;
    }

    private static IStorage getJarFile(IJavaProject javaProject, String baseName) throws JavaModelException {
        IClasspathEntry[] roots = javaProject.getRawClasspath();
        return LoadBundleUtil.getJarFile(javaProject, baseName, roots);
    }

    private static IStorage getJarFile(IJavaProject javaProject, String baseName, IClasspathEntry[] roots) throws JavaModelException {
        int i = 0;
        while (i < roots.length) {
            IStorage storage;
            if ((roots[i].getEntryKind() == 1 || roots[i].getEntryKind() == 5) && (storage = LoadBundleUtil.getResourceFromLibrary(javaProject, baseName, roots[i])) != null) {
                return storage;
            }
            ++i;
        }
        return null;
    }

    private static IStorage getResourceFromLibrary(IJavaProject javaProject, String baseName, IClasspathEntry entry) throws JavaModelException {
        IPackageFragmentRoot[] packageFragmentRoots = javaProject.findPackageFragmentRoots(entry);
        int j = 0;
        while (j < packageFragmentRoots.length) {
            String packageName = LoadBundleUtil.getPackageName(baseName);
            Object[] resources = null;
            if (packageName.length() == 0) {
                resources = packageFragmentRoots[j].getNonJavaResources();
            } else {
                IPackageFragment fragment = packageFragmentRoots[j].getPackageFragment(LoadBundleUtil.getPackageName(baseName));
                if (fragment != null && fragment.exists()) {
                    resources = fragment.getNonJavaResources();
                }
            }
            if (resources != null && resources.length > 0) {
                int k = 0;
                while (k < resources.length) {
                    if (resources[k] instanceof IStorage) {
                        IStorage storage = (IStorage)resources[k];
                        if (LoadBundleUtil.getFileName(baseName).equalsIgnoreCase(storage.getName())) {
                            return storage;
                        }
                    }
                    ++k;
                }
            }
            ++j;
        }
        return null;
    }

    private static String getPackageName(String baseName) {
        int index = baseName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return baseName.substring(0, index);
    }

    private static String getFileName(String baseName) {
        int index = baseName.lastIndexOf(46);
        if (index == -1) {
            return baseName + ".properties";
        }
        return baseName.substring(index + 1).concat(".properties");
    }

    public static class LocaleDescriptor {
        private Locale _locale;
        private List _possibleSuffices;

        public LocaleDescriptor(String language) {
            this._locale = new Locale(language);
        }

        public LocaleDescriptor(String language, String country) {
            this._locale = new Locale(language, country);
        }

        public LocaleDescriptor(String language, String country, String variant) {
            this._locale = new Locale(language, country, variant);
        }

        public Iterator getBundleNameIterator(final String baseName) {
            return new Iterator(){
                final Iterator it;
                {
                    this.it = localeDescriptor.getPossibleBaseNameSuffices().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                public Object next() {
                    return baseName + String.valueOf(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        private synchronized List getPossibleBaseNameSuffices() {
            if (this._possibleSuffices == null) {
                ArrayList<Object> possibleSuffices = new ArrayList<Object>(3);
                String language = this._locale.getLanguage();
                String country = this._locale.getCountry();
                String variant = this._locale.getVariant();
                possibleSuffices.add("");
                possibleSuffices.add("_" + language);
                if (country != null) {
                    possibleSuffices.add(0, "_" + language + "_" + country);
                    if (variant != null) {
                        possibleSuffices.add(0, "_" + language + "_" + country + "_" + variant);
                    }
                }
                this._possibleSuffices = Collections.unmodifiableList(possibleSuffices);
            }
            return this._possibleSuffices;
        }

        public Locale getLocale() {
            return this._locale;
        }
    }
}

