/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ide.internal.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.core.TipProvider;
import org.eclipse.tips.core.internal.LogUtil;
import org.eclipse.tips.ide.internal.TipsPreferences;
import org.eclipse.tips.ide.internal.provider.Tip1_Welcome;
import org.eclipse.tips.ide.internal.provider.Tip2_StartingTips;
import org.eclipse.tips.ide.internal.provider.Tip3_StartingTips;
import org.eclipse.tips.ide.internal.provider.Tip6_ActionsTip;
import org.eclipse.tips.ide.internal.provider.Tip7_Extend;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TipsTipProvider
extends TipProvider {
    private TipImage fImage48;

    public TipImage getImage() {
        if (this.fImage48 == null) {
            this.fImage48 = TipsTipProvider.getTipImage("icons/tips.png").map(i -> i.setAspectRatio(1.0)).orElse(null);
        }
        return this.fImage48;
    }

    public synchronized IStatus loadNewTips(IProgressMonitor pMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pMonitor);
        subMonitor.beginTask("Loading Tips", -1);
        ArrayList<Tip> tips = new ArrayList<Tip>();
        tips.add(new Tip1_Welcome(this.getID()));
        tips.add(new Tip2_StartingTips(this.getID()));
        tips.add(new Tip3_StartingTips(this.getID()));
        tips.add(new Tip6_ActionsTip(this.getID()));
        if (Platform.getBundle((String)"org.eclipse.pde.ui") != null) {
            tips.add(new Tip7_Extend(this.getID()));
        }
        this.setTips(tips);
        subMonitor.done();
        return Status.OK_STATUS;
    }

    public String getDescription() {
        return "Tips about Tips";
    }

    public String getID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void dispose() {
    }

    static Date getDateFromYYMMDD(int day, int month, int year) {
        return new GregorianCalendar(year, month + 1, day).getTime();
    }

    static Optional<TipImage> getTipImage(String path) {
        Bundle bundle = FrameworkUtil.getBundle(TipsTipProvider.class);
        try {
            return Optional.of(new TipImage(bundle.getEntry(path)));
        }
        catch (IOException e) {
            TipsPreferences.log(LogUtil.info(TipsTipProvider.class, (Throwable)e));
            return Optional.empty();
        }
    }
}

