/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.dltk.core.DLTKCore;

public class SimpleExtensionManager<E> {
    private final String extensionPoint;
    private final Class<E> elementType;
    private E[] instances = null;

    public SimpleExtensionManager(Class<E> elementType, String extensionPoint) {
        this.elementType = elementType;
        this.extensionPoint = extensionPoint;
    }

    public synchronized E[] getInstances() {
        if (this.instances == null) {
            this.initialize();
        }
        return this.instances;
    }

    private void initialize() {
        ArrayList<E> result = new ArrayList<E>();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(this.extensionPoint);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                E instance = this.createInstance(element);
                if (instance != null) {
                    result.add(instance);
                }
                ++n2;
            }
        }
        this.instances = (Object[])Array.newInstance(this.elementType, result.size());
        result.toArray(this.instances);
    }

    protected E createInstance(IConfigurationElement element) {
        Object instance;
        try {
            instance = element.createExecutableExtension(this.getClassAttribute());
        }
        catch (CoreException e) {
            DLTKCore.error(e);
            return null;
        }
        if (this.elementType.isInstance(instance)) {
            return (E)instance;
        }
        DLTKCore.error(instance.getClass().getName() + " is not " + element.getName());
        return null;
    }

    protected String getClassAttribute() {
        return "class";
    }
}

