/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Item;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.InternalLayoutContext;
import org.eclipse.zest.core.widgets.InternalNodeLayout;
import org.eclipse.zest.core.widgets.PrunedSuccessorsSubgraph;
import org.eclipse.zest.core.widgets.SubgraphFactory;
import org.eclipse.zest.core.widgets.custom.LabelSubgraph;
import org.eclipse.zest.core.widgets.custom.TriangleSubgraph;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.interfaces.ConnectionLayout;
import org.eclipse.zest.layouts.interfaces.EntityLayout;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

public class DefaultSubgraph
implements SubgraphLayout {
    protected final InternalLayoutContext context;
    protected final Set<NodeLayout> nodes = new HashSet<NodeLayout>();
    protected boolean disposed = false;

    protected DefaultSubgraph(LayoutContext context2) {
        if (!(context2 instanceof InternalLayoutContext)) {
            throw new RuntimeException("This subgraph can be only created with LayoutContext provided by Zest Graph");
        }
        this.context = (InternalLayoutContext)context2;
    }

    public boolean isGraphEntity() {
        return false;
    }

    public void setSize(double width, double height) {
        this.context.checkChangesAllowed();
    }

    public void setLocation(double x, double y) {
        this.context.checkChangesAllowed();
    }

    public boolean isResizable() {
        return false;
    }

    public boolean isMovable() {
        return false;
    }

    public EntityLayout[] getSuccessingEntities() {
        return new EntityLayout[0];
    }

    public DisplayIndependentDimension getSize() {
        DisplayIndependentRectangle bounds = this.context.getBounds();
        return new DisplayIndependentDimension(bounds.width, bounds.height);
    }

    public double getPreferredAspectRatio() {
        return 0.0;
    }

    public EntityLayout[] getPredecessingEntities() {
        return new EntityLayout[0];
    }

    public DisplayIndependentPoint getLocation() {
        DisplayIndependentRectangle bounds = this.context.getBounds();
        return new DisplayIndependentPoint(bounds.x + bounds.width / 2.0, bounds.y + bounds.height / 2.0);
    }

    public boolean isDirectionDependant() {
        return false;
    }

    public void setDirection(int direction) {
        this.context.checkChangesAllowed();
    }

    public void removeNodes(NodeLayout[] nodes) {
        this.context.checkChangesAllowed();
        NodeLayout[] nodeLayoutArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout node = nodeLayoutArray[n2];
            if (this.nodes.remove(node)) {
                node.prune(null);
                node.setMinimized(false);
                this.refreshConnectionsVisibility(node.getIncomingConnections());
                this.refreshConnectionsVisibility(node.getOutgoingConnections());
            }
            ++n2;
        }
        if (this.nodes.isEmpty()) {
            this.dispose();
        }
    }

    public void removeDisposedNodes() {
        Iterator<NodeLayout> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            InternalNodeLayout node = (InternalNodeLayout)iterator.next();
            if (!node.isDisposed()) continue;
            iterator.remove();
        }
    }

    public NodeLayout[] getNodes() {
        NodeLayout[] result = new InternalNodeLayout[this.nodes.size()];
        int i = 0;
        for (NodeLayout node : this.nodes) {
            result[i] = (InternalNodeLayout)node;
            if (this.context.isLayoutItemFiltered(result[i].getNode())) continue;
            ++i;
        }
        if (i == this.nodes.size()) {
            return result;
        }
        NodeLayout[] result2 = new NodeLayout[i];
        System.arraycopy(result, 0, result2, 0, i);
        return result2;
    }

    public Item[] getItems() {
        Item[] result = new GraphNode[this.nodes.size()];
        int i = 0;
        for (NodeLayout node2 : this.nodes) {
            InternalNodeLayout node = (InternalNodeLayout)node2;
            result[i] = (GraphNode)node.getItems()[0];
            if (this.context.isLayoutItemFiltered(node.getNode())) continue;
            ++i;
        }
        if (i == this.nodes.size()) {
            return result;
        }
        Item[] result2 = new GraphNode[i];
        System.arraycopy(result, 0, result2, 0, i);
        return result2;
    }

    public int countNodes() {
        return this.nodes.size();
    }

    public void addNodes(NodeLayout[] nodes) {
        this.context.checkChangesAllowed();
        NodeLayout[] nodeLayoutArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout node = nodeLayoutArray[n2];
            if (this.nodes.add(node)) {
                node.prune((SubgraphLayout)this);
                node.setMinimized(true);
                this.refreshConnectionsVisibility(node.getIncomingConnections());
                this.refreshConnectionsVisibility(node.getOutgoingConnections());
            }
            ++n2;
        }
    }

    protected void refreshConnectionsVisibility(ConnectionLayout[] connections) {
        ConnectionLayout[] connectionLayoutArray = connections;
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionLayout connection;
            connection.setVisible(!(connection = connectionLayoutArray[n2]).getSource().isPruned() && !connection.getTarget().isPruned());
            ++n2;
        }
    }

    protected void refreshLocation() {
    }

    protected void refreshSize() {
    }

    protected void applyLayoutChanges() {
    }

    protected void dispose() {
        if (!this.disposed) {
            this.context.removeSubgrah(this);
            this.disposed = true;
        }
    }

    public static class DefaultSubgraphFactory
    implements SubgraphFactory {
        private final Map<LayoutContext, DefaultSubgraph> contextToSubgraph = new HashMap<LayoutContext, DefaultSubgraph>();

        @Override
        public SubgraphLayout createSubgraph(NodeLayout[] nodes, LayoutContext context) {
            DefaultSubgraph subgraph = this.contextToSubgraph.get(context);
            if (subgraph == null) {
                subgraph = new DefaultSubgraph(context);
                this.contextToSubgraph.put(context, subgraph);
            }
            subgraph.addNodes(nodes);
            return subgraph;
        }
    }

    public static class LabelSubgraphFactory
    implements SubgraphFactory {
        private Color defaultForegroundColor = ColorConstants.black;
        private Color defaultBackgroundColor = ColorConstants.yellow;

        public void setDefualtForegroundColor(Color c) {
            this.defaultForegroundColor = c;
        }

        public void setDefaultBackgroundColor(Color c) {
            this.defaultBackgroundColor = c;
        }

        @Override
        public SubgraphLayout createSubgraph(NodeLayout[] nodes, LayoutContext context) {
            return new LabelSubgraph(nodes, context, this.defaultForegroundColor, this.defaultBackgroundColor);
        }
    }

    public static class PrunedSuccessorsSubgraphFactory
    implements SubgraphFactory {
        private final Map<LayoutContext, PrunedSuccessorsSubgraph> contextToSubgraph = new HashMap<LayoutContext, PrunedSuccessorsSubgraph>();

        @Override
        public SubgraphLayout createSubgraph(NodeLayout[] nodes, LayoutContext context) {
            PrunedSuccessorsSubgraph subgraph = this.contextToSubgraph.get(context);
            if (subgraph == null) {
                subgraph = new PrunedSuccessorsSubgraph(context);
                this.contextToSubgraph.put(context, subgraph);
            }
            subgraph.addNodes(nodes);
            return subgraph;
        }

        public void updateLabelForNode(InternalNodeLayout node) {
            InternalLayoutContext context = node.getOwnerLayoutContext();
            PrunedSuccessorsSubgraph subgraph = this.contextToSubgraph.get(context);
            if (subgraph == null) {
                subgraph = new PrunedSuccessorsSubgraph(context);
                this.contextToSubgraph.put(context, subgraph);
            }
            subgraph.updateNodeLabel(node);
        }
    }

    public static class TriangleSubgraphFactory
    implements SubgraphFactory {
        private final TriangleSubgraph.TriangleParameters parameters = new TriangleSubgraph.TriangleParameters();

        @Override
        public SubgraphLayout createSubgraph(NodeLayout[] nodes, LayoutContext context) {
            return new TriangleSubgraph(nodes, context, (TriangleSubgraph.TriangleParameters)this.parameters.clone());
        }

        public Color getColor() {
            return this.parameters.color;
        }

        public void setColor(Color color) {
            this.parameters.color = color;
        }

        public int getDirection() {
            return this.parameters.direction;
        }

        public void setDirection(int direction) {
            this.parameters.direction = direction;
        }

        public double getReferenceHeight() {
            return this.parameters.referenceHeight;
        }

        public void setReferenceHeight(double referenceHeight) {
            this.parameters.referenceHeight = referenceHeight;
        }

        public double getReferenceBase() {
            return this.parameters.referenceBase;
        }

        public void setReferenceBase(double referenceBase) {
            this.parameters.referenceBase = referenceBase;
        }
    }
}

