/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatFieldVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene95.OffHeapByteVectorValues;
import org.apache.lucene.codecs.lucene95.OffHeapFloatVectorValues;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;

public final class Lucene99FlatVectorsWriter
extends FlatVectorsWriter {
    private static final long SHALLLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Lucene99FlatVectorsWriter.class);
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final List<FieldWriter<?>> fields = new ArrayList();
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene99FlatVectorsWriter(SegmentWriteState state, FlatVectorsScorer scorer) throws IOException {
        super(scorer);
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemf");
        String vectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vec");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "Lucene99FlatVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorData, "Lucene99FlatVectorsFormatData", 0, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public FlatFieldVectorsWriter<?> addField(FieldInfo fieldInfo) throws IOException {
        FieldWriter<?> newField = FieldWriter.create(fieldInfo);
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, Sorter.DocMap sortMap) throws IOException {
        for (FieldWriter<?> field : this.fields) {
            if (sortMap == null) {
                this.writeField(field, maxDoc);
            } else {
                this.writeSortingField(field, maxDoc, sortMap);
            }
            field.finish();
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.writeFooter(this.vectorData);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLLOW_RAM_BYTES_USED;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private void writeField(FieldWriter<?> fieldData, int maxDoc) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        switch (fieldData.fieldInfo.getVectorEncoding()) {
            case BYTE: {
                this.writeByteVectors(fieldData);
                break;
            }
            case FLOAT32: {
                this.writeFloat32Vectors(fieldData);
            }
        }
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, fieldData.docsWithField);
    }

    private void writeFloat32Vectors(FieldWriter<?> fieldData) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(fieldData.dim * 4).order(ByteOrder.LITTLE_ENDIAN);
        for (Object v : fieldData.vectors) {
            buffer.asFloatBuffer().put((float[])v);
            this.vectorData.writeBytes(buffer.array(), buffer.array().length);
        }
    }

    private void writeByteVectors(FieldWriter<?> fieldData) throws IOException {
        for (Object v : fieldData.vectors) {
            byte[] vector = (byte[])v;
            this.vectorData.writeBytes(vector, vector.length);
        }
    }

    private void writeSortingField(FieldWriter<?> fieldData, int maxDoc, Sorter.DocMap sortMap) throws IOException {
        int[] ordMap = new int[fieldData.docsWithField.cardinality()];
        DocsWithFieldSet newDocsWithField = new DocsWithFieldSet();
        Lucene99FlatVectorsWriter.mapOldOrdToNewOrd(fieldData.docsWithField, sortMap, null, ordMap, newDocsWithField);
        long vectorDataOffset = switch (fieldData.fieldInfo.getVectorEncoding()) {
            default -> throw new MatchException(null, null);
            case VectorEncoding.BYTE -> this.writeSortedByteVectors(fieldData, ordMap);
            case VectorEncoding.FLOAT32 -> this.writeSortedFloat32Vectors(fieldData, ordMap);
        };
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldData.fieldInfo, maxDoc, vectorDataOffset, vectorDataLength, newDocsWithField);
    }

    private long writeSortedFloat32Vectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        ByteBuffer buffer = ByteBuffer.allocate(fieldData.dim * 4).order(ByteOrder.LITTLE_ENDIAN);
        for (int ordinal : ordMap) {
            float[] vector = (float[])fieldData.vectors.get(ordinal);
            buffer.asFloatBuffer().put(vector);
            this.vectorData.writeBytes(buffer.array(), buffer.array().length);
        }
        return vectorDataOffset;
    }

    private long writeSortedByteVectors(FieldWriter<?> fieldData, int[] ordMap) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        for (int ordinal : ordMap) {
            byte[] vector = (byte[])fieldData.vectors.get(ordinal);
            this.vectorData.writeBytes(vector, vector.length);
        }
        return vectorDataOffset;
    }

    @Override
    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        DocsWithFieldSet docsWithField = switch (fieldInfo.getVectorEncoding()) {
            default -> throw new MatchException(null, null);
            case VectorEncoding.BYTE -> Lucene99FlatVectorsWriter.writeByteVectorData(this.vectorData, KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState));
            case VectorEncoding.FLOAT32 -> Lucene99FlatVectorsWriter.writeVectorData(this.vectorData, KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState));
        };
        long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
        this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, docsWithField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableRandomVectorScorerSupplier mergeOneFieldToIndex(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        FlatCloseableRandomVectorScorerSupplier flatCloseableRandomVectorScorerSupplier;
        block11: {
            long vectorDataOffset = this.vectorData.alignFilePointer(4);
            IndexOutput tempVectorData = this.segmentWriteState.directory.createTempOutput(this.vectorData.getName(), "temp", this.segmentWriteState.context);
            IndexInput vectorDataInput = null;
            boolean success = false;
            try {
                DocsWithFieldSet docsWithField = switch (fieldInfo.getVectorEncoding()) {
                    default -> throw new MatchException(null, null);
                    case VectorEncoding.BYTE -> Lucene99FlatVectorsWriter.writeByteVectorData(tempVectorData, KnnVectorsWriter.MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState));
                    case VectorEncoding.FLOAT32 -> Lucene99FlatVectorsWriter.writeVectorData(tempVectorData, KnnVectorsWriter.MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState));
                };
                CodecUtil.writeFooter(tempVectorData);
                IOUtils.close(tempVectorData);
                vectorDataInput = this.segmentWriteState.directory.openInput(tempVectorData.getName(), IOContext.DEFAULT.withReadAdvice(ReadAdvice.RANDOM));
                this.vectorData.copyBytes(vectorDataInput, vectorDataInput.length() - (long)CodecUtil.footerLength());
                CodecUtil.retrieveChecksum(vectorDataInput);
                long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
                this.writeMeta(fieldInfo, this.segmentWriteState.segmentInfo.maxDoc(), vectorDataOffset, vectorDataLength, docsWithField);
                success = true;
                IndexInput finalVectorDataInput = vectorDataInput;
                RandomVectorScorerSupplier randomVectorScorerSupplier = switch (fieldInfo.getVectorEncoding()) {
                    default -> throw new MatchException(null, null);
                    case VectorEncoding.BYTE -> this.vectorsScorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), new OffHeapByteVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), finalVectorDataInput, fieldInfo.getVectorDimension() * 1, this.vectorsScorer, fieldInfo.getVectorSimilarityFunction()));
                    case VectorEncoding.FLOAT32 -> this.vectorsScorer.getRandomVectorScorerSupplier(fieldInfo.getVectorSimilarityFunction(), new OffHeapFloatVectorValues.DenseOffHeapVectorValues(fieldInfo.getVectorDimension(), docsWithField.cardinality(), finalVectorDataInput, fieldInfo.getVectorDimension() * 4, this.vectorsScorer, fieldInfo.getVectorSimilarityFunction()));
                };
                flatCloseableRandomVectorScorerSupplier = new FlatCloseableRandomVectorScorerSupplier(() -> {
                    IOUtils.close(finalVectorDataInput);
                    this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
                }, docsWithField.cardinality(), randomVectorScorerSupplier);
                if (success) break block11;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(vectorDataInput, tempVectorData);
                    IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(vectorDataInput, tempVectorData);
            IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
        }
        return flatCloseableRandomVectorScorerSupplier;
    }

    private void writeMeta(FieldInfo field, int maxDoc, long vectorDataOffset, long vectorDataLength, DocsWithFieldSet docsWithField) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        OrdToDocDISIReaderConfiguration.writeStoredMeta(16, this.meta, this.vectorData, count, maxDoc, docsWithField);
    }

    private static DocsWithFieldSet writeByteVectorData(IndexOutput output, ByteVectorValues byteVectorValues) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        KnnVectorValues.DocIndexIterator iter = byteVectorValues.iterator();
        int docV = iter.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            byte[] binaryValue = byteVectorValues.vectorValue(iter.index());
            assert (binaryValue.length == byteVectorValues.dimension() * VectorEncoding.BYTE.byteSize);
            output.writeBytes(binaryValue, binaryValue.length);
            docsWithField.add(docV);
            docV = iter.nextDoc();
        }
        return docsWithField;
    }

    private static DocsWithFieldSet writeVectorData(IndexOutput output, FloatVectorValues floatVectorValues) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        ByteBuffer buffer = ByteBuffer.allocate(floatVectorValues.dimension() * VectorEncoding.FLOAT32.byteSize).order(ByteOrder.LITTLE_ENDIAN);
        KnnVectorValues.DocIndexIterator iter = floatVectorValues.iterator();
        int docV = iter.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            float[] value = floatVectorValues.vectorValue(iter.index());
            buffer.asFloatBuffer().put(value);
            output.writeBytes(buffer.array(), buffer.limit());
            docsWithField.add(docV);
            docV = iter.nextDoc();
        }
        return docsWithField;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorData);
    }

    private static abstract class FieldWriter<T>
    extends FlatFieldVectorsWriter<T> {
        private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldWriter.class);
        private final FieldInfo fieldInfo;
        private final int dim;
        private final DocsWithFieldSet docsWithField;
        private final List<T> vectors;
        private boolean finished;
        private int lastDocID = -1;

        static FieldWriter<?> create(FieldInfo fieldInfo) {
            final int dim = fieldInfo.getVectorDimension();
            return switch (fieldInfo.getVectorEncoding()) {
                default -> throw new MatchException(null, null);
                case VectorEncoding.BYTE -> new FieldWriter<byte[]>(fieldInfo){

                    @Override
                    public byte[] copyValue(byte[] value) {
                        return ArrayUtil.copyOfSubArray(value, 0, dim);
                    }
                };
                case VectorEncoding.FLOAT32 -> new FieldWriter<float[]>(fieldInfo){

                    @Override
                    public float[] copyValue(float[] value) {
                        return ArrayUtil.copyOfSubArray(value, 0, dim);
                    }
                };
            };
        }

        FieldWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            this.dim = fieldInfo.getVectorDimension();
            this.docsWithField = new DocsWithFieldSet();
            this.vectors = new ArrayList<T>();
        }

        @Override
        public void addValue(int docID, T vectorValue) throws IOException {
            if (this.finished) {
                throw new IllegalStateException("already finished, cannot add more values");
            }
            if (docID == this.lastDocID) {
                throw new IllegalArgumentException("VectorValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
            }
            assert (docID > this.lastDocID);
            T copy = this.copyValue(vectorValue);
            this.docsWithField.add(docID);
            this.vectors.add(copy);
            this.lastDocID = docID;
        }

        @Override
        public long ramBytesUsed() {
            long size = SHALLOW_RAM_BYTES_USED;
            if (this.vectors.size() == 0) {
                return size;
            }
            return size + this.docsWithField.ramBytesUsed() + (long)this.vectors.size() * (long)(RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER) + (long)this.vectors.size() * (long)this.fieldInfo.getVectorDimension() * (long)this.fieldInfo.getVectorEncoding().byteSize;
        }

        @Override
        public List<T> getVectors() {
            return this.vectors;
        }

        @Override
        public DocsWithFieldSet getDocsWithFieldSet() {
            return this.docsWithField;
        }

        @Override
        public void finish() throws IOException {
            if (this.finished) {
                return;
            }
            this.finished = true;
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }
    }

    static final class FlatCloseableRandomVectorScorerSupplier
    implements CloseableRandomVectorScorerSupplier {
        private final RandomVectorScorerSupplier supplier;
        private final Closeable onClose;
        private final int numVectors;

        FlatCloseableRandomVectorScorerSupplier(Closeable onClose, int numVectors, RandomVectorScorerSupplier supplier) {
            this.onClose = onClose;
            this.supplier = supplier;
            this.numVectors = numVectors;
        }

        @Override
        public RandomVectorScorer scorer(int ord) throws IOException {
            return this.supplier.scorer(ord);
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return this.supplier.copy();
        }

        @Override
        public void close() throws IOException {
            this.onClose.close();
        }

        @Override
        public int totalVectorCount() {
            return this.numVectors;
        }
    }
}

