/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IProxyField;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.ide.IDEBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEExpression;
import org.eclipse.jem.internal.proxy.ide.IDEMethodProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEObjectBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;

public class IDEBeanTypeProxy
extends IDEBeanProxy
implements IBeanTypeProxy {
    protected IDEProxyFactoryRegistry fProxyFactoryRegistry;
    Class fClass;

    protected IDEBeanTypeProxy(IDEProxyFactoryRegistry aRegistry, Class aClass) {
        super(aRegistry, aClass);
        this.fProxyFactoryRegistry = aRegistry;
        this.fClass = aClass;
    }

    @Override
    public IBeanTypeProxy getTypeProxy() {
        return ((IDEStandardBeanTypeProxyFactory)this.fProxyFactoryRegistry.getBeanTypeProxyFactory()).classClass;
    }

    public Class getTypeClass() {
        return this.fClass;
    }

    @Override
    public String toBeanString() {
        return this.fClass.toString();
    }

    @Override
    public ProxyFactoryRegistry getProxyFactoryRegistry() {
        return this.fProxyFactoryRegistry;
    }

    @Override
    public String getTypeName() {
        return this.fClass.getName();
    }

    @Override
    public boolean isKindOf(IBeanTypeProxy aBeanTypeProxy) {
        return ((IDEBeanTypeProxy)aBeanTypeProxy).fClass.isAssignableFrom(this.fClass);
    }

    @Override
    public boolean isInterface() {
        return this.fClass.isInterface();
    }

    @Override
    public boolean isPrimitive() {
        return this.fClass.isPrimitive();
    }

    @Override
    public boolean isArray() {
        return this.fClass.isArray();
    }

    @Override
    public IMethodProxy[] getMethods() {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getMethods(this.fClass);
    }

    @Override
    public IMethodProxy[] getDeclaredMethods() {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getDeclaredMethods(this.fClass);
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName) {
        try {
            Method aMethod = this.fClass.getMethod(methodName, new Class[0]);
            return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getMethodProxy(aMethod);
        }
        catch (Exception exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            return null;
        }
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, String[] argumentClassNames) {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getMethodProxy(this, methodName, argumentClassNames);
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, String firstArgClass) {
        return this.getMethodProxy(methodName, new String[]{firstArgClass});
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, IBeanTypeProxy[] args) {
        Class[] argClasses = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argClasses[i] = ((IDEBeanTypeProxy)args[i]).fClass;
            ++i;
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getMethodProxy(this.fClass, methodName, argClasses);
    }

    @Override
    public IMethodProxy getDeclaredMethodProxy(String methodName, String[] argumentClassNames) {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getDeclaredMethodProxy(this.fClass, methodName, argumentClassNames);
    }

    @Override
    public IMethodProxy getDeclaredMethodProxy(String methodName, IBeanTypeProxy[] args) {
        Class[] argClasses = null;
        if (args != null) {
            argClasses = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argClasses[i] = ((IDEBeanTypeProxy)args[i]).fClass;
                ++i;
            }
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getDeclaredMethodProxy(this.fClass, methodName, argClasses);
    }

    @Override
    public IInvokable getInvokable(String methodName, IBeanTypeProxy[] argumentTypes) {
        return this.getMethodProxy(methodName, argumentTypes);
    }

    @Override
    public IInvokable getInvokable(String methodName, String argumentClassName) {
        return this.getMethodProxy(methodName, argumentClassName);
    }

    @Override
    public IInvokable getInvokable(String methodName, String[] argumentClassNames) {
        return this.getMethodProxy(methodName, argumentClassNames);
    }

    @Override
    public IInvokable getInvokable(String methodName) {
        return this.getMethodProxy(methodName);
    }

    @Override
    public IConstructorProxy getConstructorProxy(String[] argTypeNames) {
        IBeanTypeProxy[] argClasses = new IBeanTypeProxy[argTypeNames.length];
        IStandardBeanTypeProxyFactory btFactory = this.fProxyFactoryRegistry.getBeanTypeProxyFactory();
        int i = 0;
        while (i < argTypeNames.length) {
            argClasses[i] = btFactory.getBeanTypeProxy(argTypeNames[i]);
            if (argClasses[i] == null) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Constructor not found - " + this.fClass.getName() + " args=" + argTypeNames, null));
                return null;
            }
            ++i;
        }
        return this.getConstructorProxy(argClasses);
    }

    @Override
    public IConstructorProxy getConstructorProxy(IBeanTypeProxy[] args) {
        Class[] argClasses = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argClasses[i] = ((IDEBeanTypeProxy)args[i]).fClass;
            ++i;
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getConstructorProxy(this.fClass, argClasses);
    }

    @Override
    public IConstructorProxy[] getConstructors() {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getConstructors(this.fClass);
    }

    @Override
    public IConstructorProxy getDeclaredConstructorProxy(String[] argTypeNames) {
        IBeanTypeProxy[] argClasses = new IBeanTypeProxy[argTypeNames.length];
        IStandardBeanTypeProxyFactory btFactory = this.fProxyFactoryRegistry.getBeanTypeProxyFactory();
        int i = 0;
        while (i < argTypeNames.length) {
            argClasses[i] = btFactory.getBeanTypeProxy(argTypeNames[i]);
            if (argClasses[i] == null) {
                ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Constructor not found - " + this.fClass.getName() + " args=" + argTypeNames, null));
                return null;
            }
            ++i;
        }
        return this.getDeclaredConstructorProxy(argClasses);
    }

    @Override
    public IConstructorProxy getDeclaredConstructorProxy(IBeanTypeProxy[] args) {
        Class[] argClasses = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            argClasses[i] = ((IDEBeanTypeProxy)args[i]).fClass;
            ++i;
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getDeclaredConstructorProxy(this.fClass, argClasses);
    }

    @Override
    public IConstructorProxy[] getDeclaredConstructors() {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getDeclaredConstructors(this.fClass);
    }

    @Override
    public IBeanTypeProxy getSuperBeanTypeProxy() {
        if (this.fClass.isInterface()) {
            return null;
        }
        return this.fProxyFactoryRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(this.fClass.getSuperclass().getName());
    }

    @Override
    public IFieldProxy[] getFields() {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getFields(this.fClass);
    }

    @Override
    public IFieldProxy[] getDeclaredFields() {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getDeclaredFields(this.fClass);
    }

    @Override
    public IFieldProxy getFieldProxy(String fieldName) {
        try {
            Field field = this.fClass.getField(fieldName);
            return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getFieldProxy(field);
        }
        catch (NoSuchFieldException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Field not found " + this.fClass.getName() + " - " + fieldName, (Throwable)exc));
            return null;
        }
    }

    @Override
    public IFieldProxy getDeclaredFieldProxy(String fieldName) {
        try {
            Field field = this.fClass.getDeclaredField(fieldName);
            return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getFieldProxy(field);
        }
        catch (NoSuchFieldException exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Field not found " + this.fClass.getName() + " - " + fieldName, (Throwable)exc));
            return null;
        }
    }

    IConstructorProxy getConstructorProxy(Class[] parameterTypes) {
        Constructor aConstructor = null;
        try {
            aConstructor = this.fClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
        }
        if (aConstructor != null) {
            return this.getNewConstructorProxy(aConstructor);
        }
        return null;
    }

    protected IConstructorProxy getNewConstructorProxy(Constructor aConstructor) {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getConstructorProxy(aConstructor);
    }

    @Override
    public IConstructorProxy getNullConstructorProxy() {
        Constructor aConstructor = null;
        try {
            aConstructor = this.fClass.getConstructor(null);
            return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getConstructorProxy(aConstructor);
        }
        catch (Exception e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            return null;
        }
    }

    @Override
    public IBeanProxy newInstance(String initializationString) {
        return ((IDEStandardBeanProxyFactory)this.fProxyFactoryRegistry.getBeanProxyFactory()).createBeanProxy(this, initializationString);
    }

    @Override
    public IBeanProxy newInstance() {
        return ((IDEStandardBeanProxyFactory)this.fProxyFactoryRegistry.getBeanProxyFactory()).createBeanProxy(this);
    }

    protected IIDEBeanProxy newBeanProxy(Object anObject) {
        return new IDEObjectBeanProxy(this.fProxyFactoryRegistry, anObject, this);
    }

    public IDEBeanTypeProxy newBeanTypeForClass(Class type) {
        return new IDEBeanTypeProxy(this.fProxyFactoryRegistry, type);
    }

    @Override
    public String getFormalTypeName() {
        return this.getTypeName();
    }

    @Override
    public String getInitializationError() {
        return null;
    }

    @Override
    public IConstructorProxy getCompatibleConstructor(IBeanTypeProxy[] argumentTypes) throws AmbiguousMethodException, NoSuchMethodException, IllegalAccessException {
        Class[] argClasses = new Class[argumentTypes.length];
        int i = 0;
        while (i < argumentTypes.length) {
            argClasses[i] = ((IDEBeanTypeProxy)argumentTypes[i]).fClass;
            ++i;
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getCompatibleConstructor(this.fClass, argClasses);
    }

    @Override
    public IMethodProxy getCompatibleMethod(String methodName, IBeanTypeProxy[] argumentTypes) throws NoSuchMethodException, AmbiguousMethodException {
        Class[] argClasses = new Class[argumentTypes.length];
        int i = 0;
        while (i < argumentTypes.length) {
            argClasses[i] = ((IDEBeanTypeProxy)argumentTypes[i]).fClass;
            ++i;
        }
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getCompatibleMethod(this.fClass, methodName, argClasses);
    }

    @Override
    public IProxyMethod getMethodProxy(IExpression expression, String methodName, IProxyBeanType[] parameterTypes) {
        IProxyMethod method = ((IDEExpression)expression).getMethodExpressionProxy(this, methodName, parameterTypes);
        if (method == null) {
            method = ((Expression)expression).createMethodExpressionProxy(this, methodName, parameterTypes);
        }
        return method;
    }

    @Override
    public IProxyMethod getMethodProxy(IExpression expression, String methodName, String[] parameterTypes) {
        return ((IDEMethodProxyFactory)this.fProxyFactoryRegistry.getMethodProxyFactory()).getMethodProxy(expression, this, methodName, parameterTypes);
    }

    @Override
    public IProxyMethod getMethodProxy(IExpression expression, String methodName) {
        return this.getMethodProxy(expression, methodName, (IProxyBeanType[])null);
    }

    @Override
    public IProxyField getFieldProxy(IExpression expression, String fieldName) {
        IProxyField field = ((IDEExpression)expression).getFieldExpressionProxy(this, fieldName);
        if (field == null) {
            field = ((Expression)expression).createFieldExpressionProxy(this, fieldName);
        }
        return field;
    }
}

