/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.ExtensibilityElement;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;

public class AP2930
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;

    public AP2930(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            boolean faultsFound = false;
            Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
            List ops = binding.getBindingOperations();
            int i = 0;
            while (i < ops.size()) {
                BindingOperation bindingOperation = (BindingOperation)ops.get(i);
                Collection faults = bindingOperation.getBindingFaults().values();
                if (!faults.isEmpty()) {
                    faultsFound = true;
                    if (this.containsMimeMultiparts(faults)) {
                        throw new AssertionFailException("The binding operation is \"" + bindingOperation.getName() + "\".");
                    }
                }
                ++i;
            }
            if (!faultsFound) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsMimeMultiparts(Collection faults) {
        Iterator i = faults.iterator();
        while (i.hasNext()) {
            List extElems = ((BindingFault)i.next()).getExtensibilityElements();
            int j = 0;
            while (j < extElems.size()) {
                if (((ExtensibilityElement)extElems.get(j)).getElementType().equals(WSDL_MIME_MULTIPART)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }
}

