/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.WSITestToolsPlugin;
import org.eclipse.wst.wsi.internal.core.profile.validator.BaseValidator;
import org.eclipse.wst.wsi.internal.core.util.ArtifactType;

public class EntryType {
    private ArtifactType artifactType;
    private String typeName;
    protected static TreeMap entryTypeMap;
    protected static final TreeMap entryTypeNameMap;
    public static final String TYPE_ENVELOPE_REQUEST = "requestEnvelope";
    public static final String TYPE_ENVELOPE_RESPONSE = "responseEnvelope";
    public static final String TYPE_ENVELOPE_ANY = "anyEnvelope";
    public static final String TYPE_MESSAGE_REQUEST = "requestMessage";
    public static final String TYPE_MESSAGE_RESPONSE = "responseMessage";
    public static final String TYPE_MESSAGE_ANY = "anyMessage";
    public static final String TYPE_MIME_PART = "part";
    public static final String TYPE_MIME_ROOT_PART = "root-part";
    public static final String TYPE_DESCRIPTION_DEFINITIONS = "definitions";
    public static final String TYPE_DESCRIPTION_IMPORT = "import";
    public static final String TYPE_DESCRIPTION_TYPES = "types";
    public static final String TYPE_DESCRIPTION_MESSAGE = "message";
    public static final String TYPE_DESCRIPTION_OPERATION = "operation";
    public static final String TYPE_DESCRIPTION_PORTTYPE = "portType";
    public static final String TYPE_DESCRIPTION_BINDING = "binding";
    public static final String TYPE_DESCRIPTION_PORT = "port";
    public static final String TYPE_DISCOVERY_BINDINGTEMPLATE = "bindingTemplate";
    public static final String TYPE_DISCOVERY_TMODEL = "tModel";
    public static final EntryType ENTRY_TYPE_REQUESTENV;
    public static final EntryType ENTRY_TYPE_RESPONSEENV;
    public static final EntryType ENTRY_TYPE_REQUEST;
    public static final EntryType ENTRY_TYPE_RESPONSE;
    public static final EntryType ENTRY_TYPE_DEFINITIONS;
    public static final EntryType ENTRY_TYPE_IMPORT;
    public static final EntryType ENTRY_TYPE_TYPES;
    public static final EntryType ENTRY_TYPE_MESSAGE;
    public static final EntryType ENTRY_TYPE_OPERATION;
    public static final EntryType ENTRY_TYPE_PORTTYPE;
    public static final EntryType ENTRY_TYPE_BINDING;
    public static final EntryType ENTRY_TYPE_PORT;
    public static final EntryType ENTRY_TYPE_BINDINGTEMPLATE;
    public static final EntryType ENTRY_TYPE_TMODEL;

    static {
        entryTypeNameMap = new TreeMap();
        ENTRY_TYPE_REQUESTENV = EntryType.getEntryType(TYPE_ENVELOPE_REQUEST);
        ENTRY_TYPE_RESPONSEENV = EntryType.getEntryType(TYPE_ENVELOPE_RESPONSE);
        ENTRY_TYPE_REQUEST = EntryType.getEntryType(TYPE_MESSAGE_REQUEST);
        ENTRY_TYPE_RESPONSE = EntryType.getEntryType(TYPE_MESSAGE_RESPONSE);
        ENTRY_TYPE_DEFINITIONS = EntryType.getEntryType(TYPE_DESCRIPTION_DEFINITIONS);
        ENTRY_TYPE_IMPORT = EntryType.getEntryType(TYPE_DESCRIPTION_IMPORT);
        ENTRY_TYPE_TYPES = EntryType.getEntryType(TYPE_DESCRIPTION_TYPES);
        ENTRY_TYPE_MESSAGE = EntryType.getEntryType(TYPE_DESCRIPTION_MESSAGE);
        ENTRY_TYPE_OPERATION = EntryType.getEntryType(TYPE_DESCRIPTION_OPERATION);
        ENTRY_TYPE_PORTTYPE = EntryType.getEntryType(TYPE_DESCRIPTION_PORTTYPE);
        ENTRY_TYPE_BINDING = EntryType.getEntryType(TYPE_DESCRIPTION_BINDING);
        ENTRY_TYPE_PORT = EntryType.getEntryType(TYPE_DESCRIPTION_PORT);
        ENTRY_TYPE_BINDINGTEMPLATE = EntryType.getEntryType(TYPE_DISCOVERY_BINDINGTEMPLATE);
        ENTRY_TYPE_TMODEL = EntryType.getEntryType(TYPE_DISCOVERY_TMODEL);
    }

    private EntryType(ArtifactType artifactType, String typeName) {
        this.artifactType = artifactType;
        this.typeName = typeName;
    }

    public boolean isType(String typeName) {
        return this.typeName.equals(typeName);
    }

    public boolean isType(EntryType entryType) {
        return this.typeName.equals(entryType.getTypeName());
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static final boolean isValidEntryType(String typeName) {
        return entryTypeMap.get(typeName) != null;
    }

    public static final EntryType getEntryType(String typeName) throws RuntimeException {
        EntryType entryType;
        if (entryTypeMap == null) {
            BaseValidator[] validators = WSITestToolsPlugin.getPlugin().getBaseValidators();
            int i = 0;
            while (i < validators.length) {
                String[] entryTypes = validators[i].getEntryTypes();
                int j = 0;
                while (j < entryTypes.length) {
                    EntryType.registerEntryType(ArtifactType.getArtifactType(validators[i].getArtifactType()), entryTypes[j]);
                    ++j;
                }
                ++i;
            }
        }
        if ((entryType = (EntryType)entryTypeMap.get(typeName)) == null) {
            throw new RuntimeException("Could not get entry type because type name is invalid: " + typeName + ".");
        }
        return entryType;
    }

    public static final Vector getEntryTypeNameList(String artifactTypeName) throws RuntimeException {
        Vector entryTypeNameList = (Vector)entryTypeNameMap.get(artifactTypeName);
        if (entryTypeNameList == null) {
            throw new RuntimeException("Could not get entry type name list because artifact type name is invalid: " + artifactTypeName + ".");
        }
        return entryTypeNameList;
    }

    public static final EntryType registerEntryType(ArtifactType artifactType, String typeName) {
        EntryType entryType = null;
        entryType = new EntryType(artifactType, typeName);
        if (entryTypeMap == null) {
            entryTypeMap = new TreeMap();
        }
        entryTypeMap.put(typeName, entryType);
        Vector<String> entryTypeNameList = (Vector<String>)entryTypeNameMap.get(artifactType.getTypeName());
        if (entryTypeNameList == null) {
            entryTypeNameList = new Vector<String>();
            entryTypeNameMap.put(artifactType.getTypeName(), entryTypeNameList);
        }
        entryTypeNameList.add(typeName);
        return entryType;
    }
}

