/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing.parser.util.format;

import com.google.javascript.jscomp.parsing.parser.util.format.IllegalFormatCodePointException;
import com.google.javascript.jscomp.parsing.parser.util.format.IllegalFormatConversionException;
import com.google.javascript.jscomp.parsing.parser.util.format.IllegalFormatFlagsException;
import com.google.javascript.jscomp.parsing.parser.util.format.IllegalFormatPrecisionException;
import com.google.javascript.jscomp.parsing.parser.util.format.IllegalFormatWidthException;
import com.google.javascript.jscomp.parsing.parser.util.format.MissingFormatArgumentException;
import com.google.javascript.jscomp.parsing.parser.util.format.MissingFormatWidthException;
import com.google.javascript.jscomp.parsing.parser.util.format.UnknownFormatConversionException;
import java.util.Arrays;
import java.util.Date;

public final class SimpleFormat {
    final StringBuilder out = new StringBuilder();
    private Object arg;
    private FormatToken formatToken;

    public static String format(String format, Object ... args) {
        SimpleFormat f = new SimpleFormat();
        f.doFormat(format, args);
        return f.out.toString();
    }

    private SimpleFormat() {
    }

    private void doFormat(String format, Object ... args) {
        FormatSpecifierParser fsp = new FormatSpecifierParser(format);
        int currentObjectIndex = 0;
        Object lastArgument = null;
        boolean hasLastArgumentSet = false;
        int length = format.length();
        int i = 0;
        while (i < length) {
            CharSequence substitution;
            int plainTextEnd;
            int plainTextStart = i;
            int nextPercent = format.indexOf(37, i);
            int n = plainTextEnd = nextPercent == -1 ? length : nextPercent;
            if (plainTextEnd > plainTextStart) {
                this.outputCharSequence(format, plainTextStart, plainTextEnd);
            }
            if ((i = plainTextEnd) >= length) continue;
            FormatToken token = fsp.parseFormatToken(i + 1);
            Object argument = null;
            if (token.requireArgument()) {
                int index = token.getArgIndex() == -1 ? currentObjectIndex++ : token.getArgIndex();
                lastArgument = argument = SimpleFormat.getArgument(args, index, fsp, lastArgument, hasLastArgumentSet);
                hasLastArgumentSet = true;
            }
            if ((substitution = this.transform(token, argument)) != null) {
                this.outputCharSequence(substitution, 0, substitution.length());
            }
            i = fsp.i;
        }
    }

    private void outputCharSequence(CharSequence cs, int start, int end) {
        this.out.append(cs, start, end);
    }

    private static Object getArgument(Object[] args, int index, FormatSpecifierParser fsp, Object lastArgument, boolean hasLastArgumentSet) {
        if (index == -2 && !hasLastArgumentSet) {
            throw new MissingFormatArgumentException("<");
        }
        if (args == null) {
            return null;
        }
        if (index >= args.length) {
            throw new MissingFormatArgumentException(fsp.getFormatSpecifierText());
        }
        if (index == -2) {
            return lastArgument;
        }
        return args[index];
    }

    private CharSequence transform(FormatToken token, Object argument) {
        CharSequence result;
        this.formatToken = token;
        this.arg = argument;
        if (token.isDefault()) {
            switch (token.getConversionType()) {
                case 's': {
                    if (this.arg == null) {
                        return "null";
                    }
                }
                case 'd': {
                    if (!(this.arg instanceof Integer) && !(this.arg instanceof Long) && !(this.arg instanceof Short) && !(this.arg instanceof Byte)) break;
                    String result2 = this.arg.toString();
                    return result2;
                }
            }
        }
        this.formatToken.checkFlags(this.arg);
        switch (token.getConversionType()) {
            case 'B': 
            case 'b': {
                result = this.transformFromBoolean();
                break;
            }
            case 'H': 
            case 'h': {
                result = this.transformFromHashCode();
                break;
            }
            case 'S': 
            case 's': {
                result = this.transformFromString();
                break;
            }
            case 'C': 
            case 'c': {
                result = this.transformFromCharacter();
                break;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                result = this.transformFromInteger();
                break;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                result = this.transformFromFloat();
                break;
            }
            case '%': {
                result = this.transformFromPercent();
                break;
            }
            case 'n': {
                result = SimpleFormat.transformFromLineSeparator();
                break;
            }
            case 'T': 
            case 't': {
                result = this.transformFromDateTime();
                break;
            }
            default: {
                throw token.unknownFormatConversionException();
            }
        }
        if (Character.isUpperCase(token.getConversionType()) && result != null) {
            result = result.toString().toUpperCase();
        }
        return result;
    }

    private IllegalFormatConversionException badArgumentType() {
        throw new IllegalFormatConversionException(this.formatToken.getConversionType(), this.arg.getClass());
    }

    private CharSequence transformFromBoolean() {
        String result = this.arg instanceof Boolean ? this.arg.toString() : (this.arg == null ? "false" : "true");
        return this.padding(result, 0);
    }

    private CharSequence transformFromHashCode() {
        if (this.arg != null) {
            throw new RuntimeException("Integer.toHexString is outside the GWT subset");
        }
        String result = "null";
        return this.padding(result, 0);
    }

    private CharSequence transformFromString() {
        String result = String.valueOf(this.arg);
        return this.padding(result, 0);
    }

    private CharSequence transformFromCharacter() {
        if (this.arg == null) {
            return this.padding("null", 0);
        }
        if (this.arg instanceof Character) {
            return this.padding(String.valueOf(this.arg), 0);
        }
        if (this.arg instanceof Byte || this.arg instanceof Short || this.arg instanceof Integer) {
            int codePoint = ((Number)this.arg).intValue();
            if (!Character.isValidCodePoint(codePoint)) {
                throw new IllegalFormatCodePointException(codePoint);
            }
            String result = codePoint < 65536 ? String.valueOf((char)codePoint) : String.valueOf(Character.toChars(codePoint));
            return this.padding(result, 0);
        }
        throw this.badArgumentType();
    }

    private CharSequence transformFromPercent() {
        return this.padding("%", 0);
    }

    private static CharSequence transformFromLineSeparator() {
        return "\n";
    }

    private CharSequence padding(CharSequence source, int startIndex) {
        int start = startIndex;
        int width = this.formatToken.getWidth();
        int precision = this.formatToken.getPrecision();
        int length = source.length();
        if (precision >= 0) {
            length = Math.min(length, precision);
            if (source instanceof StringBuilder) {
                ((StringBuilder)source).setLength(length);
            } else {
                source = source.subSequence(0, length);
            }
        }
        if (width > 0) {
            width = Math.max(source.length(), width);
        }
        if (length >= width) {
            return source;
        }
        char paddingChar = ' ';
        if (this.formatToken.flagZero) {
            paddingChar = this.formatToken.getConversionType() == 'd' ? (char)'0' : '0';
        } else {
            start = 0;
        }
        char[] paddingChars = new char[width - length];
        Arrays.fill(paddingChars, paddingChar);
        boolean paddingRight = this.formatToken.flagMinus;
        StringBuilder result = SimpleFormat.toStringBuilder(source);
        if (paddingRight) {
            result.append(paddingChars);
        } else {
            result.insert(start, paddingChars);
        }
        return result;
    }

    private static StringBuilder toStringBuilder(CharSequence cs) {
        return cs instanceof StringBuilder ? (StringBuilder)cs : new StringBuilder(cs);
    }

    private StringBuilder wrapParentheses(StringBuilder result) {
        result.setCharAt(0, '(');
        if (this.formatToken.flagZero) {
            this.formatToken.setWidth(this.formatToken.getWidth() - 1);
            result = (StringBuilder)this.padding(result, 1);
            result.append(')');
        } else {
            result.append(')');
            result = (StringBuilder)this.padding(result, 0);
        }
        return result;
    }

    private CharSequence transformFromInteger() {
        long value;
        int startIndex = 0;
        StringBuilder result = new StringBuilder();
        char currentConversionType = this.formatToken.getConversionType();
        if (this.arg instanceof Long) {
            value = (Long)this.arg;
        } else if (this.arg instanceof Integer) {
            value = ((Integer)this.arg).longValue();
        } else if (this.arg instanceof Short) {
            value = ((Short)this.arg).longValue();
        } else if (this.arg instanceof Byte) {
            value = ((Byte)this.arg).longValue();
        } else {
            throw this.badArgumentType();
        }
        if (this.formatToken.flagSharp) {
            if (currentConversionType == 'o') {
                result.append("0");
                ++startIndex;
            } else {
                result.append("0x");
                startIndex += 2;
            }
        }
        if ('d' == currentConversionType) {
            if (this.formatToken.flagComma) {
                result.append(this.arg);
            } else {
                result.append(value);
            }
            if (value < 0L) {
                if (this.formatToken.flagParenthesis) {
                    return this.wrapParentheses(result);
                }
                if (this.formatToken.flagZero) {
                    ++startIndex;
                }
            } else if (this.formatToken.flagAdd) {
                result.insert(0, '+');
                ++startIndex;
            } else if (this.formatToken.flagSpace) {
                result.insert(0, ' ');
                ++startIndex;
            }
        } else {
            if (this.arg instanceof Byte) {
                value &= 0xFFL;
            } else if (this.arg instanceof Short) {
                value &= 0xFFFFL;
            } else if (this.arg instanceof Integer) {
                value &= 0xFFFFFFFFL;
            }
            if ('o' == currentConversionType) {
                result.append(Long.toOctalString(value));
            } else {
                result.append(Long.toHexString(value));
            }
        }
        return this.padding(result, startIndex);
    }

    private CharSequence transformFromSpecialNumber() {
        if (!(this.arg instanceof Number)) {
            return null;
        }
        Number number = (Number)this.arg;
        double d = number.doubleValue();
        String source = null;
        if (Double.isNaN(d)) {
            source = "NaN";
        } else if (d == Double.POSITIVE_INFINITY) {
            source = this.formatToken.flagAdd ? "+Infinity" : (this.formatToken.flagSpace ? " Infinity" : "Infinity");
        } else if (d == Double.NEGATIVE_INFINITY) {
            source = this.formatToken.flagParenthesis ? "(Infinity)" : "-Infinity";
        } else {
            return null;
        }
        this.formatToken.setPrecision(-1);
        this.formatToken.flagZero = false;
        return this.padding(source, 0);
    }

    private CharSequence transformFromNull() {
        this.formatToken.flagZero = false;
        return this.padding("null", 0);
    }

    private CharSequence transformFromDateTime() {
        if (this.arg == null) {
            return this.transformFromNull();
        }
        Date date = null;
        if (this.arg instanceof Long) {
            date = new Date((Long)this.arg);
        } else if (this.arg instanceof Date) {
            date = (Date)this.arg;
        } else {
            throw this.badArgumentType();
        }
        StringBuilder result = new StringBuilder();
        result.append(date);
        return this.padding(result, 0);
    }

    private CharSequence transformFromFloat() {
        if (this.arg == null) {
            return this.transformFromNull();
        }
        if (!(this.arg instanceof Float) && !(this.arg instanceof Double)) {
            throw this.badArgumentType();
        }
        CharSequence specialNumberResult = this.transformFromSpecialNumber();
        if (specialNumberResult != null) {
            return specialNumberResult;
        }
        char conversionType = this.formatToken.getConversionType();
        if (conversionType != 'a' && conversionType != 'A' && !this.formatToken.isPrecisionSet()) {
            this.formatToken.setPrecision(6);
        }
        StringBuilder result = new StringBuilder();
        switch (conversionType) {
            case 'A': 
            case 'a': {
                this.transformA();
                break;
            }
            case 'E': 
            case 'e': {
                this.transformE(result);
                break;
            }
            case 'f': {
                this.transformF(result);
                break;
            }
            case 'G': 
            case 'g': {
                this.transformG(result);
                break;
            }
            default: {
                throw this.formatToken.unknownFormatConversionException();
            }
        }
        this.formatToken.setPrecision(-1);
        int startIndex = 0;
        if ('-' == result.charAt(0)) {
            if (this.formatToken.flagParenthesis) {
                return this.wrapParentheses(result);
            }
        } else {
            if (this.formatToken.flagSpace) {
                result.insert(0, ' ');
                ++startIndex;
            }
            if (this.formatToken.flagAdd) {
                result.insert(0, '+');
                ++startIndex;
            }
        }
        char firstChar = result.charAt(0);
        if (this.formatToken.flagZero && (firstChar == '+' || firstChar == '-')) {
            startIndex = 1;
        }
        if (conversionType == 'a' || conversionType == 'A') {
            startIndex += 2;
        }
        return this.padding(result, startIndex);
    }

    private void transformE(StringBuilder result) {
        StringBuilder pattern = new StringBuilder();
        pattern.append('0');
        if (this.formatToken.getPrecision() > 0) {
            pattern.append('.');
            char[] zeros = new char[this.formatToken.getPrecision()];
            Arrays.fill(zeros, '0');
            pattern.append(zeros);
        }
        pattern.append("E+00");
        String formattedString = this.arg.toString();
        result.append(formattedString.replace('E', 'e'));
        if (this.formatToken.flagSharp && this.formatToken.getPrecision() == 0) {
            int indexOfE = result.indexOf("e");
            result.insert(indexOfE, ".");
        }
    }

    private void transformG(StringBuilder result) {
        int precision = this.formatToken.getPrecision();
        precision = 0 == precision ? 1 : precision;
        this.formatToken.setPrecision(precision);
        double d = ((Number)this.arg).doubleValue();
        if (d == 0.0) {
            this.formatToken.setPrecision(--precision);
            this.transformF(result);
            return;
        }
        if (Double.isInfinite(d = Math.abs(d))) {
            precision = this.formatToken.getPrecision();
            this.formatToken.setPrecision(--precision);
            this.transformE(result);
            return;
        }
        this.transformF(result);
    }

    private void transformF(StringBuilder result) {
        result.append(this.arg);
    }

    private void transformA() {
        if (this.arg instanceof Float) {
            throw new RuntimeException("Float.toHexString is outside the GWT subset");
        }
        if (this.arg instanceof Double) {
            throw new RuntimeException("Double.toHexString is outside the GWT subset");
        }
        throw this.badArgumentType();
    }

    private static class FormatSpecifierParser {
        private final String format;
        private final int length;
        private int startIndex;
        private int i;

        FormatSpecifierParser(String format) {
            this.format = format;
            this.length = format.length();
        }

        FormatToken parseFormatToken(int offset) {
            this.startIndex = offset;
            this.i = offset;
            return this.parseArgumentIndexAndFlags(new FormatToken());
        }

        String getFormatSpecifierText() {
            return this.format.substring(this.startIndex, this.i);
        }

        private int peek() {
            return this.i < this.length ? (int)this.format.charAt(this.i) : -1;
        }

        private char advance() {
            if (this.i >= this.length) {
                throw this.unknownFormatConversionException();
            }
            return this.format.charAt(this.i++);
        }

        private UnknownFormatConversionException unknownFormatConversionException() {
            throw new UnknownFormatConversionException(this.getFormatSpecifierText());
        }

        private static boolean isDigit(int ch) {
            return ch >= 48 && ch <= 57;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private FormatToken parseArgumentIndexAndFlags(FormatToken token) {
            int position = this.i;
            int ch = this.peek();
            if (FormatSpecifierParser.isDigit(ch)) {
                int number = this.nextInt();
                if (this.peek() == 36) {
                    this.advance();
                    if (number == -1) {
                        throw new MissingFormatArgumentException(this.getFormatSpecifierText());
                    }
                    token.setArgIndex(Math.max(0, number - 1));
                } else {
                    if (ch != 48) return this.parseWidth(token, number);
                    this.i = position;
                }
            } else if (ch == 60) {
                token.setArgIndex(-2);
                this.advance();
            }
            while (token.setFlag(this.peek())) {
                this.advance();
            }
            ch = this.peek();
            if (FormatSpecifierParser.isDigit(ch)) {
                return this.parseWidth(token, this.nextInt());
            }
            if (ch != 46) return this.parseConversionType(token);
            return this.parsePrecision(token);
        }

        private FormatToken parseWidth(FormatToken token, int width) {
            token.setWidth(width);
            int ch = this.peek();
            if (ch == 46) {
                return this.parsePrecision(token);
            }
            return this.parseConversionType(token);
        }

        private FormatToken parsePrecision(FormatToken token) {
            this.advance();
            int ch = this.peek();
            if (FormatSpecifierParser.isDigit(ch)) {
                token.setPrecision(this.nextInt());
                return this.parseConversionType(token);
            }
            throw this.unknownFormatConversionException();
        }

        private FormatToken parseConversionType(FormatToken token) {
            char conversionType = this.advance();
            token.setConversionType(conversionType);
            if (conversionType == 't' || conversionType == 'T') {
                char dateSuffix = this.advance();
                token.setDateSuffix(dateSuffix);
            }
            return token;
        }

        private int nextInt() {
            long value = 0L;
            while (this.i < this.length && FormatSpecifierParser.isDigit(this.format.charAt(this.i))) {
                if ((value = 10L * value + (long)(this.format.charAt(this.i++) - 48)) <= Integer.MAX_VALUE) continue;
                return this.failNextInt();
            }
            return (int)value;
        }

        private int failNextInt() {
            while (FormatSpecifierParser.isDigit(this.peek())) {
                this.advance();
            }
            return -1;
        }
    }

    private static class FormatToken {
        static final int LAST_ARGUMENT_INDEX = -2;
        static final int UNSET = -1;
        static final int DEFAULT_PRECISION = 6;
        private int argIndex = -1;
        boolean flagAdd;
        boolean flagComma;
        boolean flagMinus;
        boolean flagParenthesis;
        boolean flagSharp;
        boolean flagSpace;
        boolean flagZero;
        private char conversionType = (char)65535;
        private char dateSuffix;
        private int precision = -1;
        private int width = -1;
        private StringBuilder strFlags;

        private FormatToken() {
        }

        private boolean isDefault() {
            return !this.flagAdd && !this.flagComma && !this.flagMinus && !this.flagParenthesis && !this.flagSharp && !this.flagSpace && !this.flagZero && this.width == -1 && this.precision == -1;
        }

        private boolean isPrecisionSet() {
            return this.precision != -1;
        }

        private int getArgIndex() {
            return this.argIndex;
        }

        private void setArgIndex(int index) {
            this.argIndex = index;
        }

        private int getWidth() {
            return this.width;
        }

        private void setWidth(int width) {
            this.width = width;
        }

        private int getPrecision() {
            return this.precision;
        }

        private void setPrecision(int precise) {
            this.precision = precise;
        }

        private String getStrFlags() {
            return this.strFlags != null ? this.strFlags.toString() : "";
        }

        private boolean setFlag(int ch) {
            boolean dupe = false;
            switch (ch) {
                case 43: {
                    dupe = this.flagAdd;
                    this.flagAdd = true;
                    break;
                }
                case 44: {
                    dupe = this.flagComma;
                    this.flagComma = true;
                    break;
                }
                case 45: {
                    dupe = this.flagMinus;
                    this.flagMinus = true;
                    break;
                }
                case 40: {
                    dupe = this.flagParenthesis;
                    this.flagParenthesis = true;
                    break;
                }
                case 35: {
                    dupe = this.flagSharp;
                    this.flagSharp = true;
                    break;
                }
                case 32: {
                    dupe = this.flagSpace;
                    this.flagSpace = true;
                    break;
                }
                case 48: {
                    dupe = this.flagZero;
                    this.flagZero = true;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (dupe) {
                throw new RuntimeException(String.valueOf(ch));
            }
            if (this.strFlags == null) {
                this.strFlags = new StringBuilder(7);
            }
            this.strFlags.append((char)ch);
            return true;
        }

        private char getConversionType() {
            return this.conversionType;
        }

        private void setConversionType(char c) {
            this.conversionType = c;
        }

        private void setDateSuffix(char c) {
            this.dateSuffix = c;
        }

        private boolean requireArgument() {
            return this.conversionType != '%' && this.conversionType != 'n';
        }

        private void checkFlags(Object arg) {
            boolean allowAdd = false;
            boolean allowComma = false;
            boolean allowMinus = true;
            boolean allowParenthesis = false;
            boolean allowSharp = false;
            boolean allowSpace = false;
            boolean allowZero = false;
            boolean allowPrecision = true;
            boolean allowWidth = true;
            boolean allowArgument = true;
            switch (this.conversionType) {
                case 'C': 
                case 'T': 
                case 'c': 
                case 't': {
                    allowPrecision = false;
                    break;
                }
                case 'G': 
                case 'g': {
                    allowZero = true;
                    allowSpace = true;
                    allowParenthesis = true;
                    allowComma = true;
                    allowAdd = true;
                    break;
                }
                case 'f': {
                    allowSpace = true;
                    allowSharp = true;
                    allowParenthesis = true;
                    allowComma = true;
                    allowAdd = true;
                    allowZero = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    allowZero = true;
                    allowSpace = true;
                    allowSharp = true;
                    allowParenthesis = true;
                    allowAdd = true;
                    break;
                }
                case 'A': 
                case 'a': {
                    allowZero = true;
                    allowSpace = true;
                    allowSharp = true;
                    allowAdd = true;
                    break;
                }
                case 'd': {
                    allowZero = true;
                    allowSpace = true;
                    allowParenthesis = true;
                    allowComma = true;
                    allowAdd = true;
                    allowPrecision = false;
                    break;
                }
                case 'X': 
                case 'o': 
                case 'x': {
                    allowZero = true;
                    allowSharp = true;
                    if (arg == null) {
                        allowSpace = true;
                        allowParenthesis = true;
                        allowAdd = true;
                    }
                    allowPrecision = false;
                    break;
                }
                case 'n': {
                    allowMinus = false;
                    allowWidth = false;
                    allowPrecision = false;
                    allowArgument = false;
                    break;
                }
                case '%': {
                    allowArgument = false;
                    allowPrecision = false;
                    break;
                }
                case 'B': 
                case 'H': 
                case 'S': 
                case 'b': 
                case 'h': 
                case 's': {
                    break;
                }
                default: {
                    throw new RuntimeException("unknownFormatConversionException");
                }
            }
            String mismatch = null;
            if (!allowAdd && this.flagAdd) {
                mismatch = "+";
            } else if (!allowComma && this.flagComma) {
                mismatch = ",";
            } else if (!allowMinus && this.flagMinus) {
                mismatch = "-";
            } else if (!allowParenthesis && this.flagParenthesis) {
                mismatch = "(";
            } else if (!allowSharp && this.flagSharp) {
                mismatch = "#";
            } else if (!allowSpace && this.flagSpace) {
                mismatch = " ";
            } else if (!allowZero && this.flagZero) {
                mismatch = "0";
            }
            if (mismatch != null) {
                if (this.conversionType == 'n') {
                    throw new RuntimeException("IllegalFormatFlagsException:" + mismatch);
                }
                throw new RuntimeException("FormatFlagsConversionMismatchException:" + mismatch + "," + this.conversionType);
            }
            if ((this.flagMinus || this.flagZero) && this.width == -1) {
                throw new MissingFormatWidthException("-" + this.conversionType);
            }
            if (!allowArgument && this.argIndex != -1) {
                throw new IllegalFormatFlagsException(this.getStrFlags());
            }
            if (!allowPrecision && this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (!allowWidth && this.width != -1) {
                throw new IllegalFormatWidthException(this.width);
            }
            if (this.flagAdd && this.flagSpace) {
                throw new IllegalFormatFlagsException("the '+' and ' ' flags are incompatible");
            }
            if (this.flagMinus && this.flagZero) {
                throw new IllegalFormatFlagsException("the '-' and '0' flags are incompatible");
            }
        }

        private UnknownFormatConversionException unknownFormatConversionException() {
            if (this.conversionType == 't' || this.conversionType == 'T') {
                throw new UnknownFormatConversionException(this.conversionType + "" + this.dateSuffix);
            }
            throw new UnknownFormatConversionException(String.valueOf(this.conversionType));
        }
    }
}

