/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.enums;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.enums.IScoutJsEnum;
import org.eclipse.scout.sdk.core.s.model.js.prop.IScoutJsPropertyValue;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsConstantValuePropertyValue;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeFulfillsEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class ConstantValueUnionScoutEnum
implements IScoutJsEnum {
    private final ScoutJsModel m_scoutJsModel;
    private final IDataType m_unionDataType;
    private final Set<IConstantValue> m_constantValues;
    private final FinalValue<List<String>> m_constants = new FinalValue();

    protected ConstantValueUnionScoutEnum(ScoutJsModel scoutJsModel, IDataType unionDataType, Set<IConstantValue> constantValues) {
        this.m_scoutJsModel = scoutJsModel;
        this.m_unionDataType = (IDataType)Ensure.notNull((Object)unionDataType);
        this.m_constantValues = (Set)Ensure.notNull(constantValues);
    }

    public static Optional<IScoutJsEnum> create(ScoutJsModel owner, IDataType unionDataType) {
        if (owner == null) {
            return Optional.empty();
        }
        LinkedHashSet constantValues = Optional.ofNullable(unionDataType).filter(dataType -> IDataType.DataTypeFlavor.Union == dataType.flavor()).stream().flatMap(IDataType::childTypes).map(IDataType::constantValue).flatMap(Optional::stream).collect(Collectors.toCollection(LinkedHashSet::new));
        if (constantValues.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ConstantValueUnionScoutEnum(owner, unionDataType, constantValues));
    }

    @Override
    public ScoutJsModel scoutJsModel() {
        return this.m_scoutJsModel;
    }

    @Override
    public String name() {
        return this.m_unionDataType.name();
    }

    @Override
    public IES6Class declaringClass() {
        return null;
    }

    @Override
    public String referenceName() {
        return null;
    }

    @Override
    public INodeElement topLevelReference() {
        return null;
    }

    protected Set<IConstantValue> constantValues() {
        return this.m_constantValues;
    }

    @Override
    public List<String> constants() {
        return (List)this.m_constants.computeIfAbsentAndGet(this::parseConstants);
    }

    protected List<String> parseConstants() {
        return this.constantValues().stream().map(IConstantValue::value).flatMap(Optional::stream).map(Object::toString).toList();
    }

    @Override
    public Stream<? extends IScoutJsPropertyValue> createPropertyValues(ScoutJsProperty property) {
        return this.constantValues().stream().map(v -> new ScoutJsConstantValuePropertyValue((IConstantValue)v, property));
    }

    @Override
    public boolean fulfills(IDataType dataType) {
        return new DataTypeFulfillsEvaluator(dt -> dt == this.m_unionDataType).fulfills(dataType);
    }

    public String toString() {
        return this.m_unionDataType.toString();
    }
}

