/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.nls;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.scout.sdk.core.s.nls.ITranslation;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.s.nls.manager.IStackedTranslation;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Strings;

public final class TranslationValidator {
    public static final int OK = 0;
    public static final int KEY_OVERRIDES_OTHER_STORE_WARNING = 100;
    public static final int KEY_IS_OVERRIDDEN_BY_OTHER_STORE_WARNING = 200;
    public static final int KEY_OVERRIDES_AND_IS_OVERRIDDEN_WARNING = 300;
    public static final int TEXT_INHERITED_BECOMES_ACTIVE_IF_REMOVED_WARNING = 400;
    public static final int KEY_ALREADY_EXISTS_ERROR = 40000;
    public static final int DEFAULT_TRANSLATION_MISSING_ERROR = 50000;
    public static final int KEY_EMPTY_ERROR = 70000;
    public static final int KEY_INVALID_ERROR = 80000;

    private TranslationValidator() {
    }

    public static int validateDefaultText(ITranslation newTranslation, IStackedTranslation existing, ITranslationStore target) {
        String defaultLangText = newTranslation.text(Language.LANGUAGE_DEFAULT).orElse(null);
        return TranslationValidator.validateDefaultText(defaultLangText, existing, target);
    }

    public static int validateDefaultText(CharSequence newDefaultText, String key, TranslationManager manager, ITranslationStore target) {
        IStackedTranslation translation = manager.translation(key).orElse(null);
        return TranslationValidator.validateDefaultText(newDefaultText, translation, target);
    }

    public static int validateDefaultText(CharSequence newDefaultText, IStackedTranslation existing, ITranslationStore target) {
        if (Strings.hasText((CharSequence)newDefaultText)) {
            return 0;
        }
        if (TranslationValidator.isOverriding(existing, Language.LANGUAGE_DEFAULT, target)) {
            return 400;
        }
        return 50000;
    }

    public static int validateText(CharSequence newText, IStackedTranslation current, Language language) {
        if (Strings.hasText((CharSequence)newText)) {
            return 0;
        }
        if (TranslationValidator.isOverriding(current, language, null)) {
            return 400;
        }
        return 0;
    }

    private static boolean isOverriding(IStackedTranslation current, Language language, ITranslationStore target) {
        if (current == null || language == null) {
            return false;
        }
        ITranslationStore targetStore = target;
        if (targetStore == null) {
            targetStore = current.primaryEditableStore().orElseThrow();
        }
        return current.isOverriding(language, targetStore);
    }

    public static boolean isForbidden(int result) {
        return result != 0 && result != 100 && result != 200 && result != 300 && result != 400;
    }

    public static int validateKey(String keyToValidate) {
        return TranslationValidator.validateKey(null, null, keyToValidate, Collections.singleton(keyToValidate));
    }

    public static int validateKey(TranslationManager manager, ITranslationStore target, String keyToValidate) {
        return TranslationValidator.validateKey(manager, target, keyToValidate, null);
    }

    public static int validateKey(TranslationManager manager, ITranslationStore target, String keyToValidate, Collection<String> acceptedKeys) {
        if (Strings.isBlank((CharSequence)keyToValidate)) {
            return 70000;
        }
        if (!ITranslation.KEY_REGEX.matcher(keyToValidate).matches()) {
            return 80000;
        }
        if (acceptedKeys != null && acceptedKeys.contains(keyToValidate)) {
            return 0;
        }
        if (target == null) {
            return 0;
        }
        if (target.containsKey(keyToValidate)) {
            return 40000;
        }
        if (manager == null) {
            return 0;
        }
        boolean hasStoresWithKeyOverridden = manager.allStores().filter(store -> store.containsKey(keyToValidate)).anyMatch(store -> store.service().order() > target.service().order());
        boolean hasStoresOverridingKey = manager.allStores().filter(store -> store.containsKey(keyToValidate)).anyMatch(store -> store.service().order() < target.service().order());
        if (hasStoresWithKeyOverridden && hasStoresOverridingKey) {
            return 300;
        }
        if (hasStoresWithKeyOverridden) {
            return 100;
        }
        if (hasStoresOverridingKey) {
            return 200;
        }
        return 0;
    }
}

