/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.project;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.transform.TransformerException;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.ApiVersion;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.java.apidef.ScoutApi;
import org.eclipse.scout.sdk.core.s.util.maven.MavenArtifactVersions;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.s.util.maven.MavenRunner;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ScoutProjectNewHelper {
    public static final String SCOUT_ARCHETYPES_GROUP_ID = "org.eclipse.scout.archetypes";
    public static final String SCOUT_ARCHETYPES_HELLOWORLD_ARTIFACT_ID = "scout-helloworld-app";
    public static final String SCOUT_ARCHETYPES_HELLOJS_ARTIFACT_ID = "scout-hellojs-app";
    public static final String SCOUT_ARCHETYPES_JAXWS_MODULE_ID = "scout-jaxws-module";
    public static final Pattern DISPLAY_NAME_PATTERN = Pattern.compile("[^\\\\<>=/:\"]+");
    public static final Pattern SYMBOLIC_NAME_PATTERN = Pattern.compile("^[a-z][a-z\\d_]{0,32}(?:\\.[a-z][a-z\\d_]{0,32}){0,16}$");
    public static final String PROPERTY_SDK_PROJECT_NEW = "scoutSdkProjectNew";

    private ScoutProjectNewHelper() {
    }

    public static void createProject(Path workingDir, String groupId, String artifactId, String displayName, boolean useJsUiLanguage, String javaVersion, IEnvironment env, IProgress progress) throws IOException {
        ScoutProjectNewHelper.createProject(workingDir, groupId, artifactId, displayName, useJsUiLanguage, javaVersion, null, env, progress);
    }

    public static void createProject(Path workingDir, String groupId, String artifactId, String displayName, boolean useJsUiLanguage, String javaVersion, String archetypeVersion, IEnvironment env, IProgress progress) throws IOException {
        String archetypeArtifactId = useJsUiLanguage ? SCOUT_ARCHETYPES_HELLOJS_ARTIFACT_ID : SCOUT_ARCHETYPES_HELLOWORLD_ARTIFACT_ID;
        ScoutProjectNewHelper.createProject(workingDir, groupId, artifactId, displayName, javaVersion, null, archetypeArtifactId, archetypeVersion, env, progress);
    }

    public static void createProject(Path workingDir, String groupId, String artifactId, String displayName, String javaVersion, String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, IEnvironment env, IProgress progress) throws IOException {
        Ensure.notNull((Object)workingDir);
        String groupIdMsg = ScoutProjectNewHelper.getMavenGroupIdErrorMessage(groupId);
        if (groupIdMsg != null) {
            throw new IllegalArgumentException(groupIdMsg);
        }
        String artifactIdMsg = ScoutProjectNewHelper.getMavenArtifactIdErrorMessage(artifactId);
        if (artifactIdMsg != null) {
            throw new IllegalArgumentException(artifactIdMsg);
        }
        String displayNameMsg = ScoutProjectNewHelper.getDisplayNameErrorMessage(displayName);
        if (displayNameMsg != null) {
            throw new IllegalArgumentException(displayNameMsg);
        }
        if (Strings.isBlank((CharSequence)archetypeGroupId)) {
            archetypeGroupId = SCOUT_ARCHETYPES_GROUP_ID;
        }
        if (Strings.isBlank((CharSequence)archetypeArtifactId)) {
            archetypeArtifactId = SCOUT_ARCHETYPES_HELLOWORLD_ARTIFACT_ID;
        }
        if (Strings.isBlank((CharSequence)archetypeVersion)) {
            archetypeVersion = "LATEST";
        }
        if (Strings.isEmpty((CharSequence)javaVersion)) {
            int selectedJavaVersion = Arrays.stream(ScoutProjectNewHelper.getSupportedJavaVersions(archetypeVersion)).max().orElseThrow();
            javaVersion = Integer.toString(selectedJavaVersion);
        }
        String pck = ScoutProjectNewHelper.getPackage(groupId, artifactId);
        String artifactName = ScoutProjectNewHelper.getArtifactName(artifactId);
        Files.createDirectories(workingDir, new FileAttribute[0]);
        MavenBuild archetypeBuild = new MavenBuild().withWorkingDirectory(workingDir).withGoal("archetype:generate").withProperty("interactiveMode", "false").withProperty("archetypeGroupId", archetypeGroupId).withProperty("archetypeArtifactId", archetypeArtifactId).withProperty("archetypeVersion", archetypeVersion).withProperty("groupId", groupId).withProperty("artifactId", artifactId).withProperty("version", "1.0.0-SNAPSHOT").withProperty("package", pck).withProperty("displayName", displayName).withProperty("javaVersion", javaVersion).withProperty("simpleArtifactName", artifactName).withProperty("userName", CoreUtils.getUsername()).withProperty(PROPERTY_SDK_PROJECT_NEW);
        if (SdkLog.isDebugEnabled()) {
            archetypeBuild.withProperty("debug", "true");
        }
        MavenRunner.execute(archetypeBuild, env, progress);
        ScoutProjectNewHelper.postProcessRootPom(workingDir.resolve(artifactId));
    }

    static void postProcessRootPom(Path targetDirectory) throws IOException {
        try {
            Path pom = targetDirectory.resolve("pom.xml");
            if (!Files.isReadable(pom) || !Files.isRegularFile(pom, new LinkOption[0])) {
                return;
            }
            Document doc = Xml.get((Path)pom);
            Element modules = (Element)Xml.firstChildElement((Node)doc.getDocumentElement(), (String)"modules").orElseThrow();
            NodeList childNodes = modules.getChildNodes();
            String targetDirectoryName = targetDirectory.getFileName().toString();
            List<Node> nodesToRemove = IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).filter(n -> ScoutProjectNewHelper.isNodeToRemove(n, targetDirectoryName)).toList();
            nodesToRemove.forEach(modules::removeChild);
            Ensure.isTrue((modules.getChildNodes().getLength() == 1 ? 1 : 0) != 0, (CharSequence)"Parent module is missing in root pom.", (Object[])new Object[0]);
            Xml.writeDocument((Document)doc, (boolean)true, (Path)pom);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    static boolean isNodeToRemove(Node n, CharSequence targetDirectoryName) {
        if (n == null) {
            return false;
        }
        if (n.getNodeType() == 3) {
            return true;
        }
        return n.getNodeType() == 1 && "module".equals(((Element)n).getTagName()) && !Strings.equals((CharSequence)targetDirectoryName, (CharSequence)Strings.trim((CharSequence)n.getTextContent()));
    }

    static String getArtifactName(String artifactId) {
        int pos = artifactId.lastIndexOf(46);
        if (pos < 0 || pos >= artifactId.length() - 1) {
            return artifactId;
        }
        return artifactId.substring(pos + 1);
    }

    static String getPackage(String groupId, String artifactId) {
        if (artifactId.startsWith(groupId)) {
            return artifactId;
        }
        return groupId + '.' + artifactId;
    }

    public static String getDisplayNameErrorMessage(CharSequence displayNameCandidate) {
        if (Strings.isEmpty((CharSequence)displayNameCandidate)) {
            return "Display Name is not set.";
        }
        if (!DISPLAY_NAME_PATTERN.matcher(displayNameCandidate).matches()) {
            return "The Display Name must not contain these characters: \\\"/<>:=";
        }
        return null;
    }

    public static String getMavenArtifactIdErrorMessage(String artifactIdCandidate) {
        return ScoutProjectNewHelper.getMavenNameErrorMessage(artifactIdCandidate, "Artifact Id");
    }

    public static String getMavenGroupIdErrorMessage(String groupIdCandidate) {
        return ScoutProjectNewHelper.getMavenNameErrorMessage(groupIdCandidate, "Group Id");
    }

    private static String getMavenNameErrorMessage(String nameCandidate, String attributeName) {
        if (Strings.isEmpty((CharSequence)nameCandidate)) {
            return attributeName + " is not set.";
        }
        if (!SYMBOLIC_NAME_PATTERN.matcher(nameCandidate).matches()) {
            return "The " + attributeName + " value is not valid.";
        }
        String jkw = ScoutProjectNewHelper.getContainingJavaKeyWord(nameCandidate);
        if (jkw != null) {
            return "The " + attributeName + " must not contain the Java keyword '" + jkw + "'.";
        }
        return null;
    }

    private static String getContainingJavaKeyWord(String s) {
        return JavaTypes.getJavaKeyWords().stream().filter(keyWord -> s.startsWith(keyWord + ".") || s.endsWith("." + keyWord) || s.contains("." + keyWord + ".")).findAny().orElse(null);
    }

    public static int[] getSupportedJavaVersions(CharSequence scoutVersion) {
        return ScoutApi.create(scoutVersion).supportedJavaVersions();
    }

    public static List<String> getSupportedArchetypeVersions(boolean useJavaClient, boolean includePreviewVersions) throws IOException {
        String artifactId = useJavaClient ? SCOUT_ARCHETYPES_HELLOWORLD_ARTIFACT_ID : SCOUT_ARCHETYPES_HELLOJS_ARTIFACT_ID;
        ApiVersion min = ScoutApi.allKnown().map(IApiSpecification::maxLevel).min(Comparator.naturalOrder()).orElseThrow();
        return MavenArtifactVersions.allOnCentral(SCOUT_ARCHETYPES_GROUP_ID, artifactId).map(ApiVersion::parse).flatMap(Optional::stream).filter(v -> v.compareCommonSegmentsTo(min) >= 0).filter(v -> includePreviewVersions || Strings.isEmpty((CharSequence)v.suffix())).map(ApiVersion::asString).collect(Collectors.toList());
    }
}

