/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.apidef.OptApiFunction;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.util.ITier;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.visitor.DefaultDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.IDepthFirstVisitor;
import org.eclipse.scout.sdk.core.util.visitor.TreeTraversals;

public final class TierTree {
    private static final TierTree INSTANCE = TierTree.create();
    private TierNode m_root;
    private final Map<ITier<?>, TierNode> m_tiers = new HashMap();

    private TierTree() {
    }

    static TierTree create() {
        return new TierTree();
    }

    public static boolean addDependency(ITier<?> tier, ITier<?> dependency) {
        return INSTANCE.addDependencyImpl(tier, dependency);
    }

    synchronized boolean addDependencyImpl(ITier<?> tier, ITier<?> dependency) {
        Ensure.notNull(tier, (CharSequence)"tier is null", (Object[])new Object[0]);
        Ensure.notNull(dependency, (CharSequence)"dependency is null", (Object[])new Object[0]);
        if (this.m_tiers.containsKey(tier) && this.m_tiers.containsKey(dependency)) {
            return false;
        }
        if (!(this.m_tiers.isEmpty() || this.m_tiers.containsKey(tier) || this.m_tiers.containsKey(dependency))) {
            return false;
        }
        TierNode tierNode = this.m_tiers.computeIfAbsent(tier, TierNode::of);
        TierNode dependencyNode = this.m_tiers.computeIfAbsent(dependency, TierNode::of);
        if (this.m_root == null || this.m_root.isTier(tier)) {
            this.m_root = dependencyNode;
        }
        return dependencyNode.addChildren(tierNode);
    }

    synchronized boolean hasDependencyImpl(ITier<?> tier, ITier<?> dependency) {
        TierNode tierNode = this.m_tiers.get(tier);
        if (tierNode == null) {
            return false;
        }
        for (TierNode currentNode = tierNode.getParent(); currentNode != null; currentNode = currentNode.getParent()) {
            if (!currentNode.isTier(dependency)) continue;
            return true;
        }
        return false;
    }

    static boolean isAvailable(ITier<?> tier, ITier<?> other) {
        return INSTANCE.isAvailableImpl(tier, other);
    }

    synchronized boolean isAvailableImpl(ITier<?> tier, ITier<?> other) {
        if (!this.m_tiers.containsKey(tier)) {
            return false;
        }
        return tier.equals(other) || this.hasDependencyImpl(tier, other);
    }

    public static List<ITier<?>> topDownPath(ITier<?> top, ITier<?> bottom) {
        return INSTANCE.topDownPathImpl(top, bottom);
    }

    synchronized List<ITier<?>> topDownPathImpl(ITier<?> top, ITier<?> bottom) {
        TierNode toNode = this.m_tiers.get(bottom);
        if (toNode == null) {
            return Collections.emptyList();
        }
        ArrayList path = new ArrayList();
        TierNode currentNode = toNode;
        path.add(currentNode.getTier());
        do {
            if ((currentNode = currentNode.getParent()) == null) continue;
            path.addFirst(currentNode.getTier());
        } while (currentNode != null && !currentNode.isTier(top));
        if (currentNode == null && top != null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(path);
    }

    static Optional<ITier<?>> tierOf(IJavaElement element) {
        return Optional.ofNullable(element).map(IJavaElement::javaEnvironment).flatMap(TierTree::tierOf);
    }

    static Optional<ITier<?>> tierOf(IJavaEnvironment env) {
        return Optional.ofNullable(env).flatMap(e -> TierTree.tierOf(arg_0 -> ((IJavaEnvironment)e).exists(arg_0), arg_0 -> ((IJavaEnvironment)e).api(arg_0)));
    }

    static Optional<ITier<?>> tierOf(Predicate<String> typeLookupStrategy, OptApiFunction optApiFunction) {
        return INSTANCE.tierOfImpl(typeLookupStrategy, optApiFunction);
    }

    synchronized Optional<ITier<?>> tierOfImpl(final Predicate<String> typeLookupStrategy, final OptApiFunction optApiFunction) {
        final AtomicReference tier = new AtomicReference();
        TreeTraversals.create((IDepthFirstVisitor)new DefaultDepthFirstVisitor<TierNode>(this){

            public boolean postVisit(TierNode tierNode, int level, int index) {
                if (typeLookupStrategy.test(tierNode.getTier().getLookupFqn(optApiFunction))) {
                    tier.set(tierNode.getTier());
                    return false;
                }
                return true;
            }
        }, TierNode::children).traverse((Object)this.m_root);
        return Optional.ofNullable((ITier)tier.get());
    }

    static {
        ScoutTier.initTierTree();
    }

    private static final class TierNode {
        private final ITier<?> m_tier;
        private TierNode m_parent;
        private final Collection<TierNode> m_children = new HashSet<TierNode>();

        private TierNode(ITier<?> tier) {
            this.m_tier = (ITier)Ensure.notNull(tier, (CharSequence)"tier is null", (Object[])new Object[0]);
        }

        private static TierNode of(ITier<?> tier) {
            return new TierNode(tier);
        }

        private ITier<?> getTier() {
            return this.m_tier;
        }

        private boolean isTier(ITier<?> tier) {
            return this.m_tier.equals(tier);
        }

        private void setParent(TierNode parent) {
            this.m_parent = parent;
        }

        private TierNode getParent() {
            return this.m_parent;
        }

        private Stream<TierNode> children() {
            return this.m_children.stream();
        }

        private boolean addChildren(TierNode tierNode) {
            tierNode.setParent(this);
            return this.m_children.add(tierNode);
        }
    }
}

